/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.List;
import java.util.Objects;
import java.util.function.DoubleBinaryOperator;
import java.util.stream.IntStream;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.SeveralNumbersOperation;
import net.algart.math.IRange;

public final class NumbersPolarToCartesian
extends SeveralNumbersOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_R = "r";
    public static final String INPUT_FI = "fi";
    public static final String INPUT_R_FI = "r_fi";
    public static final String OUTPUT_X = "x";
    public static final String OUTPUT_Y = "y";
    public static final String OUTPUT_X_Y = "x_y";
    private static final double PI_2 = Math.PI * 2;
    private AngleMultiplier angleMultiplier = AngleMultiplier.NONE;
    private double customAngleMultiplier = 1.0;

    public NumbersPolarToCartesian() {
        super(INPUT_R, INPUT_FI, INPUT_R_FI);
        this.useVisibleResultParameter();
        this.setDefaultOutputNumbers(OUTPUT_X_Y);
        this.addOutputNumbers(OUTPUT_X);
        this.addOutputNumbers(OUTPUT_Y);
    }

    public AngleMultiplier getAngleMultiplier() {
        return this.angleMultiplier;
    }

    public NumbersPolarToCartesian setAngleMultiplier(AngleMultiplier angleMultiplier) {
        this.angleMultiplier = NumbersPolarToCartesian.nonNull(angleMultiplier);
        return this;
    }

    public double getCustomAngleMultiplier() {
        return this.customAngleMultiplier;
    }

    public NumbersPolarToCartesian setCustomAngleMultiplier(double customAngleMultiplier) {
        this.customAngleMultiplier = customAngleMultiplier;
        return this;
    }

    @Override
    protected SNumbers processNumbers(List<SNumbers> sources) {
        SNumbers r = sources.get(0);
        SNumbers fi = sources.get(1);
        SNumbers r_fi = sources.get(2);
        if (r_fi != null) {
            r_fi.requireBlockLength(2, "r/fi");
        }
        if (r != null) {
            r.requireInitialized(INPUT_R).requireBlockLength(1, INPUT_R);
        } else {
            r = NumbersPolarToCartesian.checkRFi(r_fi, INPUT_R).columnRange(0, 1);
        }
        if (fi != null) {
            fi.requireInitialized(INPUT_FI).requireBlockLength(1, INPUT_FI);
        } else {
            fi = NumbersPolarToCartesian.checkRFi(r_fi, INPUT_FI).columnRange(1, 1);
        }
        float[] rArray = r.toFloatArray();
        float[] fiArray = fi.toFloatArray();
        SNumbers result = new SNumbers();
        if (this.isOutputNecessary(OUTPUT_X_Y)) {
            float[] xy = this.polarToXY(rArray, fiArray);
            result.setTo(xy, 2);
            if (this.isOutputNecessary(OUTPUT_X)) {
                this.getNumbers(OUTPUT_X).replaceColumnRange(0, result, 0, 1);
            }
            if (this.isOutputNecessary(OUTPUT_Y)) {
                this.getNumbers(OUTPUT_Y).replaceColumnRange(0, result, 1, 1);
            }
        } else {
            if (this.isOutputNecessary(OUTPUT_X)) {
                this.getNumbers(OUTPUT_X).setTo(this.polarToX(rArray, fiArray), 1);
            }
            if (this.isOutputNecessary(OUTPUT_Y)) {
                this.getNumbers(OUTPUT_Y).setTo(this.polarToY(rArray, fiArray), 1);
            }
        }
        return result;
    }

    public float[] polarToX(float[] r, float[] fi) {
        Objects.requireNonNull(r, "Null r");
        Objects.requireNonNull(fi, "Null fi");
        if (r.length != fi.length) {
            throw new IllegalArgumentException("Different lengths of r and fi");
        }
        float[] result = new float[r.length];
        IntStream.range(0, r.length + 255 >>> 8).parallel().forEach(block -> {
            int i;
            int to = (int)Math.min((long)i + 256L, (long)r.length);
            for (i = block << 8; i < to; ++i) {
                double rValue = r[i];
                double fiValue = this.angleMultiplier.multiplier.applyAsDouble(fi[i], this.customAngleMultiplier);
                result[i] = (float)(rValue * Math.cos(fiValue));
            }
        });
        return result;
    }

    public float[] polarToY(float[] r, float[] fi) {
        Objects.requireNonNull(r, "Null r");
        Objects.requireNonNull(fi, "Null fi");
        if (r.length != fi.length) {
            throw new IllegalArgumentException("Different lengths of r and fi");
        }
        float[] result = new float[r.length];
        IntStream.range(0, r.length + 255 >>> 8).parallel().forEach(block -> {
            int i;
            int to = (int)Math.min((long)i + 256L, (long)r.length);
            for (i = block << 8; i < to; ++i) {
                double rValue = r[i];
                double fiValue = this.angleMultiplier.multiplier.applyAsDouble(fi[i], this.customAngleMultiplier);
                result[i] = (float)(rValue * Math.sin(fiValue));
            }
        });
        return result;
    }

    public float[] polarToXY(float[] r, float[] fi) {
        Objects.requireNonNull(r, "Null r");
        Objects.requireNonNull(fi, "Null fi");
        if (r.length != fi.length) {
            throw new IllegalArgumentException("Different lengths of r and fi");
        }
        float[] result = new float[2 * r.length];
        IntStream.range(0, r.length + 255 >>> 8).parallel().forEach(block -> {
            int i;
            int disp = 2 * i;
            int to = (int)Math.min((long)i + 256L, (long)r.length);
            for (i = block << 8; i < to; ++i) {
                double rValue = r[i];
                double fiValue = this.angleMultiplier.multiplier.applyAsDouble(fi[i], this.customAngleMultiplier);
                result[disp++] = (float)(rValue * Math.cos(fiValue));
                result[disp++] = (float)(rValue * Math.sin(fiValue));
            }
        });
        return result;
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return true;
    }

    @Override
    protected boolean blockLengthEqualityRequired() {
        return false;
    }

    @Override
    protected IRange selectedColumnRange(int inputIndex) {
        int start = this.getIndexInBlock(inputIndex);
        return IRange.of((long)start, (long)(inputIndex == 2 ? (long)(start + 1) : (long)start));
    }

    private static SNumbers checkRFi(SNumbers rFi, String rOrFiName) {
        if (rFi == null || !rFi.isInitialized()) {
            throw new IllegalArgumentException("The \"r/fi\" port has no initialized data, but they are required, because \"" + rOrFiName + "\" is also empty");
        }
        return rFi;
    }

    public static enum AngleMultiplier {
        NONE((angle, custom) -> angle),
        MULTIPLIER_TO_RADIANS((angle, custom) -> Math.toRadians(angle)),
        MULTIPLIER_PI((angle, custom) -> Math.PI * angle),
        MULTIPLIER_2PI((angle, custom) -> Math.PI * 2 * angle),
        CUSTOM((angle, custom) -> angle * custom);

        private final DoubleBinaryOperator multiplier;

        private AngleMultiplier(DoubleBinaryOperator multiplier) {
            this.multiplier = multiplier;
        }
    }
}

