/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;

public final class SplitNumbersColumns
extends Executor
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_PORT_PREFIX = "output_";
    private boolean inputRequired = true;

    public SplitNumbersColumns() {
        this.useVisibleResultParameter();
        this.addInputNumbers(DEFAULT_INPUT_PORT);
    }

    public boolean isInputRequired() {
        return this.inputRequired;
    }

    public SplitNumbersColumns setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
        return this;
    }

    @Override
    public void process() {
        SNumbers numbers = this.getInputNumbers(!this.inputRequired);
        if (!numbers.isInitialized()) {
            return;
        }
        int m = numbers.getBlockLength();
        for (int k = 0; k < m; ++k) {
            String portName = this.outputPortName(k);
            if (!this.isOutputNecessary(portName)) continue;
            this.getNumbers(portName).setTo(numbers.column(k));
        }
    }

    @Override
    public String translateLegacyParameterAlias(String name) {
        return name.equals("requireInput") ? "inputRequired" : name;
    }

    private String outputPortName(int outputIndex) {
        return OUTPUT_PORT_PREFIX + (outputIndex + 1);
    }
}

