/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.io;

import net.algart.executors.api.LogLevel;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.scalars.conversions.JoinNumbersToScalar;
import net.algart.executors.modules.core.scalars.io.PrintScalar;

public final class PrintNumbers
extends JoinNumbersToScalar {
    public static final String S = "s";
    public static final String X = "x";
    public static final String M = "m";
    private String pattern = "$$$";
    private LogLevel logLevel = LogLevel.INFO;
    private String file = "";

    public PrintNumbers() {
        this.addInputScalar(S);
        this.addInputNumbers(X);
        this.addInputMat(M);
        this.addOutputScalar(S);
        this.addOutputNumbers(X);
        this.addOutputMat(M);
    }

    public static PrintNumbers getInstance() {
        return new PrintNumbers();
    }

    public String getPattern() {
        return this.pattern;
    }

    public PrintNumbers setPattern(String pattern) {
        this.pattern = PrintNumbers.nonNull(pattern);
        return this;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public PrintNumbers setLogLevel(LogLevel logLevel) {
        this.logLevel = PrintNumbers.nonNull(logLevel);
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public PrintNumbers setFile(String file) {
        this.file = PrintNumbers.nonNull(file);
        return this;
    }

    @Override
    public SScalar analyse(SNumbers source) {
        this.getScalar(S).exchange(this.getInputScalar(S, true));
        this.getNumbers(X).exchange(this.getInputNumbers(X, true));
        this.getMat(M).exchange(this.getInputMat(M, true));
        String result = PrintScalar.getInstance().setPattern(this.pattern).setLogLevel(this.logLevel).setFile(this.file).print(() -> super.join(source), this.isOutputNecessary(this.defaultOutputPortName()));
        return SScalar.of(result);
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }
}

