/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.numbers.NumbersToScalar;

public final class GetNumber
extends NumbersToScalar
implements ReadOnlyExecutionInput {
    private int blockIndex = 0;
    private int indexInBlock = 0;
    private Integer rawIndex = null;

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public GetNumber setBlockIndex(int blockIndex) {
        this.blockIndex = GetNumber.nonNegative(blockIndex);
        return this;
    }

    public int getIndexInBlock() {
        return this.indexInBlock;
    }

    public GetNumber setIndexInBlock(int indexInBlock) {
        this.indexInBlock = GetNumber.nonNegative(indexInBlock);
        return this;
    }

    public Integer getRawIndex() {
        return this.rawIndex;
    }

    public GetNumber setRawIndex(Integer rawIndex) {
        this.rawIndex = rawIndex == null ? null : Integer.valueOf(GetNumber.nonNegative(rawIndex));
        return this;
    }

    @Override
    public SScalar analyse(SNumbers source) {
        int indexInArray;
        int n = indexInArray = this.rawIndex != null ? this.rawIndex : this.blockIndex * source.getBlockLength() + this.indexInBlock;
        if (source.isLongArray()) {
            return SScalar.of(((long[])source.arrayReference())[indexInArray]);
        }
        if (source.isFloatingPoint()) {
            return SScalar.of(source.getValue(indexInArray));
        }
        return SScalar.of((long)source.getValue(indexInArray));
    }
}

