/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import java.util.Arrays;
import java.util.Locale;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.numbers.NumbersToScalar;
import net.algart.executors.modules.core.numbers.misc.SimpleArrayStatistics;

public final class NumbersInfo
extends NumbersToScalar
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_N = "n";
    public static final String OUTPUT_BLOCK_LENGTH = "block_length";
    public static final String OUTPUT_ARRAY_LENGTH = "array_length";
    public static final String OUTPUT_ELEMENT_TYPE = "element_type";
    public static final String OUTPUT_MAX_POSSIBLE = "max_possible";
    private int indexInBlock = 0;
    private int lengthInBlock = 0;

    public NumbersInfo() {
        this.useVisibleResultParameter();
        this.setDefaultOutputScalar(OUTPUT_N);
        this.addOutputScalar(OUTPUT_BLOCK_LENGTH);
        this.addOutputScalar(OUTPUT_ARRAY_LENGTH);
        this.addOutputScalar(OUTPUT_ELEMENT_TYPE);
        this.addOutputScalar(OUTPUT_MAX_POSSIBLE);
        for (SimpleArrayStatistics statistics : SimpleArrayStatistics.values()) {
            this.addOutputScalar(statistics.statisticsName());
        }
    }

    public int getIndexInBlock() {
        return this.indexInBlock;
    }

    public NumbersInfo setIndexInBlock(int indexInBlock) {
        this.indexInBlock = NumbersInfo.nonNegative(indexInBlock);
        return this;
    }

    public int getLengthInBlock() {
        return this.lengthInBlock;
    }

    public NumbersInfo setLengthInBlock(int lengthInBlock) {
        this.lengthInBlock = NumbersInfo.nonNegative(lengthInBlock);
        return this;
    }

    @Override
    public SScalar analyse(SNumbers source) {
        if (!source.isInitialized()) {
            return new SScalar();
        }
        long t1 = NumbersInfo.debugTime();
        int indexInBlock = this.lengthInBlock > 0 ? this.indexInBlock : 0;
        int lengthInBlock = this.lengthInBlock > 0 ? this.lengthInBlock : source.getBlockLength();
        boolean allQuick = Arrays.stream(SimpleArrayStatistics.values()).filter(statistics -> this.isOutputNecessary(statistics.statisticsName())).allMatch(SimpleArrayStatistics::isQuickRangeInBlockProcessing);
        if (!(allQuick || indexInBlock == 0 && lengthInBlock == source.getBlockLength())) {
            source = source.columnRange(indexInBlock, lengthInBlock);
            indexInBlock = 0;
        }
        this.getScalar(OUTPUT_BLOCK_LENGTH).setTo(source.getBlockLength());
        this.getScalar(OUTPUT_ARRAY_LENGTH).setTo(source.getArrayLength());
        this.getScalar(OUTPUT_ELEMENT_TYPE).setTo(source.elementType());
        this.getScalar(OUTPUT_MAX_POSSIBLE).setTo(source.asNumberArray().maxPossibleValue(1.0));
        long t2 = NumbersInfo.debugTime();
        for (SimpleArrayStatistics statistics2 : SimpleArrayStatistics.values()) {
            if (!this.isOutputNecessary(statistics2.statisticsName())) continue;
            this.getScalar(statistics2.statisticsName()).setTo(statistics2.statistics(source, indexInBlock, lengthInBlock));
        }
        long t3 = NumbersInfo.debugTime();
        NumbersInfo.logDebug(String.format(Locale.US, "Calculating simple numbers statistics: %.3f ms = %.3f ms %s + %.3f ms processing", (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, allQuick ? "initializing" : "extracting columns", (double)(t3 - t2) * 1.0E-6));
        return SScalar.of(source.n());
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }
}

