/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.numbers.NumbersToScalar;

public final class NumbersLength
extends NumbersToScalar
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_BLOCK_LENGTH = "block_length";
    private LengthType lengthType = LengthType.NUMBER_OF_BLOCKS;
    private boolean inputRequired = false;

    public NumbersLength() {
        this.addOutputScalar(OUTPUT_BLOCK_LENGTH);
    }

    public boolean isInputRequired() {
        return this.inputRequired;
    }

    public NumbersLength setInputRequired(boolean inputRequired) {
        this.inputRequired = inputRequired;
        return this;
    }

    public LengthType getLengthType() {
        return this.lengthType;
    }

    public NumbersLength setLengthType(LengthType lengthType) {
        this.lengthType = NumbersLength.nonNull(lengthType);
        return this;
    }

    @Override
    public SScalar analyse(SNumbers source) {
        this.getScalar(OUTPUT_BLOCK_LENGTH).setTo(source.getBlockLength());
        return SScalar.of(this.lengthType == LengthType.NUMBER_OF_BLOCKS ? source.n() : source.getArrayLength());
    }

    @Override
    public String translateLegacyParameterAlias(String name) {
        return name.equals("requireInput") ? "inputRequired" : name;
    }

    @Override
    protected boolean allowUninitializedInput() {
        return !this.inputRequired;
    }

    public static enum LengthType {
        NUMBER_OF_BLOCKS,
        RAW_ARRAY_LENGTH;

    }
}

