/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import net.algart.arrays.Arrays;
import net.algart.arrays.PArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.math.IRange;

public final class SimpleArrayStatistics
extends Enum<SimpleArrayStatistics> {
    public static final /* enum */ SimpleArrayStatistics MEAN = new SimpleArrayStatistics("mean", n -> Arrays.sumOf((PArray)n.asNumberArray()) / (double)n.getArrayLength());
    public static final /* enum */ SimpleArrayStatistics SUM = new SimpleArrayStatistics("sum", n -> Arrays.sumOf((PArray)n.asNumberArray()));
    public static final /* enum */ SimpleArrayStatistics MIN = new SimpleArrayStatistics("min", (n, r) -> n.minInColumnRange((int)r.min(), (int)r.size(), false));
    public static final /* enum */ SimpleArrayStatistics MAX = new SimpleArrayStatistics("max", (n, r) -> n.maxInColumnRange((int)r.min(), (int)r.size(), false));
    public static final /* enum */ SimpleArrayStatistics MAX_ABS = new SimpleArrayStatistics("max_abs", (n, r) -> n.maxAbsInColumnRange((int)r.min(), (int)r.size(), false));
    public static final /* enum */ SimpleArrayStatistics MIN_OF_ORDINARY = new SimpleArrayStatistics("min_of_ordinary", (n, r) -> n.minInColumnRange((int)r.min(), (int)r.size(), true));
    public static final /* enum */ SimpleArrayStatistics MAX_OF_ORDINARY = new SimpleArrayStatistics("max_of_ordinary", (n, r) -> n.maxInColumnRange((int)r.min(), (int)r.size(), true));
    public static final /* enum */ SimpleArrayStatistics MAX_ABS_OF_ORDINARY = new SimpleArrayStatistics("max_abs_of_ordinary", (n, r) -> n.maxAbsInColumnRange((int)r.min(), (int)r.size(), true));
    public static final /* enum */ SimpleArrayStatistics HASH = new SimpleArrayStatistics("hash", SNumbers::hashCode);
    private final boolean quickRangeInBlockProcessing;
    private final String statisticsName;
    private final ToDoubleFunction<SNumbers> fullStatistics;
    private final ToDoubleBiFunction<SNumbers, IRange> rangeStatistics;
    private static final /* synthetic */ SimpleArrayStatistics[] $VALUES;

    public static SimpleArrayStatistics[] values() {
        return (SimpleArrayStatistics[])$VALUES.clone();
    }

    public static SimpleArrayStatistics valueOf(String name) {
        return Enum.valueOf(SimpleArrayStatistics.class, name);
    }

    private SimpleArrayStatistics(String statisticsName, ToDoubleFunction<SNumbers> fullStatistics) {
        this.statisticsName = statisticsName;
        this.quickRangeInBlockProcessing = false;
        this.fullStatistics = fullStatistics;
        this.rangeStatistics = null;
    }

    private SimpleArrayStatistics(String statisticsName, ToDoubleBiFunction<SNumbers, IRange> rangeStatistics) {
        this.statisticsName = statisticsName;
        this.quickRangeInBlockProcessing = true;
        this.fullStatistics = null;
        this.rangeStatistics = rangeStatistics;
    }

    public String statisticsName() {
        return this.statisticsName;
    }

    public boolean isQuickRangeInBlockProcessing() {
        return this.quickRangeInBlockProcessing;
    }

    public double statistics(SNumbers numbers, int indexInBlock, int lengthInBlock) {
        numbers.checkStartIndexAndLenthInBlock(indexInBlock, lengthInBlock, true);
        if (this.quickRangeInBlockProcessing) {
            IRange range = IRange.of((long)indexInBlock, (long)(indexInBlock + lengthInBlock - 1));
            assert (this.rangeStatistics != null);
            return this.rangeStatistics.applyAsDouble(numbers, range);
        }
        if (indexInBlock != 0 || lengthInBlock != numbers.getBlockLength()) {
            numbers = numbers.columnRange(indexInBlock, lengthInBlock);
        }
        assert (this.fullStatistics != null);
        return this.fullStatistics.applyAsDouble(numbers);
    }

    private static /* synthetic */ SimpleArrayStatistics[] $values() {
        return new SimpleArrayStatistics[]{MEAN, SUM, MIN, MAX, MAX_ABS, MIN_OF_ORDINARY, MAX_OF_ORDINARY, MAX_ABS_OF_ORDINARY, HASH};
    }

    static {
        $VALUES = SimpleArrayStatistics.$values();
    }
}

