/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.arithmetic;

import net.algart.executors.api.Executor;

public final class TruncateToRange
extends Executor {
    public static final String OUTPUT_CHANGED = "changed";
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;

    public TruncateToRange() {
        this.addInputScalar(DEFAULT_INPUT_PORT);
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_CHANGED);
    }

    public double getMin() {
        return this.min;
    }

    public TruncateToRange setMin(double min) {
        this.min = min;
        return this;
    }

    public TruncateToRange setMin(String min) {
        this.min = TruncateToRange.doubleOrNegativeInfinity(min);
        return this;
    }

    public double getMax() {
        return this.max;
    }

    public TruncateToRange setMax(double max) {
        this.max = max;
        return this;
    }

    public TruncateToRange setMax(String max) {
        this.max = TruncateToRange.doubleOrPositiveInfinity(max);
        return this;
    }

    @Override
    public void process() {
        double value = Double.parseDouble(this.getInputScalar().getValue());
        double result = value < this.min ? this.min : Math.min(value, this.max);
        this.getScalar().setTo(result);
        this.getScalar(OUTPUT_CHANGED).setTo(result != value);
    }
}

