/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.creation;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.logic.ConditionStyle;

public final class CreateBoolean
extends Executor {
    private boolean value = false;
    private ConditionStyle conditionStyle = ConditionStyle.JAVA_LIKE;

    public CreateBoolean() {
        this.addInputScalar(DEFAULT_INPUT_PORT);
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public boolean isValue() {
        return this.value;
    }

    public CreateBoolean setValue(boolean value) {
        this.value = value;
        return this;
    }

    public ConditionStyle getConditionStyle() {
        return this.conditionStyle;
    }

    public CreateBoolean setConditionStyle(ConditionStyle conditionStyle) {
        this.conditionStyle = CreateBoolean.nonNull(conditionStyle);
        return this;
    }

    @Override
    public void process() {
        SScalar input = this.getInputScalar(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            this.getScalar().setTo(input);
        } else {
            CreateBoolean.logDebug(() -> "Creating boolean scalar");
            this.conditionStyle.setScalar(this.getScalar(), this.value);
        }
    }
}

