/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.json;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;
import net.algart.json.Jsons;

public final class GetJsonValue
extends ScalarFilter {
    public static final String INPUT_JSON = "json";
    private String key = "jsonKey";
    private String defaultValue = "";
    private boolean useDefaultValue = true;

    public GetJsonValue() {
        this.setDefaultInputScalar(INPUT_JSON);
    }

    public String getKey() {
        return this.key;
    }

    public GetJsonValue setKey(String key) {
        this.key = GetJsonValue.nonEmpty(key);
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public GetJsonValue setDefaultValue(String defaultValue) {
        this.defaultValue = GetJsonValue.nonNull(defaultValue);
        return this;
    }

    public boolean isUseDefaultValue() {
        return this.useDefaultValue;
    }

    public GetJsonValue setUseDefaultValue(boolean useDefaultValue) {
        this.useDefaultValue = useDefaultValue;
        return this;
    }

    @Override
    public SScalar process(SScalar source) {
        JsonObject json = Jsons.toJson(source.getValue(), true);
        JsonValue jsonValue = (JsonValue)json.get((Object)this.key);
        return jsonValue != null ? SScalar.of(Jsons.toPrettyString(jsonValue)) : (this.useDefaultValue ? SScalar.of(this.defaultValue) : new SScalar());
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }
}

