/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.system;

import java.io.File;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;

public class CheckClassExistence
extends Executor
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_IS_EXISTING_CLASS = "is_existing_class";
    public static final String OUTPUT_CLASS_PATH = "class_path";
    private String className = "java.lang.System";

    public CheckClassExistence() {
        this.addOutputScalar(OUTPUT_IS_EXISTING_CLASS);
        this.addOutputScalar(OUTPUT_CLASS_PATH);
    }

    public String getClassName() {
        return this.className;
    }

    public CheckClassExistence setClassName(String className) {
        this.className = CheckClassExistence.nonEmpty(className);
        return this;
    }

    @Override
    public void process() {
        Class<?> clazz = null;
        StringBuilder sb = new StringBuilder();
        try {
            clazz = Class.forName(this.className);
            sb.append("O'k, found\n").append(clazz).append("\n\n");
        }
        catch (Throwable e) {
            sb.append("Not found \"").append(this.className).append("\"\nException:\n").append(e).append("\n\n");
        }
        String classPath = System.getProperty("java.class.path");
        sb.append("Java class path:\n").append(classPath.replace(File.pathSeparator, File.pathSeparator + "\n"));
        this.getScalar(OUTPUT_IS_EXISTING_CLASS).setTo(clazz != null);
        this.getScalar(OUTPUT_CLASS_PATH).setTo(classPath);
        this.getScalar().setTo(sb);
    }
}

