/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.system;

import net.algart.executors.api.Executor;

public final class Gc
extends Executor {
    private boolean doAction = true;

    public Gc() {
        this.addInputScalar(DEFAULT_INPUT_PORT);
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public Gc setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    @Override
    public void process() {
        if (!this.doAction) {
            return;
        }
        for (int k = 0; k < 3; ++k) {
            System.gc();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Runtime rt = Runtime.getRuntime();
        String message = String.format("Used memory: %.5f MB / %.5f MB%nNumber of active threads: %d%n", (double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0, (double)rt.maxMemory() / 1048576.0, Thread.activeCount());
        Gc.logInfo(() -> "Performing System.gc(): " + message);
        this.getScalar().setTo(message);
    }
}

