/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.system;

import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.ExecutionStatus;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;

public final class ShowStatus
extends ScalarFilter {
    public static final String OUTPUT_STATUS_JSON = "status_json";
    public static final String OUTPUT_ROOT_STATUS_JSON = "root_status_json";
    public static final String S1 = "s";
    public static final String X1 = "x";
    public static final String M1 = "m";
    public static final String S2 = "s2";
    public static final String X2 = "x2";
    public static final String M2 = "m2";
    public static final String S3 = "s3";
    public static final String X3 = "x3";
    public static final String M3 = "m3";
    public static final String SCALAR_PATTERN = "$$$";
    private static final int MAX_RESULT_LENGTH = 50000;
    private boolean doAction = true;
    private String pattern = "$$$";
    private boolean modifyCallerStatus = true;

    public ShowStatus() {
        this.addOutputScalar(OUTPUT_STATUS_JSON);
        this.addOutputScalar(OUTPUT_ROOT_STATUS_JSON);
        this.addInputScalar(S1);
        this.addInputNumbers(X1);
        this.addInputMat(M1);
        this.addInputScalar(S2);
        this.addInputNumbers(X2);
        this.addInputMat(M2);
        this.addInputScalar(S3);
        this.addInputNumbers(X3);
        this.addInputMat(M3);
        this.addOutputScalar(S1);
        this.addOutputNumbers(X1);
        this.addOutputMat(M1);
        this.addOutputScalar(S2);
        this.addOutputNumbers(X2);
        this.addOutputMat(M2);
        this.addOutputScalar(S3);
        this.addOutputNumbers(X3);
        this.addOutputMat(M3);
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public ShowStatus setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ShowStatus setPattern(String pattern) {
        this.pattern = ShowStatus.nonNull(pattern);
        return this;
    }

    public boolean isModifyCallerStatus() {
        return this.modifyCallerStatus;
    }

    public ShowStatus setModifyCallerStatus(boolean modifyCallerStatus) {
        this.modifyCallerStatus = modifyCallerStatus;
        return this;
    }

    @Override
    public SScalar process(SScalar source) {
        this.getScalar(S1).exchange(this.getInputScalar(S1, true));
        this.getScalar(S2).exchange(this.getInputScalar(S2, true));
        this.getScalar(S3).exchange(this.getInputScalar(S3, true));
        this.getNumbers(X1).exchange(this.getInputNumbers(X1, true));
        this.getNumbers(X2).exchange(this.getInputNumbers(X2, true));
        this.getNumbers(X3).exchange(this.getInputNumbers(X3, true));
        this.getMat(M1).exchange(this.getInputMat(M1, true));
        this.getMat(M2).exchange(this.getInputMat(M2, true));
        this.getMat(M3).exchange(this.getInputMat(M3, true));
        String result = this.show(source.getValue());
        return SScalar.of(result);
    }

    public String show(String s) {
        ExecutionBlock executor;
        if (s != null && ((String)s).length() > 50000) {
            s = ((String)s).substring(0, 49997) + "...";
        }
        String message = this.pattern.replace("\\n", "\n").replace("\\r", "\r");
        if (s != null) {
            message = message.replace(SCALAR_PATTERN, (CharSequence)s);
        }
        if (!this.doAction) {
            return message;
        }
        ExecutionBlock executionBlock = executor = this.modifyCallerStatus ? this.getCaller() : this;
        if (executor instanceof Executor) {
            ExecutionStatus status = ((Executor)executor).status();
            status.setMessageString(message);
            if (status.isOpened()) {
                if (this.isOutputNecessary(OUTPUT_STATUS_JSON)) {
                    this.getScalar(OUTPUT_STATUS_JSON).setTo(executor.statusData(ExecutionStatus.DataKind.JSON.code()));
                }
                if (this.isOutputNecessary(OUTPUT_ROOT_STATUS_JSON)) {
                    this.getScalar(OUTPUT_ROOT_STATUS_JSON).setTo(status.root().toJsonString());
                }
            }
        }
        return message;
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }
}

