/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm;

import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.algart.graalvm.GraalContextCustomizer;
import net.algart.graalvm.GraalPerformer;
import net.algart.graalvm.GraalPerformerConfigurator;
import org.graalvm.polyglot.Context;

public abstract class GraalPerformerContainer {
    public static final boolean DEFAULT_JS_ESM_EVAL_RETURNS_EXPORTS = true;
    static final System.Logger LOG = System.getLogger(GraalPerformerContainer.class.getName());
    private Supplier<Context> contextSupplier;
    private String[] permittedLanguages = new String[0];
    private Path workingDirectory = null;
    private boolean jsEsmEvalReturnsExports = true;
    private GraalContextCustomizer customizer = GraalContextCustomizer.DEFAULT;
    private String autoBindingLanguage = null;
    private GraalPerformerConfigurator configurator = performer -> {};

    GraalPerformerContainer() {
        this.resetSupplier();
    }

    public static GraalPerformerContainer getContainer(boolean shared) {
        return shared ? new Shared() : new Local();
    }

    public static GraalPerformerContainer getContainer(boolean shared, GraalContextCustomizer customizer) {
        Objects.requireNonNull(customizer, "Mull customizer");
        return GraalPerformerContainer.getContainer(shared).setCustomizer(customizer);
    }

    public static Local getLocalPure() {
        return (Local)GraalPerformerContainer.getContainer(false);
    }

    public static Local getLocalAllAccess() {
        return GraalPerformerContainer.getLocalPure().setCustomizer(GraalContextCustomizer.ALL_ACCESS);
    }

    public static Local getLocalAllAccess(Path workingDirectory) {
        return GraalPerformerContainer.getLocalAllAccess().setWorkingDirectory(workingDirectory);
    }

    public static Local getLocal(GraalContextCustomizer customizer) {
        Objects.requireNonNull(customizer, "Mull customizer");
        return (Local)GraalPerformerContainer.getContainer(false).setCustomizer(customizer);
    }

    public static Shared getSharedPure() {
        return (Shared)GraalPerformerContainer.getContainer(true);
    }

    public static Shared getShared(GraalContextCustomizer customizer) {
        Objects.requireNonNull(customizer, "Mull customizer");
        return GraalPerformerContainer.getSharedPure().setCustomizer(customizer);
    }

    public static Shared getShared(GraalContextCustomizer customizer, ActionOnChangeContextId actionOnChangeContextId) {
        return GraalPerformerContainer.getShared(customizer).setActionOnChangeContextId(actionOnChangeContextId);
    }

    public String[] getPermittedLanguages() {
        return (String[])this.permittedLanguages.clone();
    }

    public GraalPerformerContainer setPermittedLanguages(String ... permittedLanguages) {
        Objects.requireNonNull(permittedLanguages, "Null permittedLanguages");
        this.permittedLanguages = (String[])permittedLanguages.clone();
        return this;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public GraalPerformerContainer setWorkingDirectory(Path workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public boolean isJsEsmEvalReturnsExports() {
        return this.jsEsmEvalReturnsExports;
    }

    public GraalPerformerContainer setJsEsmEvalReturnsExports(boolean jsEsmEvalReturnsExports) {
        this.jsEsmEvalReturnsExports = jsEsmEvalReturnsExports;
        return this;
    }

    public GraalContextCustomizer getCustomizer() {
        return this.customizer;
    }

    public GraalPerformerContainer setCustomizer(GraalContextCustomizer customizer) {
        this.customizer = Objects.requireNonNull(customizer, "Null customizer");
        return this;
    }

    public String getAutoBindingLanguage() {
        return this.autoBindingLanguage;
    }

    public GraalPerformerContainer setAutoBindingLanguage(String autoBindingLanguage) {
        this.autoBindingLanguage = autoBindingLanguage;
        return this;
    }

    public GraalPerformerContainer setAutoBindingJS() {
        return this.setAutoBindingLanguage("js");
    }

    public GraalPerformerConfigurator getConfigurator() {
        return this.configurator;
    }

    public GraalPerformerContainer setConfigurator(GraalPerformerConfigurator configurator) {
        this.configurator = Objects.requireNonNull(configurator, "Null configurator");
        return this;
    }

    public Supplier<Context> getContextSupplier() {
        return this.contextSupplier;
    }

    public GraalPerformerContainer setContextSupplier(Supplier<Context> customContextSupplier) {
        this.contextSupplier = Objects.requireNonNull(customContextSupplier, "Null customContextSupplier");
        return this;
    }

    public abstract GraalPerformer performer(Object var1);

    public String toString() {
        return "Graal " + this.typeName() + " performer container, customization: " + String.valueOf(this.customizer);
    }

    public abstract void freeResources(boolean var1);

    public static int numberOfSharedPerformers() {
        return ContextKey.numberOfSharedPerformers();
    }

    abstract String typeName();

    private void resetSupplier() {
        this.contextSupplier = this::supplyDefaultContext;
    }

    GraalPerformer createAndInitialize(Object contextId) {
        Context context = this.contextSupplier.get();
        GraalPerformer result = GraalPerformer.newPerformer(context, this.autoBindingLanguage);
        assert (this.customizer != null);
        result.workingDirectory = this.workingDirectory;
        result.jsEsmEvalReturnsExports = this.jsEsmEvalReturnsExports;
        result.setCustomizerInfo(this.customizer.toString());
        if (contextId != null) {
            result.setContextIdInfo(contextId.toString());
        }
        this.configurator.configure(result);
        return result;
    }

    private Context supplyDefaultContext() {
        Context.Builder builder = this.customizer.newBuilder(this.permittedLanguages);
        if (this.workingDirectory != null) {
            builder.currentWorkingDirectory(this.workingDirectory);
        }
        if (this.jsEsmEvalReturnsExports) {
            builder.option("js.esm-eval-returns-exports", "true");
        }
        return builder.build();
    }

    public static class Shared
    extends GraalPerformerContainer {
        private ActionOnChangeContextId actionOnChangeContextId = ActionOnChangeContextId.THROW_EXCEPTION;
        private ContextKey contextKey = null;
        private final Object lock = new Object();

        Shared() {
        }

        public ActionOnChangeContextId getActionOnChangeContextId() {
            return this.actionOnChangeContextId;
        }

        public Shared setActionOnChangeContextId(ActionOnChangeContextId actionOnChangeContextId) {
            this.actionOnChangeContextId = Objects.requireNonNull(actionOnChangeContextId, "Null actionOnChangeContextId");
            return this;
        }

        @Override
        public Shared setPermittedLanguages(String ... permittedLanguages) {
            return (Shared)super.setPermittedLanguages(permittedLanguages);
        }

        @Override
        public Shared setWorkingDirectory(Path workingDirectory) {
            return (Shared)super.setWorkingDirectory(workingDirectory);
        }

        @Override
        public GraalPerformerContainer setJsEsmEvalReturnsExports(boolean jsEsmEvalReturnsExports) {
            return super.setJsEsmEvalReturnsExports(jsEsmEvalReturnsExports);
        }

        @Override
        public Shared setCustomizer(GraalContextCustomizer customizer) {
            return (Shared)super.setCustomizer(customizer);
        }

        @Override
        public Shared setAutoBindingLanguage(String autoBindingLanguage) {
            return (Shared)super.setAutoBindingLanguage(autoBindingLanguage);
        }

        @Override
        public Shared setAutoBindingJS() {
            return (Shared)super.setAutoBindingJS();
        }

        @Override
        public Shared setConfigurator(GraalPerformerConfigurator configurator) {
            return (Shared)super.setConfigurator(configurator);
        }

        @Override
        public Shared setContextSupplier(Supplier<Context> customContextSupplier) {
            return (Shared)super.setContextSupplier(customContextSupplier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GraalPerformer performer(Object contextId) {
            Objects.requireNonNull(contextId, "Null context ID");
            Object object = this.lock;
            synchronized (object) {
                if (this.contextKey == null || !contextId.equals(this.contextKey.contextId)) {
                    if (this.contextKey != null) {
                        this.actionOnChangeContextId.onChangeId(this.contextKey, contextId);
                    }
                    this.contextKey = new ContextKey(contextId);
                }
                return this.contextKey.getPerformer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void freeResources(boolean freeSharedContexts) {
            if (freeSharedContexts) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.contextKey != null) {
                        this.contextKey.close();
                        this.contextKey = null;
                    }
                }
            }
        }

        @Override
        String typeName() {
            return "shared";
        }
    }

    public static class Local
    extends GraalPerformerContainer
    implements AutoCloseable {
        private volatile GraalPerformer performer = null;

        Local() {
        }

        @Override
        public Local setPermittedLanguages(String ... permittedLanguages) {
            return (Local)super.setPermittedLanguages(permittedLanguages);
        }

        @Override
        public Local setWorkingDirectory(Path workingDirectory) {
            return (Local)super.setWorkingDirectory(workingDirectory);
        }

        @Override
        public Local setJsEsmEvalReturnsExports(boolean jsEsmEvalReturnsExports) {
            return (Local)super.setJsEsmEvalReturnsExports(jsEsmEvalReturnsExports);
        }

        @Override
        public Local setCustomizer(GraalContextCustomizer customizer) {
            return (Local)super.setCustomizer(customizer);
        }

        @Override
        public Local setAutoBindingLanguage(String autoBindingLanguage) {
            return (Local)super.setAutoBindingLanguage(autoBindingLanguage);
        }

        @Override
        public Local setAutoBindingJS() {
            return (Local)super.setAutoBindingJS();
        }

        @Override
        public Local setConfigurator(GraalPerformerConfigurator configurator) {
            return (Local)super.setConfigurator(configurator);
        }

        @Override
        public Local setContextSupplier(Supplier<Context> customContextSupplier) {
            return (Local)super.setContextSupplier(customContextSupplier);
        }

        @Override
        public GraalPerformer performer(Object contextId) {
            return this.performer();
        }

        public GraalPerformer performer() {
            GraalPerformer performer = this.performer;
            if (performer == null) {
                this.performer = performer = this.createAndInitialize(null);
                LOG.log(System.Logger.Level.DEBUG, "Created new local " + String.valueOf(performer));
            }
            return performer;
        }

        @Override
        public void freeResources(boolean freeSharedContexts) {
            this.close();
        }

        public void freeResources() {
            this.close();
        }

        @Override
        public void close() {
            String message = null;
            GraalPerformer performer = this.performer;
            if (performer != null) {
                message = performer.toString();
                performer.close();
                this.performer = null;
            }
            if (message != null) {
                LOG.log(System.Logger.Level.DEBUG, "Closed local " + message);
            }
        }

        @Override
        String typeName() {
            return "local";
        }
    }

    public static enum ActionOnChangeContextId {
        NONE,
        CLOSE_PREVIOUS{

            @Override
            void onChangeId(ContextKey previousContextKey, Object newContextId) {
                previousContextKey.close();
            }
        }
        ,
        THROW_EXCEPTION{

            @Override
            void onChangeId(ContextKey previousContextKey, Object newContextId) {
                throw new IllegalStateException("Attempt to use the same context container with another context ID: old ID is \"" + String.valueOf(previousContextKey.contextId) + "\", new ID is \"" + String.valueOf(newContextId) + "\"");
            }
        };


        void onChangeId(ContextKey previousContextKey, Object newContextId) {
        }
    }

    private final class ContextKey {
        private static final Map<ContextKey, GraalPerformer> performers = new WeakHashMap<ContextKey, GraalPerformer>();
        private final Object contextId;

        ContextKey(Object contextId) {
            this.contextId = Objects.requireNonNull(contextId, "Null JavaScript context ID");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        GraalPerformer getPerformer() {
            GraalPerformer newPerformer;
            Map<ContextKey, GraalPerformer> map = performers;
            synchronized (map) {
                GraalPerformer performer = performers.get(this);
                if (performer != null) {
                    return performer;
                }
                newPerformer = GraalPerformerContainer.this.createAndInitialize(this.contextId);
                performers.put(this, newPerformer);
            }
            LOG.log(System.Logger.Level.INFO, "Created new shared " + String.valueOf(newPerformer));
            return newPerformer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            String message = null;
            Map<ContextKey, GraalPerformer> map = performers;
            synchronized (map) {
                GraalPerformer performer = performers.remove(this);
                if (performer != null) {
                    message = performer.toString();
                    performer.close();
                }
            }
            if (message != null) {
                LOG.log(System.Logger.Level.INFO, "Closed shared " + message);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextKey that = (ContextKey)o;
            return this.contextId.equals(that.contextId);
        }

        public int hashCode() {
            return Objects.hash(this.contextId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int numberOfSharedPerformers() {
            Map<ContextKey, GraalPerformer> map = performers;
            synchronized (map) {
                return performers.size();
            }
        }
    }
}

