/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.algart.graalvm.GraalSourceContainer;

public enum JSType {
    COMMON("common"){

        @Override
        void doConfigure(GraalSourceContainer container) {
        }
    }
    ,
    MODULE("module"){

        @Override
        void doConfigure(GraalSourceContainer container) {
            container.setMimeType("application/javascript+module");
        }
    };

    private final String typeName;

    private JSType(String typeName) {
        this.typeName = Objects.requireNonNull(typeName);
    }

    public static Collection<String> typeNames() {
        return Arrays.stream(JSType.values()).map(JSType::typeName).toList();
    }

    public String typeName() {
        return this.typeName;
    }

    public static Optional<JSType> fromTypeName(String typeName) {
        for (JSType type : JSType.values()) {
            if (!type.typeName.equals(typeName)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public void configure(GraalSourceContainer container, Object scriptOrigin, String name) {
        Objects.requireNonNull(container, "Null container");
        Objects.requireNonNull(scriptOrigin, "Null script origin");
        container.setLanguage("js");
        container.setOrigin(scriptOrigin, name);
        this.doConfigure(container);
    }

    abstract void doConfigure(GraalSourceContainer var1);
}

