/*
 * Decompiled with CFR 0.152.
 */
package net.algart.json;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Jsons {
    private static final JsonProvider JSON_PROVIDER = JsonProvider.provider();

    private Jsons() {
    }

    public static JsonObject newEmptyJson() {
        return Json.createObjectBuilder().build();
    }

    public static JsonObject readJson(Path path) throws IOException {
        JsonObject jsonObject;
        block9: {
            Objects.requireNonNull(path, "Null path");
            if (!Files.exists(path, new LinkOption[0])) {
                throw new NoSuchFileException("JSON file does not exist: " + String.valueOf(path));
            }
            JsonReader reader = Json.createReader((Reader)Files.newBufferedReader(path, StandardCharsets.UTF_8));
            try {
                jsonObject = reader.readObject();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException e) {
                    throw new JsonException("Invalid JSON in the file " + String.valueOf(path), (Throwable)e);
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    public static JsonObject toJson(String jsonString) {
        Objects.requireNonNull(jsonString, "Null JSON string");
        try (JsonReader reader = Json.createReader((Reader)new StringReader(jsonString));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    public static JsonObject toJson(String jsonString, boolean allowNullOrEmptyString) {
        if (allowNullOrEmptyString && jsonString == null || (jsonString = jsonString.trim()).isEmpty()) {
            return Jsons.newEmptyJson();
        }
        return Jsons.toJson(jsonString);
    }

    public static JsonArray toJsonArray(String jsonString) {
        Objects.requireNonNull(jsonString, "Null JSON string");
        try (JsonReader reader = Json.createReader((Reader)new StringReader(jsonString));){
            JsonArray jsonArray = reader.readArray();
            return jsonArray;
        }
    }

    public static JsonArray toJsonArray(Collection<String> strings) {
        Objects.requireNonNull(strings, "Null strings");
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (String s : strings) {
            builder.add(s);
        }
        return builder.build();
    }

    public static JsonString stringValue(String value) {
        Objects.requireNonNull(value, "Null value");
        return JSON_PROVIDER.createValue(value);
    }

    public static JsonNumber intValue(int value) {
        return JSON_PROVIDER.createValue(value);
    }

    public static JsonNumber longValue(long value) {
        return JSON_PROVIDER.createValue(value);
    }

    public static JsonNumber doubleValue(double value) {
        return JSON_PROVIDER.createValue(value);
    }

    public static JsonValue booleanValue(boolean value) {
        return value ? JsonValue.TRUE : JsonValue.FALSE;
    }

    public static void addAllJson(JsonObjectBuilder builder, JsonObject existingJson) {
        Objects.requireNonNull(builder, "Null builder");
        Objects.requireNonNull(existingJson, "Null existingJson");
        for (Map.Entry entry : existingJson.entrySet()) {
            builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
    }

    public static JsonObjectBuilder createObjectBuilder(JsonObject existingJson) {
        Objects.requireNonNull(existingJson, "Null existingJson");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        Jsons.addAllJson(builder, existingJson);
        return builder;
    }

    public static JsonObject filterJson(JsonObject sourceJson, Set<String> keysToPreserve) {
        Objects.requireNonNull(sourceJson, "Null sourceJson");
        Objects.requireNonNull(keysToPreserve, "Null keysToPreserve");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry entry : sourceJson.entrySet()) {
            String key = (String)entry.getKey();
            if (!keysToPreserve.contains(key)) continue;
            builder.add(key, (JsonValue)entry.getValue());
        }
        return builder.build();
    }

    public static JsonObject overrideEntries(JsonObject sourceJson, JsonObject overridingJson) {
        Objects.requireNonNull(sourceJson, "Null sourceJson");
        Objects.requireNonNull(overridingJson, "Null overridingJson");
        JsonObjectBuilder builder = Jsons.createObjectBuilder(sourceJson);
        Jsons.addAllJson(builder, overridingJson);
        return builder.build();
    }

    public static JsonObject addNonExistingEntries(JsonObject sourceJson, JsonObject overridingJson) {
        Objects.requireNonNull(sourceJson, "Null sourceJson");
        Objects.requireNonNull(overridingJson, "Null overridingJson");
        JsonObjectBuilder builder = Jsons.createObjectBuilder(sourceJson);
        for (Map.Entry entry : overridingJson.entrySet()) {
            String key = (String)entry.getKey();
            if (sourceJson.containsKey((Object)key)) continue;
            builder.add(key, (JsonValue)entry.getValue());
        }
        return builder.build();
    }

    public static JsonObject overrideOnlyExistingInBoth(JsonObject sourceJson, JsonObject overridingJson) {
        Objects.requireNonNull(sourceJson, "Null sourceJson");
        Objects.requireNonNull(overridingJson, "Null overridingJson");
        JsonObjectBuilder builder = Jsons.createObjectBuilder(sourceJson);
        for (Map.Entry entry : overridingJson.entrySet()) {
            String key = (String)entry.getKey();
            if (!sourceJson.containsKey((Object)key)) continue;
            builder.add(key, (JsonValue)entry.getValue());
        }
        return builder.build();
    }

    public static JsonObject extractSimpleValues(JsonObject sourceJson) {
        Objects.requireNonNull(sourceJson, "Null sourceJson");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry entry : sourceJson.entrySet()) {
            JsonValue value = (JsonValue)entry.getValue();
            switch (value.getValueType()) {
                case NUMBER: 
                case STRING: 
                case FALSE: 
                case TRUE: 
                case NULL: {
                    builder.add((String)entry.getKey(), value);
                }
            }
        }
        return builder.build();
    }

    public static String toPrettyString(JsonValue jsonValue) {
        Objects.requireNonNull(jsonValue, "Null jsonValue");
        return switch (jsonValue.getValueType()) {
            case JsonValue.ValueType.STRING -> ((JsonString)jsonValue).getString();
            case JsonValue.ValueType.OBJECT -> Jsons.toPrettyString((JsonObject)jsonValue);
            case JsonValue.ValueType.ARRAY -> Jsons.toPrettyString((JsonArray)jsonValue);
            default -> jsonValue.toString();
        };
    }

    public static String toPrettyString(JsonObject json) {
        Objects.requireNonNull(json, "Null json");
        JsonWriterFactory jsonWriterFactory = Json.createWriterFactory(Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true));
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter jsonWriter = jsonWriterFactory.createWriter((Writer)stringWriter);){
            jsonWriter.writeObject(json);
            String string = stringWriter.toString().trim();
            return string;
        }
    }

    public static String toPrettyString(JsonArray json) {
        Objects.requireNonNull(json, "Null json");
        JsonWriterFactory jsonWriterFactory = Json.createWriterFactory(Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true));
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter jsonWriter = jsonWriterFactory.createWriter((Writer)stringWriter);){
            jsonWriter.writeArray(json);
            String string = stringWriter.toString().trim();
            return string;
        }
    }

    public static List<JsonObject> toJsonObjects(JsonArray jsonArray) {
        return Jsons.toJsonObjects(jsonArray, null);
    }

    public static List<JsonObject> toJsonObjects(JsonArray jsonArray, String nameForException) {
        return Jsons.toJsonObjects(jsonArray, nameForException, null);
    }

    public static List<JsonObject> toJsonObjects(JsonArray jsonArray, String nameForException, Path file) {
        Objects.requireNonNull(jsonArray, "Null jsonArray");
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        for (JsonValue jsonValue : jsonArray) {
            if (!(jsonValue instanceof JsonObject)) {
                throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": " + (String)(nameForException == null ? "an" : "\"" + nameForException + "\"") + " array contains non-object element " + String.valueOf(jsonValue));
            }
            result.add((JsonObject)jsonValue);
        }
        return result;
    }

    public static List<String> toStrings(JsonArray jsonArray) {
        return Jsons.toStrings(jsonArray, null);
    }

    public static List<String> toStrings(JsonArray jsonArray, String nameForException) {
        return Jsons.toStrings(jsonArray, nameForException, null);
    }

    public static List<String> toStrings(JsonArray jsonArray, String nameForException, Path file) {
        Objects.requireNonNull(jsonArray, "Null jsonArray");
        ArrayList<String> result = new ArrayList<String>();
        for (JsonValue jsonValue : jsonArray) {
            if (!(jsonValue instanceof JsonString)) {
                throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": " + (String)(nameForException == null ? "an" : "\"" + nameForException + "\"") + " array contains non-string element " + String.valueOf(jsonValue));
            }
            result.add(((JsonString)jsonValue).getString());
        }
        return result;
    }

    public static int reqInt(JsonObject json, String name) {
        return Jsons.reqInt(json, name, null);
    }

    public static int reqInt(JsonObject json, String name, Path file) {
        return Jsons.reqIntWithAlias(json, name, null, file);
    }

    public static int reqIntWithAlias(JsonObject json, String name, String aliasName, Path file) {
        JsonNumber result;
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        String usedName = name;
        try {
            result = json.getJsonNumber(name);
            if (result == null && aliasName != null) {
                usedName = aliasName;
                result = json.getJsonNumber(aliasName);
            }
        }
        catch (ClassCastException e) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + usedName + "\" value is not a number" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        if (result == null) {
            throw new JsonException("Invalid JSON " + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" numeric value required" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        return result.intValueExact();
    }

    public static void addDouble(JsonObjectBuilder builder, String name, double value) {
        if (value == Double.NEGATIVE_INFINITY) {
            builder.add(name, "\u2212\u221e");
        } else if (value == Double.POSITIVE_INFINITY) {
            builder.add(name, "+\u221e");
        } else if (Double.isNaN(value)) {
            builder.add(name, "NaN");
        } else {
            builder.add(name, value);
        }
    }

    public static double getDouble(JsonObject json, String name, double defaultValue) {
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        JsonValue jsonValue = (JsonValue)json.get((Object)name);
        if (jsonValue == null) {
            return defaultValue;
        }
        Double special = Jsons.specialDoubleValue(jsonValue);
        if (special != null) {
            return special;
        }
        try {
            return ((JsonNumber)jsonValue).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double reqDouble(JsonObject json, String name) {
        return Jsons.reqDouble(json, name, null);
    }

    public static double reqDouble(JsonObject json, String name, Path file) {
        JsonNumber result;
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        JsonValue jsonValue = (JsonValue)json.get((Object)name);
        if (jsonValue == null) {
            throw new JsonException("Invalid JSON " + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" double value required" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        Double special = Jsons.specialDoubleValue(jsonValue);
        if (special != null) {
            return special;
        }
        try {
            result = (JsonNumber)jsonValue;
        }
        catch (ClassCastException e) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" value is not a number" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        return result.doubleValue();
    }

    public static long getLong(JsonObject json, String name, long defaultValue) {
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        try {
            return json.getJsonNumber(name).longValueExact();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long reqLong(JsonObject json, String name) {
        return Jsons.reqLong(json, name, null);
    }

    public static long reqLong(JsonObject json, String name, Path file) {
        JsonNumber result;
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        try {
            result = json.getJsonNumber(name);
        }
        catch (ClassCastException e) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" value is not a number" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        if (result == null) {
            throw new JsonException("Invalid JSON " + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" long value required" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        return result.longValueExact();
    }

    public static String reqString(JsonObject json, String name) {
        return Jsons.reqString(json, name, null);
    }

    public static String reqString(JsonObject json, String name, Path file) {
        return Jsons.reqStringWithAlias(json, name, null, file);
    }

    public static String reqStringWithAlias(JsonObject json, String name, String aliasName, Path file) {
        JsonString result;
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        String usedName = name;
        try {
            result = json.getJsonString(name);
            if (result == null && aliasName != null) {
                usedName = aliasName;
                result = json.getJsonString(aliasName);
            }
        }
        catch (ClassCastException e) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + usedName + "\" value is not a string" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        if (result == null) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" value required" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        return result.getString();
    }

    public static JsonValue reqJsonValue(JsonObject json, String name) {
        return Jsons.reqJsonValue(json, name, null);
    }

    public static JsonValue reqJsonValue(JsonObject json, String name, Path file) {
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        JsonValue result = (JsonValue)json.get((Object)name);
        if (result == null) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" value required" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        return result;
    }

    public static List<JsonObject> getJsonObjectsOrEmptyList(JsonObject json, String name) {
        return Jsons.getJsonObjectsOrEmptyList(json, name, null);
    }

    public static List<JsonObject> getJsonObjectsOrEmptyList(JsonObject json, String name, Path file) {
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        JsonArray jsonArray = json.getJsonArray(name);
        if (jsonArray == null) {
            return Collections.emptyList();
        }
        return Jsons.toJsonObjects(jsonArray, name, file);
    }

    public static JsonObject reqJsonObject(JsonObject json, String name) {
        return Jsons.reqJsonObject(json, name, null);
    }

    public static JsonObject reqJsonObject(JsonObject json, String name, Path file) {
        return Jsons.reqJsonObjectWithAlias(json, name, null, file);
    }

    public static JsonObject reqJsonObjectWithAlias(JsonObject json, String name, String aliasName, Path file) {
        Objects.requireNonNull(json, "Null json");
        JsonObject result = Jsons.getJsonObject(json, name, file);
        if (result == null && aliasName != null) {
            result = Jsons.getJsonObject(json, aliasName, file);
        }
        if (result == null) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" JSON object required" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        return result;
    }

    public static JsonObject getJsonObject(JsonObject json, String name) {
        return Jsons.getJsonObject(json, name, null);
    }

    public static JsonObject getJsonObject(JsonObject json, String name, Path file) {
        Objects.requireNonNull(name, "Null name");
        if (json == null) {
            return null;
        }
        try {
            return json.getJsonObject(name);
        }
        catch (ClassCastException e) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" value is not a JSON object" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
    }

    public static JsonArray reqJsonArray(JsonObject json, String name, Path file) {
        return Jsons.reqJsonArray(json, name, file, false);
    }

    public static JsonArray reqJsonArray(JsonObject json, String name, Path file, boolean mustContainOnlyObjects) {
        JsonArray result = Jsons.getJsonArray(json, name, file, mustContainOnlyObjects);
        if (result == null) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" JSON array required" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        return result;
    }

    public static JsonArray getJsonArray(JsonObject json, String name, Path file) {
        return Jsons.getJsonArray(json, name, file, false);
    }

    public static JsonArray getJsonArray(JsonObject json, String name, Path file, boolean mustContainOnlyObjects) {
        JsonArray result;
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        try {
            result = json.getJsonArray(name);
        }
        catch (ClassCastException e) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" value is not a JSON array" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        if (mustContainOnlyObjects && result != null) {
            for (JsonValue jsonValue : result) {
                if (jsonValue instanceof JsonObject) continue;
                throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" array contains non-object element " + String.valueOf(jsonValue));
            }
        }
        return result;
    }

    public static List<String> reqStrings(JsonObject json, String name) {
        return Jsons.reqStrings(json, name, null);
    }

    public static List<String> reqStrings(JsonObject json, String name, Path file) {
        List<String> result = Jsons.getStrings(json, name, file);
        if (result == null) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" JSON array required" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        return result;
    }

    public static List<String> getStrings(JsonObject json, String name) {
        return Jsons.getStrings(json, name, null);
    }

    public static List<String> getStrings(JsonObject json, String name, Path file) {
        JsonArray jsonArray;
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        try {
            jsonArray = json.getJsonArray(name);
        }
        catch (ClassCastException e) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" value is not a JSON array" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        if (jsonArray == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (JsonValue jsonValue : jsonArray) {
            if (!(jsonValue instanceof JsonString)) {
                throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" array contains non-string element " + String.valueOf(jsonValue));
            }
            result.add(((JsonString)jsonValue).getString());
        }
        return result;
    }

    public static List<JsonObject> reqJsonObjects(JsonObject json, String name) {
        return Jsons.reqJsonObjects(json, name, null);
    }

    public static List<JsonObject> reqJsonObjects(JsonObject json, String name, Path file) {
        JsonArray jsonArray;
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        try {
            jsonArray = json.getJsonArray(name);
        }
        catch (ClassCastException e) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" value is not a JSON array" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        if (jsonArray == null) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" array required");
        }
        return Jsons.toJsonObjects(jsonArray, name, file);
    }

    public static String toString(Color color) {
        Objects.requireNonNull(color, "Null color");
        int rgb = color.getRGB() & 0xFFFFFF;
        return String.format("#%06X", rgb);
    }

    public static Color toColor(String s) {
        Objects.requireNonNull(s, "Null string");
        return Color.decode(s);
    }

    @Deprecated(forRemoval=true)
    public static <T> T requireNonNull(T value, JsonObject json, String name) {
        return Jsons.requireNonNull(value, json, name, null);
    }

    @Deprecated(forRemoval=true)
    public static <T> T requireNonNull(T value, JsonObject json, String name, Path file) {
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        if (value == null) {
            throw Jsons.incorrectValue(json, name, "required", file);
        }
        return value;
    }

    @Deprecated(forRemoval=true)
    public static <T> T requireNonNull(T value, JsonObject json, String name, String message, Path file) {
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        if (value == null) {
            throw Jsons.incorrectValue(json, name, message, file);
        }
        return value;
    }

    public static JsonException badValue(JsonObject json, String name) {
        return Jsons.badValue(json, name, (Path)null);
    }

    public static JsonException badValue(JsonObject json, String name, Path file) {
        return Jsons.incorrectValue(json, name, "unknown value", file);
    }

    public static JsonException badValue(JsonObject json, String name, String actualValue) {
        return Jsons.badValue(json, name, actualValue, (Path)null);
    }

    public static JsonException badValue(JsonObject json, String name, String actualValue, Path file) {
        return Jsons.incorrectValue(json, name, "unknown value: \"" + actualValue + "\"", file);
    }

    public static JsonException badValue(JsonObject json, String name, String actual, Collection<?> values) {
        return Jsons.badValue(json, name, actual, values, null);
    }

    public static JsonException badValue(JsonObject json, String name, String actual, Collection<?> values, Path file) {
        return Jsons.badValue(json, name, actual, values.stream(), file);
    }

    public static JsonException badValue(JsonObject json, String name, String actual, Stream<?> allowed) {
        return Jsons.badValue(json, name, actual, allowed, null);
    }

    public static JsonException badValue(JsonObject json, String name, String actual, Stream<?> allowed, Path file) {
        return Jsons.incorrectValue(json, name, "unknown value: \"" + actual + "\" (allowed variants: " + allowed.map(v -> "\"" + String.valueOf(v) + "\"").collect(Collectors.joining(", ")) + ")", file);
    }

    public static JsonException incorrectValue(JsonObject json, String name, String message) {
        return Jsons.incorrectValue(json, name, message, null);
    }

    public static JsonException incorrectValue(JsonObject json, String name, String message, Path file) {
        return new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" property contains " + message + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
    }

    private static Double specialDoubleValue(JsonValue jsonValue) {
        if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
            String s = ((JsonString)jsonValue).getString();
            if ("\u2212\u221e".equals(s)) {
                return Double.NEGATIVE_INFINITY;
            }
            if ("+\u221e".equals(s)) {
                return Double.POSITIVE_INFINITY;
            }
            if ("NaN".equals(s)) {
                return Double.NaN;
            }
        }
        return null;
    }
}

