/*
 * Decompiled with CFR 0.152.
 */
package net.algart.json;

import net.algart.json.PropertyCheckerHelper;

public abstract class PropertyChecker {
    public static <T> T nonNull(T value, String valueName) {
        if (value == null) {
            throw new NullPointerException("Null " + valueName);
        }
        return value;
    }

    public static <T> T nonNull(T value) {
        if (value == null) {
            throw new NullPointerException("Null " + PropertyChecker.propertyName());
        }
        return value;
    }

    public static String nonEmpty(String value, String valueName) {
        PropertyChecker.nonNull(value, valueName);
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Empty " + valueName + ", but non-empty string required");
        }
        return value;
    }

    public static String nonEmpty(String value) {
        PropertyChecker.nonNull(value);
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Empty string \"" + PropertyChecker.propertyName() + "\", but non-empty string required");
        }
        return value;
    }

    public static String nonEmptyTrimmed(String value, String valueName) {
        if ((value = PropertyChecker.nonNull(value, valueName).trim()).isEmpty()) {
            throw new IllegalArgumentException("Empty/blank string " + valueName + ", but non-empty string required");
        }
        return value;
    }

    public static String nonEmptyTrimmed(String value) {
        if ((value = PropertyChecker.nonNull(value).trim()).isEmpty()) {
            throw new IllegalArgumentException("Empty/blank string \"" + PropertyChecker.propertyName() + "\", but non-empty string required");
        }
        return value;
    }

    public static double inRange(double value, double min, double max, String valueName) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("Illegal " + valueName + " = " + value + ": it must be in " + min + ".." + max + " range");
        }
        return value;
    }

    public static double inRange(double value, double min, double max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("Illegal " + PropertyChecker.propertyName() + " = " + value + ": it must be in " + min + ".." + max + " range");
        }
        return value;
    }

    public static double nonLessThan(double value, double min, String valueName) {
        if (value < min) {
            throw new IllegalArgumentException("Too small " + valueName + " = " + value + " < " + min);
        }
        return value;
    }

    public static double nonLessThan(double value, double min) {
        if (value < min) {
            throw new IllegalArgumentException("Too small " + PropertyChecker.propertyName() + " = " + value + " < " + min);
        }
        return value;
    }

    public static double greaterThan(double value, double min, String valueName) {
        if (value <= min) {
            throw new IllegalArgumentException("Too small " + valueName + " = " + value + " <= " + min);
        }
        return value;
    }

    public static double greaterThan(double value, double min) {
        if (value <= min) {
            throw new IllegalArgumentException("Too small " + PropertyChecker.propertyName() + " = " + value + " <= " + min);
        }
        return value;
    }

    public static double nonNegative(double value, String valueName) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Negative " + valueName + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static double nonNegative(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Negative " + PropertyChecker.propertyName() + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static double positive(double value, String valueName) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("Zero or negative " + valueName + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static double positive(double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("Zero or negative " + PropertyChecker.propertyName() + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static long inRange(long value, long min, long max, String valueName) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("Illegal " + valueName + " = " + value + ": it must be in " + min + ".." + max + " range");
        }
        return value;
    }

    public static long inRange(long value, long min, long max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("Illegal " + PropertyChecker.propertyName() + " = " + value + ": it must be in " + min + ".." + max + " range");
        }
        return value;
    }

    public static long nonLessThan(long value, long min, String valueName) {
        if (value < min) {
            throw new IllegalArgumentException("Too small " + valueName + " = " + value + " < " + min);
        }
        return value;
    }

    public static long nonLessThan(long value, long min) {
        if (value < min) {
            throw new IllegalArgumentException("Too small " + PropertyChecker.propertyName() + " = " + value + " < " + min);
        }
        return value;
    }

    public static long greaterThan(long value, long min, String valueName) {
        if (value <= min) {
            throw new IllegalArgumentException("Too small " + valueName + " = " + value + " <= " + min);
        }
        return value;
    }

    public static long greaterThan(long value, long min) {
        if (value <= min) {
            throw new IllegalArgumentException("Too small " + PropertyChecker.propertyName() + " = " + value + " <= " + min);
        }
        return value;
    }

    public static long nonNegative(long value, String valueName) {
        if (value < 0L) {
            throw new IllegalArgumentException("Negative " + valueName + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static long nonNegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Negative " + PropertyChecker.propertyName() + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static long positive(long value, String valueName) {
        if (value <= 0L) {
            throw new IllegalArgumentException("Zero or negative " + valueName + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static long positive(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("Zero or negative " + PropertyChecker.propertyName() + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static int inRange(int value, int min, int max, String valueName) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("Illegal " + valueName + " = " + value + ": it must be in " + min + ".." + max + " range");
        }
        return value;
    }

    public static int inRange(int value, int min, int max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("Illegal " + PropertyChecker.propertyName() + " = " + value + ": it must be in " + min + ".." + max + " range");
        }
        return value;
    }

    public static int nonLessThan(int value, int min, String valueName) {
        if (value < min) {
            throw new IllegalArgumentException("Too small " + valueName + " = " + value + " < " + min);
        }
        return value;
    }

    public static int nonLessThan(int value, int min) {
        if (value < min) {
            throw new IllegalArgumentException("Too small " + PropertyChecker.propertyName() + " = " + value + " < " + min);
        }
        return value;
    }

    public static int greaterThan(int value, int min, String valueName) {
        if (value <= min) {
            throw new IllegalArgumentException("Too small " + valueName + " = " + value + " <= " + min);
        }
        return value;
    }

    public static int greaterThan(int value, int min) {
        if (value <= min) {
            throw new IllegalArgumentException("Too small " + PropertyChecker.propertyName() + " = " + value + " <= " + min);
        }
        return value;
    }

    public static int nonNegative(int value, String valueName) {
        if (value < 0) {
            throw new IllegalArgumentException("Negative " + valueName + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static int nonNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Negative " + PropertyChecker.propertyName() + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static int positive(int value, String valueName) {
        if (value <= 0) {
            throw new IllegalArgumentException("Zero or negative " + valueName + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static int positive(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Zero or negative " + PropertyChecker.propertyName() + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    public static double doubleOrNegativeInfinity(String value) {
        value = value == null ? "" : value.trim();
        return value.isEmpty() ? Double.NEGATIVE_INFINITY : Double.parseDouble(value);
    }

    public static double doubleOrPositiveInfinity(String value) {
        value = value == null ? "" : value.trim();
        return value.isEmpty() ? Double.POSITIVE_INFINITY : Double.parseDouble(value);
    }

    public static Integer intOrNull(String value) {
        value = value == null ? "" : value.trim();
        return value.isEmpty() ? null : Integer.valueOf(value);
    }

    public static Long longOrNull(String value) {
        value = value == null ? "" : value.trim();
        return value.isEmpty() ? null : Long.valueOf(value);
    }

    public static Double doubleOrNull(String value) {
        value = value == null ? "" : value.trim();
        return value.isEmpty() ? null : Double.valueOf(value);
    }

    public static int intOrDefault(String value, int defaultValue) {
        value = value == null ? "" : value.trim();
        return value.isEmpty() ? defaultValue : Integer.parseInt(value);
    }

    public static long longOrDefault(String value, long defaultValue) {
        value = value == null ? "" : value.trim();
        return value.isEmpty() ? defaultValue : Long.parseLong(value);
    }

    public static double doubleOrDefault(String value, double defaultValue) {
        value = value == null ? "" : value.trim();
        return value.isEmpty() ? defaultValue : Double.parseDouble(value);
    }

    public static String propertyName() {
        return PropertyCheckerHelper.findPropertyNameFromCurrentSetter("value");
    }
}

