/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.util.Arrays;

public class PyConfig {
    protected final boolean isolated;
    protected String[] argv;
    protected int hashSeed = -1;
    protected int useHashSeed = -1;
    protected String home;
    protected int optimizationLevel = -1;
    protected int parseArgv = -1;
    protected String programName;
    protected int siteImport = -1;
    protected int useEnvironment = -1;
    protected int userSiteDirectory = -1;
    protected int verbose = -1;
    protected int writeBytecode = -1;

    @Deprecated
    public PyConfig() {
        this(false);
    }

    protected PyConfig(boolean bl) {
        this.isolated = bl;
    }

    public PyConfig setArgv(String ... stringArray) {
        this.argv = stringArray;
        return this;
    }

    public PyConfig setHashSeed(int n) {
        this.hashSeed = n;
        return this;
    }

    public PyConfig setUseHashSeed(boolean bl) {
        this.useHashSeed = bl ? 1 : 0;
        return this;
    }

    public PyConfig setHome(String string) {
        this.home = string;
        return this;
    }

    public PyConfig setOptimizationLevel(int n) {
        this.optimizationLevel = n;
        return this;
    }

    public PyConfig setParseArgv(boolean bl) {
        this.parseArgv = bl ? 1 : 0;
        return this;
    }

    public PyConfig setProgramName(String string) {
        this.programName = string;
        return this;
    }

    public PyConfig setSiteImport(boolean bl) {
        this.siteImport = bl ? 1 : 0;
        return this;
    }

    public PyConfig setUseEnvironment(boolean bl) {
        this.useEnvironment = bl ? 1 : 0;
        return this;
    }

    public PyConfig setUserSiteDirectory(boolean bl) {
        this.userSiteDirectory = bl ? 1 : 0;
        return this;
    }

    public PyConfig setVerbose(int n) {
        this.verbose = n;
        return this;
    }

    public PyConfig setWriteBytecode(boolean bl) {
        this.writeBytecode = bl ? 1 : 0;
        return this;
    }

    @Deprecated
    public PyConfig setNoSiteFlag(int n) {
        return this.setSiteImport(n == 0);
    }

    @Deprecated
    public PyConfig setNoUserSiteDirectory(int n) {
        return this.setUserSiteDirectory(n == 0);
    }

    @Deprecated
    public PyConfig setIgnoreEnvironmentFlag(int n) {
        return this.setUseEnvironment(n == 0);
    }

    @Deprecated
    public PyConfig setVerboseFlag(int n) {
        return this.setVerbose(n);
    }

    @Deprecated
    public PyConfig setOptimizeFlag(int n) {
        return this.setOptimizationLevel(n);
    }

    @Deprecated
    public PyConfig setDontWriteBytecodeFlag(int n) {
        return this.setWriteBytecode(n == 0);
    }

    @Deprecated
    public PyConfig setHashRandomizationFlag(int n) {
        if (n == 1) {
            this.setUseHashSeed(false);
        } else {
            this.setHashSeed(n);
            this.setUseHashSeed(true);
        }
        return this;
    }

    @Deprecated
    public PyConfig setPythonHome(String string) {
        return this.setHome(string);
    }

    public static PyConfig python() {
        return new PyConfig(false);
    }

    public static PyConfig isolated() {
        return new PyConfig(true);
    }

    public String toString() {
        return "PyConfig [isolated=" + this.isolated + ", argv=" + Arrays.toString(this.argv) + ", hashSeed=" + this.hashSeed + ", useHashSeed=" + this.useHashSeed + ", home=" + this.home + ", optimizationLevel=" + this.optimizationLevel + ", parseArgv=" + this.parseArgv + ", programName=" + this.programName + ", siteImport=" + this.siteImport + ", useEnvironment=" + this.useEnvironment + ", userSiteDirectory=" + this.userSiteDirectory + ", verbose=" + this.verbose + ", writeBytecode=" + this.writeBytecode + "]";
    }
}

