/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames;

import java.util.Locale;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.executors.modules.maps.frames.buffers.MapBuffer;
import net.algart.executors.modules.maps.frames.buffers.MapBufferKey;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.multimatrix.MultiMatrix;

public final class AddFrameToMapBuffer
extends MultiMatrixFilter {
    public static final String POSITION = "position";
    public static final String RECTANGLE_TO_CROP = "rectangle_to_crop";
    public static final String EXPANDED_RECTANGLE = "expanded";
    private int startX = 0;
    private int startY = 0;
    private int expansionX = 0;
    private Integer expansionY = null;
    private boolean disableOverlapping = false;
    private boolean zerosReservedForBackground = true;

    public AddFrameToMapBuffer() {
        this.addInputScalar("map_buffer_id");
        this.addInputNumbers(POSITION);
        this.addInputNumbers(RECTANGLE_TO_CROP);
        this.addOutputScalar("map_buffer_id");
        this.addOutputNumbers(EXPANDED_RECTANGLE);
        this.addOutputNumbers("rectangle");
        this.addOutputNumbers("containing_rectangle");
    }

    public int getStartX() {
        return this.startX;
    }

    public AddFrameToMapBuffer setStartX(int startX) {
        this.startX = startX;
        return this;
    }

    public int getStartY() {
        return this.startY;
    }

    public AddFrameToMapBuffer setStartY(int startY) {
        this.startY = startY;
        return this;
    }

    public int getExpansionX() {
        return this.expansionX;
    }

    public AddFrameToMapBuffer setExpansionX(int expansionX) {
        this.expansionX = expansionX;
        return this;
    }

    public Integer getExpansionY() {
        return this.expansionY;
    }

    public AddFrameToMapBuffer setExpansionY(Integer expansionY) {
        this.expansionY = expansionY;
        return this;
    }

    public boolean isDisableOverlapping() {
        return this.disableOverlapping;
    }

    public AddFrameToMapBuffer setDisableOverlapping(boolean disableOverlapping) {
        this.disableOverlapping = disableOverlapping;
        return this;
    }

    public boolean isZerosReservedForBackground() {
        return this.zerosReservedForBackground;
    }

    public AddFrameToMapBuffer setZerosReservedForBackground(boolean zerosReservedForBackground) {
        this.zerosReservedForBackground = zerosReservedForBackground;
        return this;
    }

    public MultiMatrix process(MultiMatrix source) {
        SScalar id = this.getInputScalar("map_buffer_id");
        MultiMatrix result = this.process(id.toLong(), source);
        this.getScalar("map_buffer_id").setTo(id);
        return result;
    }

    public MultiMatrix process(long mapBufferId, MultiMatrix source) {
        IPoint originPoint;
        MapBufferKey mapBufferKey = MapBufferKey.getInstance(mapBufferId);
        MapBuffer mapBuffer = mapBufferKey.reqMapBuffer();
        long t1 = System.nanoTime();
        SNumbers position = this.getInputNumbers(POSITION, true);
        boolean readingRequested = this.isOutputNecessary(DEFAULT_OUTPUT_PORT);
        IPoint iPoint = originPoint = position.isProbableRectangularArea() ? position.toIRectangularArea().min() : position.toIPoint();
        if (originPoint == null) {
            originPoint = IPoint.of((long)this.startX, (long)this.startY);
        }
        IRectangularArea rectangleToCrop = this.getInputNumbers(RECTANGLE_TO_CROP, true).toIRectangularArea();
        long t2 = System.nanoTime();
        MapBuffer.Frame frame = mapBuffer.addFrame(source, originPoint, rectangleToCrop, this.disableOverlapping);
        long t3 = System.nanoTime();
        IRectangularArea expanded = mapBuffer.expandRectangleOnMap(frame.position(), IPoint.of((long)this.expansionX, (long)(this.expansionY != null ? (long)this.expansionY.intValue() : (long)this.expansionX)), true);
        this.getNumbers("rectangle").setTo(frame.position());
        this.getNumbers(EXPANDED_RECTANGLE).setTo(expanded);
        if (this.isOutputNecessary("containing_rectangle")) {
            this.getNumbers("containing_rectangle").setTo(mapBuffer.containingRectangle());
        }
        long t4 = System.nanoTime();
        MultiMatrix result = null;
        if (readingRequested) {
            result = mapBuffer.readMatrix(expanded);
        }
        long t5 = System.nanoTime();
        AddFrameToMapBuffer.logDebug(() -> String.format(Locale.US, "Adding %s to %s (%s): %.3f ms = %.3f ms initializing%s + %.3f ms adding + %.3f making outputs + %.3f reading matrix", frame, mapBufferKey, mapBuffer, (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, rectangleToCrop != null ? "/cropping" : "", (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6));
        return result;
    }

    protected boolean resultRequired() {
        return false;
    }
}

