/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames.buffers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.maps.frames.buffers.FrameObjectStitcher;
import net.algart.executors.modules.maps.frames.joints.DynamicDisjointSet;
import net.algart.executors.modules.maps.frames.joints.ObjectPairs;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.Range;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.multimatrix.MultiMatrix;

public final class MapBuffer {
    private static final boolean OPTIMIZE_ADD_FRAME = true;
    private int maximalNumberOfStoredFrames = 1;
    private boolean stitchingLabels = false;
    private boolean autoReindexLabels = false;
    private boolean zerosLabelReservedForBackground = true;
    private final Deque<Frame> frames = new LinkedList<Frame>();
    private final ObjectPairs objectPairs = ObjectPairs.newInstance();
    private final BitSet rawPartialObjects = new BitSet();
    private IRectangularArea firstFramePosition = null;
    private int indexingBase = 0;

    private MapBuffer() {
    }

    public static MapBuffer newInstance() {
        return new MapBuffer();
    }

    public FrameObjectStitcher getFrameObjectStitcher() {
        return FrameObjectStitcher.getInstance(this, this.rawPartialObjects);
    }

    public int getMaximalNumberOfStoredFrames() {
        return this.maximalNumberOfStoredFrames;
    }

    public MapBuffer setMaximalNumberOfStoredFrames(int maximalNumberOfStoredFrames) {
        if (maximalNumberOfStoredFrames <= 0) {
            throw new IllegalArgumentException("Zero or negative maximal number of stored rows");
        }
        this.maximalNumberOfStoredFrames = maximalNumberOfStoredFrames;
        return this;
    }

    public boolean isStitchingLabels() {
        return this.stitchingLabels;
    }

    public MapBuffer setStitchingLabels(boolean stitchingLabels) {
        this.stitchingLabels = stitchingLabels;
        return this;
    }

    public boolean isAutoReindexLabels() {
        return this.autoReindexLabels;
    }

    public MapBuffer setAutoReindexLabels(boolean autoReindexLabels) {
        this.autoReindexLabels = autoReindexLabels;
        return this;
    }

    public boolean isZerosLabelReservedForBackground() {
        return this.zerosLabelReservedForBackground;
    }

    public MapBuffer setZerosLabelReservedForBackground(boolean zerosLabelReservedForBackground) {
        this.zerosLabelReservedForBackground = zerosLabelReservedForBackground;
        return this;
    }

    public int getIndexingBase() {
        return this.indexingBase;
    }

    public MapBuffer setIndexingBase(int indexingBase) {
        if (indexingBase < 0) {
            throw new IllegalArgumentException("Indexing base cannot be negative: " + indexingBase);
        }
        this.indexingBase = indexingBase;
        return this;
    }

    public ObjectPairs objectPairs() {
        return this.objectPairs;
    }

    public BitSet rawPartialObjects() {
        return this.rawPartialObjects;
    }

    public BitSet reindexPartialObjects() {
        return this.objectPairs.reindexByAnd(this.rawPartialObjects);
    }

    public int numberOfFrames() {
        return this.frames.size();
    }

    public int numberOfObjects() {
        return this.zerosLabelReservedForBackground ? this.indexingBase + 1 : this.indexingBase;
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean resetIndexing) {
        this.frames.clear();
        this.objectPairs.clear();
        this.rawPartialObjects.clear();
        this.firstFramePosition = null;
        if (resetIndexing) {
            this.indexingBase = 0;
        }
    }

    public void addFrame(Frame frame) {
        Objects.requireNonNull(frame, "Null frame");
        this.addFrame(frame.matrix, frame.position.min(), null, false);
    }

    public Frame addFrame(MultiMatrix matrix, IPoint leftTop, IRectangularArea rectangleToCrop, boolean disableOverlapping) {
        boolean nonOptimized;
        Objects.requireNonNull(matrix, "Null matrix");
        Objects.requireNonNull(leftTop, "Null leftTop");
        this.checkFrameCompatibility(matrix);
        Frame frame = this.tryToAddFrameWithReindexingOptimized(matrix, leftTop, rectangleToCrop, disableOverlapping);
        boolean bl = nonOptimized = frame == null;
        if (nonOptimized) {
            if (rectangleToCrop != null) {
                matrix = matrix.apply(m -> this.cropMatrix(rectangleToCrop, (Matrix<? extends PArray>)m));
            }
            frame = new Frame(leftTop, matrix);
            if (disableOverlapping) {
                this.checkIntersected(frame);
            }
            if (this.autoReindexLabels) {
                frame = frame.addIndexingBase(this.zerosLabelReservedForBackground, this.indexingBase);
                this.indexingBase = frame.nextIndexingBase(this.indexingBase, this.zerosLabelReservedForBackground);
            }
            frame = frame.actualizeLazyMatrix();
        }
        if (this.stitchingLabels) {
            this.getFrameObjectStitcher().correlate(frame, nonOptimized);
        }
        if (this.firstFramePosition == null) {
            this.firstFramePosition = frame.position();
        }
        if (this.frames.size() >= this.maximalNumberOfStoredFrames) {
            this.frames.remove();
        }
        this.frames.add(frame);
        return frame;
    }

    public IRectangularArea getFirstFramePosition() {
        return this.firstFramePosition;
    }

    public IRectangularArea reqFirstFramePosition() {
        IRectangularArea result = this.getFirstFramePosition();
        if (result == null) {
            throw new IllegalStateException("No frames were added from last clearing to " + String.valueOf(this));
        }
        return result;
    }

    public Frame getLastFrame() {
        return this.frames.peekLast();
    }

    public Frame reqLastFrame() {
        Frame result = this.getLastFrame();
        if (result == null) {
            throw new IllegalStateException("No frames in " + String.valueOf(this));
        }
        return result;
    }

    public Collection<Frame> allFrames() {
        return Collections.unmodifiableCollection(this.frames);
    }

    public List<Frame> allFramesWithMinCoordinate(int coordIndex, long coordinate) {
        return this.frames.stream().filter(frame -> frame.position.min(coordIndex) == coordinate).collect(Collectors.toList());
    }

    public List<Frame> allFramesWithMaxCoordinate(int coordIndex, long coordinate) {
        return this.frames.stream().filter(frame -> frame.position.max(coordIndex) == coordinate).collect(Collectors.toList());
    }

    public List<Frame> allIntersecting(IRectangularArea area) {
        Objects.requireNonNull(area, "Null area");
        return this.frames.stream().filter(frame -> area.intersects(frame.position)).collect(Collectors.toList());
    }

    public List<IRectangularArea> allPositions() {
        return this.frames.stream().map(frame -> frame.position).collect(Collectors.toList());
    }

    public void checkFrameCompatibility(Frame frame) {
        Objects.requireNonNull(frame, "Null frame");
        this.checkFrameCompatibility(frame.matrix);
    }

    public void checkFrameCompatibility(MultiMatrix matrix) {
        Objects.requireNonNull(matrix, "Null matrix");
        if (!this.frames.isEmpty()) {
            MultiMatrix existing = this.frames.iterator().next().matrix;
            if (matrix.elementType() != existing.elementType()) {
                throw new IllegalArgumentException("The specified frame and existing frames have different element types: " + String.valueOf(matrix) + " and " + String.valueOf(existing));
            }
            if (matrix.numberOfChannels() != existing.numberOfChannels()) {
                throw new IllegalArgumentException("The specified frame and existing frames have different number of channels: " + String.valueOf(matrix) + " and " + String.valueOf(existing));
            }
            if (matrix.dimCount() != existing.dimCount()) {
                throw new IllegalArgumentException("The specified frame and existing frames have different number of dimensions: " + String.valueOf(matrix) + " and " + String.valueOf(existing));
            }
        }
    }

    public boolean isCovered(IRectangularArea area) {
        Objects.requireNonNull(area, "Null rectangular area");
        if (this.frames.isEmpty()) {
            return false;
        }
        IRectangularArea existing = this.frames.iterator().next().position;
        if (area.coordCount() != existing.coordCount()) {
            throw new IllegalArgumentException("The checked area and existing frames have different number of dimensions: " + String.valueOf(area) + " and " + String.valueOf(existing));
        }
        return area.subtract(this.allPositions()).isEmpty();
    }

    public boolean isIntersected(IRectangularArea area) {
        Objects.requireNonNull(area, "Null rectangular area");
        for (Frame existing : this.frames) {
            if (area.coordCount() != existing.position.coordCount()) {
                throw new IllegalArgumentException("The checked area and existing frames have different number of dimensions: " + String.valueOf(area) + " and " + String.valueOf(existing.position));
            }
            if (!existing.position.intersects(area)) continue;
            return true;
        }
        return false;
    }

    public void checkIntersected(Frame frame) {
        Objects.requireNonNull(frame, "Null frame");
        this.checkIntersected(frame.position);
    }

    public void checkIntersected(IRectangularArea framePosition) {
        Objects.requireNonNull(framePosition, "Null framePosition");
        for (Frame existing : this.frames) {
            if (framePosition.coordCount() != existing.position.coordCount()) {
                throw new IllegalArgumentException("The checked frame and existing frames have different number of dimensions: " + String.valueOf(framePosition) + " and " + String.valueOf(existing.position));
            }
            if (!existing.position.intersects(framePosition)) continue;
            throw new IllegalArgumentException("The specified position " + String.valueOf(framePosition) + " overlaps with an existing " + String.valueOf(existing));
        }
    }

    public IRectangularArea containingRectangle() {
        return IRectangularArea.minimalContainingArea(this.allPositions());
    }

    public IRectangularArea changeRectangleOnMap(IRectangularArea originalArea, IRectangularArea changedArea, boolean originalAreaMustBeCovered) {
        Objects.requireNonNull(originalArea, "Null originalArea");
        Objects.requireNonNull(changedArea, "Null changedArea");
        if (changedArea.coordCount() != originalArea.coordCount()) {
            throw new IllegalArgumentException("Different number of dimensions of changedArea " + String.valueOf(changedArea) + "and originalArea " + String.valueOf(originalArea));
        }
        boolean originalAreaCovered = this.isCovered(originalArea);
        if (originalAreaMustBeCovered && !originalAreaCovered) {
            throw new IllegalArgumentException("Original area " + String.valueOf(originalArea) + " is not inside " + String.valueOf(this));
        }
        if (!originalArea.intersects(changedArea)) {
            return this.isCovered(changedArea) ? changedArea : originalArea;
        }
        IRange[] ranges = originalArea.ranges();
        for (int i = ranges.length - 1; i >= 0; --i) {
            IRange save = ranges[i];
            ranges[i] = IRange.of((long)changedArea.min(i), (long)save.max());
            if (!this.isCovered(IRectangularArea.of((IRange[])ranges))) {
                ranges[i] = save;
            }
            save = ranges[i];
            ranges[i] = IRange.of((long)save.min(), (long)changedArea.max(i));
            if (this.isCovered(IRectangularArea.of((IRange[])ranges))) continue;
            ranges[i] = save;
        }
        IRectangularArea result = IRectangularArea.of((IRange[])ranges);
        if (originalAreaCovered && !this.isCovered(result)) {
            throw new AssertionError((Object)(String.valueOf(result) + " is not covered by " + String.valueOf(this)));
        }
        return result;
    }

    public IRectangularArea expandRectangleOnMap(IRectangularArea originalArea, IPoint expansion, boolean originalAreaMustBeCovered) {
        return this.changeRectangleOnMap(originalArea, originalArea.dilate(expansion), originalAreaMustBeCovered);
    }

    public Frame readFrame(IRectangularArea area) {
        MultiMatrix matrix = this.readMatrix(area);
        return new Frame(area.min(), matrix);
    }

    public MultiMatrix readMatrix(IRectangularArea area) {
        Objects.requireNonNull(area, "Null area");
        if (this.frames.isEmpty()) {
            throw new IllegalStateException("No frames");
        }
        MultiMatrix existing = this.frames.iterator().next().matrix;
        if (area.coordCount() != existing.dimCount()) {
            throw new IllegalArgumentException("The requested area and existing frames have different number of dimensions: " + String.valueOf(area) + " and " + String.valueOf(existing));
        }
        ArrayList<Matrix> resultChannels = new ArrayList<Matrix>();
        for (int c = 0; c < existing.numberOfChannels(); ++c) {
            Matrix resultMatrix = Arrays.SMM.newMatrix(UpdatablePArray.class, existing.elementType(), area.sizes());
            long resultDimX = resultMatrix.dimX();
            UpdatablePArray resultArray = (UpdatablePArray)resultMatrix.array();
            long areaMinX = area.minX();
            long areaMaxX = area.maxX();
            long areaMinY = area.minY();
            long areaMaxY = area.maxY();
            for (Frame frame : this.frames) {
                long intersectionMaxY;
                long intersectionMinY;
                long intersectionMaxX;
                long intersectionMinX = Math.max(areaMinX, frame.minX);
                if (intersectionMinX > (intersectionMaxX = Math.min(areaMaxX, frame.maxX)) || (intersectionMinY = Math.max(areaMinY, frame.minY)) > (intersectionMaxY = Math.min(areaMaxY, frame.maxY))) continue;
                long length = intersectionMaxX - intersectionMinX + 1L;
                Matrix frameMatrix = frame.matrix.channel(c);
                long frameDimX = frame.dimX;
                PArray frameArray = (PArray)frameMatrix.array();
                long y = intersectionMinY - areaMinY;
                long maxY = intersectionMaxY - areaMinY;
                long frameY = intersectionMinY - frame.minY;
                long p = y * resultDimX + intersectionMinX - areaMinX;
                long frameP = frameY * frameDimX + intersectionMinX - frame.minX;
                while (y <= maxY) {
                    resultArray.subArr(p, length).copy(frameArray.subArr(frameP, length));
                    ++y;
                    p += resultDimX;
                    frameP += frameDimX;
                }
            }
            resultChannels.add(resultMatrix);
        }
        return MultiMatrix.of(resultChannels);
    }

    public MultiMatrix readMatrixReindexedByObjectPairs(IRectangularArea area, boolean quickCallAfterResolveAllBases) {
        if (this.frames.isEmpty()) {
            throw new IllegalStateException("No frames");
        }
        return this.readMatrixReindexedByObjectPairs(this.frames, area, quickCallAfterResolveAllBases);
    }

    public String toString() {
        return "map buffer with " + this.numberOfFrames() + "/" + this.maximalNumberOfStoredFrames + " frames, indexing base " + this.indexingBase + (this.autoReindexLabels ? ", auto-reindexing" : "") + (this.stitchingLabels ? ", auto-stitching" : ", no stitching") + (this.zerosLabelReservedForBackground ? ", zero-labels for background" : "");
    }

    public static Collection<IRectangularArea> externalBoundary(Collection<IRectangularArea> areas, boolean straightOnly) {
        List<IRectangularArea> dilation = MapBuffer.dilateBy1(areas, straightOnly);
        Queue result = IRectangularArea.subtractCollection(new ArrayDeque<IRectangularArea>(dilation), areas);
        for (IRectangularArea area : result) {
            MapBuffer.checkThinness(area);
        }
        return result;
    }

    public static List<IRectangularArea> internalBoundary(Collection<IRectangularArea> areas, boolean straightOnly) {
        IRectangularArea container = IRectangularArea.minimalContainingArea(areas);
        if (container == null) {
            return Collections.emptyList();
        }
        Queue complement = container.dilate(1L).subtract(areas);
        Collection<IRectangularArea> boundary = MapBuffer.externalBoundary(complement, straightOnly);
        return container.intersection(boundary);
    }

    MultiMatrix readMatrixReindexedByObjectPairs(Collection<Frame> frames, IRectangularArea area, boolean quickCallAfterResolveAllBases) {
        int[] result = this.readLabelsReindexedByObjectPairs(frames, area, quickCallAfterResolveAllBases);
        UpdatableIntArray resultArray = SimpleMemoryModel.asUpdatableIntArray((int[])result);
        return MultiMatrix.of2DMono((Matrix)Matrices.matrix((Array)resultArray, (long[])area.sizes()));
    }

    int[] readLabelsReindexedByObjectPairs(Collection<Frame> frames, IRectangularArea area, boolean quickCallAfterResolveAllBases) {
        return this.readLabelsReindexedByObjectPairs(null, 0, frames, area, quickCallAfterResolveAllBases);
    }

    int[] readLabelsReindexedByObjectPairs(int[] result, int resultOffset, Collection<Frame> frames, IRectangularArea area, boolean quickCallAfterResolveAllBases) {
        Objects.requireNonNull(area, "Null area");
        Objects.requireNonNull(frames, "Null frames");
        if (resultOffset < 0) {
            throw new IllegalArgumentException("Negative resultOffset = " + resultOffset);
        }
        long areaSize = 0L;
        if (area.coordCount() == 2 && (area.sizeX() >= Integer.MAX_VALUE || area.sizeY() >= Integer.MAX_VALUE || (areaSize = area.sizeX() * area.sizeY()) > (long)(Integer.MAX_VALUE - resultOffset))) {
            throw new TooLargeArrayException("The requested ares " + String.valueOf(area) + " is too large for reindexing: it contains >=2147483647 elements");
        }
        if (result == null) {
            result = new int[(int)(areaSize + (long)resultOffset)];
        }
        if (frames.isEmpty()) {
            return result;
        }
        int[] labels = result;
        UpdatableIntArray labelsArray = SimpleMemoryModel.asUpdatableIntArray((int[])labels);
        MultiMatrix existing = frames.iterator().next().matrix;
        if (area.coordCount() != 2 || existing.dimCount() != 2) {
            throw new IllegalArgumentException("Objects must be represented by 2-dimensional matrix (multidimensional matrices are not supported by the stitcher), but we have area " + String.valueOf(area) + " and existing frame " + String.valueOf(existing));
        }
        FrameObjectStitcher.checkLabels(existing);
        long areaMinX = area.minX();
        long areaMaxX = area.maxX();
        long areaMinY = area.minY();
        long areaMaxY = area.maxY();
        if (areaMinY == areaMaxY && quickCallAfterResolveAllBases) {
            MapBuffer.readLabelsLineReindexedByObjectPairsAfterResolveAllBases(result, resultOffset, this.objectPairs.dynamicDisjointSet(), frames, areaMinY, areaMinX, areaMaxX);
            return result;
        }
        int resultDimX = (int)(areaMaxX - areaMinX + 1L);
        for (Frame frame : frames) {
            long intersectionMaxY;
            long intersectionMinY;
            long intersectionMaxX;
            long intersectionMinX = Math.max(areaMinX, frame.minX);
            if (intersectionMinX > (intersectionMaxX = Math.min(areaMaxX, frame.maxX)) || (intersectionMinY = Math.max(areaMinY, frame.minY)) > (intersectionMaxY = Math.min(areaMaxY, frame.maxY))) continue;
            assert (area.intersects(frame.position));
            int length = (int)(intersectionMaxX - intersectionMinX + 1L);
            assert (length >= 1) : "IRectangularArea cannot have zero sizes";
            Matrix<? extends PArray> frameMatrix = frame.channel0;
            PArray frameArray = (PArray)frameMatrix.array();
            if (!(frameArray instanceof PFixedArray)) {
                throw new IllegalArgumentException("Objects must be represented by 1-channel integer matrix with <=32 bits/element, but we have " + String.valueOf(frameMatrix));
            }
            assert (frameMatrix.array() instanceof PFixedArray) : "checkLabels didn't work properly: " + String.valueOf(frameMatrix);
            long frameDimX = frame.dimX;
            int minY = (int)(intersectionMinY - areaMinY);
            int maxY = (int)(intersectionMaxY - areaMinY);
            assert ((long)maxY == intersectionMaxY - areaMinY) : "impossible: area was already checked! " + intersectionMinY + ".." + intersectionMaxY + ", " + String.valueOf(area);
            long differenceY = areaMinY - frame.minY;
            int shiftX = (int)(intersectionMinX - areaMinX);
            long frameShiftX = intersectionMinX - frame.minX;
            DynamicDisjointSet dynamicDisjointSet = this.objectPairs.dynamicDisjointSet();
            if (!quickCallAfterResolveAllBases) {
                int p = minY * resultDimX + shiftX + resultOffset;
                long frameY = intersectionMinY - frame.minY;
                assert (frameY == (long)minY + differenceY);
                long frameP = frameY * frameDimX + frameShiftX;
                int y2 = minY;
                while (y2 <= maxY) {
                    MapBuffer.copyIoInts(labels, labelsArray, p, frameArray, frameP, length);
                    int to = p + length;
                    for (int i = p; i < to; ++i) {
                        labels[i] = this.objectPairs.reindex(labels[i]);
                    }
                    ++y2;
                    p += resultDimX;
                    frameP += frameDimX;
                }
                continue;
            }
            if (resultDimX == 1) {
                assert (length == 1) : "intersection cannot be greater than area";
                int n = maxY - minY + 1;
                IntStream.range(0, n + 15 >>> 4).parallel().forEach(block -> {
                    int i = block << 4;
                    int y = minY + i;
                    int p = y + shiftX + resultOffset;
                    long frameP = ((long)y + differenceY) * frameDimX + frameShiftX;
                    PFixedArray frameFixedArray = (PFixedArray)frameArray;
                    int to = (int)Math.min((long)i + 16L, (long)n);
                    while (i < to) {
                        int label = frameFixedArray.getInt(frameP);
                        labels[p] = dynamicDisjointSet.parentOrThis(label);
                        ++i;
                        ++p;
                        frameP += frameDimX;
                    }
                });
                continue;
            }
            if (!(frameArray instanceof IntArray)) {
                IntStream.range(minY, maxY + 1).parallel().forEach(y -> {
                    int p;
                    long frameP = ((long)y + differenceY) * frameDimX + frameShiftX;
                    Arrays.applyFunc(null, (Func)Func.IDENTITY, (UpdatablePArray)labelsArray.subArr((long)p, (long)length), (PArray[])new PArray[]{(PArray)frameArray.subArr(frameP, (long)length)});
                    int to = p + length;
                    for (p = y * resultDimX + shiftX + resultOffset; p < to; ++p) {
                        labels[p] = dynamicDisjointSet.parentOrThis(labels[p]);
                    }
                });
                continue;
            }
            IntStream.range(minY, maxY + 1).parallel().forEach(y -> {
                int p;
                long frameP = ((long)y + differenceY) * frameDimX + frameShiftX;
                frameArray.getData(frameP, (Object)labels, p, length);
                int to = p + length;
                for (p = y * resultDimX + shiftX + resultOffset; p < to; ++p) {
                    labels[p] = dynamicDisjointSet.parentOrThis(labels[p]);
                }
            });
        }
        return result;
    }

    static void readLabelsLineReindexedByObjectPairsAfterResolveAllBases(int[] result, int resultOffset, DynamicDisjointSet dynamicDisjointSet, Collection<Frame> frames, long areaY, long areaMinX, long areaMaxX) {
        assert (result != null);
        assert (resultOffset >= 0);
        UpdatableIntArray labelsArray = SimpleMemoryModel.asUpdatableIntArray((int[])result);
        for (Frame frame : frames) {
            if (frame.intMatrix) {
                MapBuffer.readFrameToReindexedLine(result, resultOffset, dynamicDisjointSet, frame, areaY, areaMinX, areaMaxX);
                continue;
            }
            MapBuffer.readFrameToReindexedLine(result, resultOffset, dynamicDisjointSet, frame, areaY, areaMinX, areaMaxX, labelsArray);
        }
    }

    private Frame tryToAddFrameWithReindexingOptimized(MultiMatrix matrix, IPoint leftTop, IRectangularArea rectangleToCrop, boolean disableOverlapping) {
        DirectAccessible directAccessible;
        PArray channel0Array = (PArray)matrix.channel(0).array();
        if (this.autoReindexLabels && matrix.dimCount() == 2 && channel0Array instanceof IntArray && channel0Array instanceof DirectAccessible && (directAccessible = (DirectAccessible)channel0Array).hasJavaArray() && directAccessible.javaArrayOffset() == 0) {
            int[] channel0Ints = (int[])directAccessible.javaArray();
            return this.addFrameWithReindexingDirectAccessible(channel0Ints, (int)matrix.dim(0), (int)matrix.dim(1), leftTop, rectangleToCrop, disableOverlapping);
        }
        return null;
    }

    private Frame addFrameWithReindexingDirectAccessible(int[] labels, int dimX, int dimY, IPoint leftTop, IRectangularArea rectangleToCrop, boolean disableOverlapping) {
        int toY;
        int toX;
        int fromY;
        int fromX;
        assert (dimX >= 0 & dimY >= 0);
        assert ((long)dimX * (long)dimY <= Integer.MAX_VALUE) : "direct accessible matrix cannot be larger than Integer.MAX_VALUE";
        assert (this.autoReindexLabels);
        if (rectangleToCrop == null) {
            fromX = 0;
            fromY = 0;
            toX = dimX;
            toY = dimY;
        } else {
            if (rectangleToCrop.minX() < 0L || rectangleToCrop.minY() < 0L || rectangleToCrop.maxX() >= (long)dimX || rectangleToCrop.maxY() >= (long)dimY) {
                throw new IllegalArgumentException("Rectangle to crop " + String.valueOf(rectangleToCrop) + " extends beyond the borders of the labels matrix " + dimX + "x" + dimY);
            }
            fromX = (int)rectangleToCrop.minX();
            fromY = (int)rectangleToCrop.minY();
            toX = (int)rectangleToCrop.maxX() + 1;
            toY = (int)rectangleToCrop.maxY() + 1;
        }
        int resultDimX = toX - fromX;
        int resultDimY = toY - fromY;
        IRectangularArea framePosition = Frame.framePosition(leftTop, resultDimX, resultDimY);
        assert (toX > fromX && toY > fromY) : "impossible after checks in framePosition()";
        if (disableOverlapping) {
            this.checkIntersected(framePosition);
        }
        int[] result = new int[resultDimX * resultDimY];
        int newIndexingBase = IntStream.range(0, resultDimY).parallel().map(this.zerosLabelReservedForBackground ? y -> {
            int offset = (fromY + y) * dimX + fromX;
            return this.correctIndexingBaseWithZeroBackground(labels, offset, result, y * resultDimX, resultDimX);
        } : y -> {
            int offset = (fromY + y) * dimX + fromX;
            return this.correctIndexingBaseWithoutBackground(labels, offset, result, y * resultDimX, resultDimX);
        }).max().orElse(-1);
        assert (newIndexingBase != -1) : "no iterations instead of " + resultDimY;
        this.indexingBase = Math.max(this.indexingBase, newIndexingBase);
        return new Frame(leftTop, MultiMatrix.ofMono((Matrix)Matrices.matrix((Array)SimpleMemoryModel.asUpdatableIntArray((int[])result), (long[])new long[]{resultDimX, resultDimY})));
    }

    private int correctIndexingBaseWithZeroBackground(int[] labels, int offset, int[] result, int resultOffset, int length) {
        long increment = this.indexingBase;
        assert (increment >= 0L);
        int maxLabel = 0;
        int offsetTo = offset + length;
        while (offset < offsetTo) {
            long label = labels[offset];
            if (label < 0L) {
                throw new IllegalArgumentException("Objects must be represented by zero or negative integers, but it contains label " + label + " at offset " + offset);
            }
            if (label != 0L) {
                int newLabel;
                if ((label += increment) >= Integer.MAX_VALUE) {
                    throw new IllegalStateException("Cannot continue auto-indexing: maximal label is " + label);
                }
                result[resultOffset] = newLabel = (int)label;
                if (newLabel > maxLabel) {
                    maxLabel = newLabel;
                }
            }
            ++offset;
            ++resultOffset;
        }
        return maxLabel;
    }

    private int correctIndexingBaseWithoutBackground(int[] labels, int offset, int[] result, int resultOffset, int length) {
        long increment = this.indexingBase;
        assert (increment >= 0L);
        int maxLabel = 0;
        int offsetTo = offset + length;
        while (offset < offsetTo) {
            int newLabel;
            long label = labels[offset];
            if (label < 0L) {
                throw new IllegalArgumentException("Objects must be represented by zero or negative integers, but it contains label " + label + " at offset " + offset);
            }
            if ((label += increment) >= Integer.MAX_VALUE) {
                throw new IllegalStateException("Cannot continue auto-indexing: maximal label is " + label);
            }
            result[resultOffset] = newLabel = (int)label;
            if (newLabel > maxLabel) {
                maxLabel = newLabel;
            }
            ++offset;
            ++resultOffset;
        }
        return maxLabel + 1;
    }

    private static void readFrameToReindexedLine(int[] result, int resultOffset, DynamicDisjointSet dynamicDisjointSet, Frame frame, long areaY, long areaMinX, long areaMaxX) {
        int p;
        long intersectionMaxX;
        if (areaY < frame.minY || areaY > frame.maxY) {
            return;
        }
        long intersectionMinX = Math.max(areaMinX, frame.minX);
        if (intersectionMinX > (intersectionMaxX = Math.min(areaMaxX, frame.maxX))) {
            return;
        }
        int length = (int)(intersectionMaxX - intersectionMinX + 1L);
        PArray frameArray = (PArray)frame.channel0.array();
        if (!(frameArray instanceof PFixedArray)) {
            throw new IllegalArgumentException("Objects must be represented by 1-channel integer matrix with <=32 bits/element, but we have " + String.valueOf(frame.channel0));
        }
        long frameDimX = frame.dimX;
        int shiftX = (int)(intersectionMinX - areaMinX);
        long frameShiftX = intersectionMinX - frame.minX;
        long frameP = (areaY - frame.minY) * frameDimX + frameShiftX;
        frameArray.getData(frameP, (Object)result, p, length);
        int to = p + length;
        for (p = shiftX + resultOffset; p < to; ++p) {
            result[p] = dynamicDisjointSet.parentOrThis(result[p]);
        }
    }

    private static void readFrameToReindexedLine(int[] result, int resultOffset, DynamicDisjointSet dynamicDisjointSet, Frame frame, long areaY, long areaMinX, long areaMaxX, UpdatableIntArray labelsArray) {
        int p;
        long intersectionMaxX;
        if (areaY < frame.minY || areaY > frame.maxY) {
            return;
        }
        long intersectionMinX = Math.max(areaMinX, frame.minX);
        if (intersectionMinX > (intersectionMaxX = Math.min(areaMaxX, frame.maxX))) {
            return;
        }
        int length = (int)(intersectionMaxX - intersectionMinX + 1L);
        PArray frameArray = (PArray)frame.channel0.array();
        if (!(frameArray instanceof PFixedArray)) {
            throw new IllegalArgumentException("Objects must be represented by 1-channel integer matrix with <=32 bits/element, but we have " + String.valueOf(frame.channel0));
        }
        long frameDimX = frame.dimX;
        int shiftX = (int)(intersectionMinX - areaMinX);
        long frameShiftX = intersectionMinX - frame.minX;
        long frameP = (areaY - frame.minY) * frameDimX + frameShiftX;
        Arrays.applyFunc(null, (Func)Func.IDENTITY, (UpdatablePArray)labelsArray.subArr((long)p, (long)length), (PArray[])new PArray[]{(PArray)frameArray.subArr(frameP, (long)length)});
        int to = p + length;
        for (p = shiftX + resultOffset; p < to; ++p) {
            result[p] = dynamicDisjointSet.parentOrThis(result[p]);
        }
    }

    private static void checkThinness(IRectangularArea area) {
        boolean thin = false;
        int n = area.coordCount();
        for (int k = 0; k < n; ++k) {
            if (area.size(k) != 1L) continue;
            thin = true;
        }
        if (!thin) {
            throw new AssertionError((Object)(String.valueOf(area) + " is not thin!"));
        }
    }

    private static List<IRectangularArea> dilateBy1(Collection<IRectangularArea> areas, boolean straightOnly) {
        return areas.isEmpty() ? Collections.emptyList() : IRectangularArea.dilate(areas, (IPoint)IPoint.ofEqualCoordinates((int)areas.iterator().next().coordCount(), (long)1L), (boolean)straightOnly);
    }

    private static Func incrementingFunc(boolean zerosLabelReservedForBackground, final double increment) {
        return zerosLabelReservedForBackground ? new AbstractFunc(){

            public double get(double ... x) {
                return this.get(x[0]);
            }

            public double get(double x0) {
                return x0 == 0.0 ? 0.0 : x0 + increment;
            }
        } : LinearFunc.getInstance((double)increment, (double[])new double[]{1.0});
    }

    private static int[] buildRestoringTableWithReserved(int[] map, int count, int indexingBase, int minLabel) {
        assert (count >= indexingBase);
        int[] restoringTable = new int[count];
        for (int reserved = 0; reserved < indexingBase; ++reserved) {
            restoringTable[reserved] = reserved;
        }
        for (int labelMinusMin = 0; labelMinusMin < map.length; ++labelMinusMin) {
            int newLabel = map[labelMinusMin];
            if (newLabel == 0) continue;
            restoringTable[newLabel] = minLabel + labelMinusMin;
        }
        return restoringTable;
    }

    private static int[] buildRestoringTableWithoutReserved(int[] map, int count, int indexingBase, int minLabel) {
        assert (count >= indexingBase);
        int[] restoringTable = new int[count - indexingBase];
        for (int labelMinusMin = 0; labelMinusMin < map.length; ++labelMinusMin) {
            int newLabel = map[labelMinusMin];
            if (newLabel == 0) continue;
            restoringTable[newLabel - indexingBase] = minLabel + labelMinusMin;
        }
        return restoringTable;
    }

    private static void copyIoInts(int[] result, UpdatableIntArray resultArray, int resultOffset, PArray source, long sourceOffset, int length) {
        if (source instanceof IntArray) {
            source.getData(sourceOffset, (Object)result, resultOffset, length);
        } else {
            Arrays.applyFunc(null, (Func)Func.IDENTITY, (UpdatablePArray)resultArray.subArr((long)resultOffset, (long)length), (PArray[])new PArray[]{(PArray)source.subArr(sourceOffset, (long)length)});
        }
    }

    private Matrix<? extends PArray> cropMatrix(IRectangularArea rectangleToCrop, Matrix<? extends PArray> m) {
        try {
            return m.subMatrix(rectangleToCrop);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Rectangle to crop " + String.valueOf(rectangleToCrop) + " extends beyond the borders of the " + String.valueOf(m), e);
        }
    }

    public static class Frame {
        private final IRectangularArea position;
        final long dimX;
        final long dimY;
        final long minX;
        final long maxX;
        final long minY;
        final long maxY;
        private final MultiMatrix matrix;
        final Matrix<? extends PArray> channel0;
        final int[] channel0Ints;
        private final boolean intMatrix;

        public Frame(IPoint leftTop, MultiMatrix matrix) {
            this(Frame.framePosition(leftTop, matrix), matrix);
        }

        private Frame(IRectangularArea position, MultiMatrix matrix) {
            DirectAccessible directAccessible;
            assert (position != null);
            assert (matrix != null);
            this.position = position;
            this.matrix = matrix;
            this.channel0 = matrix.channel(0);
            PArray channel0Array = (PArray)this.channel0.array();
            this.intMatrix = channel0Array instanceof IntArray;
            int[] channel0Ints = null;
            if (this.intMatrix && channel0Array instanceof DirectAccessible && (directAccessible = (DirectAccessible)channel0Array).hasJavaArray() && directAccessible.javaArrayOffset() == 0) {
                channel0Ints = (int[])directAccessible.javaArray();
            }
            this.channel0Ints = channel0Ints;
            this.dimX = matrix.dim(0);
            this.minX = position.minX();
            this.maxX = this.minX + this.dimX - 1L;
            if (matrix.dimCount() < 2) {
                this.dimY = 1L;
                this.maxY = 0L;
                this.minY = 0L;
            } else {
                this.dimY = matrix.dim(1);
                this.minY = position.minY();
                this.maxY = this.minY + this.dimY - 1L;
            }
        }

        public static IRectangularArea framePosition(IPoint leftTop, MultiMatrix matrix) {
            Objects.requireNonNull(matrix, "Null matrix");
            return Frame.framePosition(leftTop, matrix.dimensions());
        }

        public static IRectangularArea framePosition(IPoint leftTop, long ... matrixDimensions) {
            Objects.requireNonNull(matrixDimensions, "Null matrixDimensions");
            Objects.requireNonNull(leftTop, "Null leftTop position");
            if (leftTop.coordCount() != matrixDimensions.length) {
                throw new IllegalArgumentException("Different number of dimensions: " + leftTop.coordCount() + "-dimensional point " + String.valueOf(leftTop) + " and " + matrixDimensions.length + "-dimensional matrix");
            }
            long[] max = new long[matrixDimensions.length];
            for (int k = 0; k < matrixDimensions.length; ++k) {
                if (matrixDimensions[k] <= 0L) {
                    throw new IllegalArgumentException("Matrix dimensions for a frame cannot be zero or negative: " + JArrays.toString((long[])matrixDimensions, (String)"x", (int)256));
                }
                max[k] = Math.addExact(leftTop.coord(k), matrixDimensions[k] - 1L);
            }
            return IRectangularArea.of((IPoint)leftTop, (IPoint)IPoint.of((long[])max));
        }

        public MultiMatrix matrix() {
            return this.matrix;
        }

        public IRectangularArea position() {
            return this.position;
        }

        public boolean isIntMatrix() {
            return this.intMatrix;
        }

        public Frame matrix(MultiMatrix newMatrix) {
            this.matrix.checkDimensionEquality(newMatrix, "previous matrix in the frame", "new matrix");
            return new Frame(this.position.min(), newMatrix);
        }

        public Frame cloneMatrix() {
            return this.matrix(this.matrix.clone());
        }

        public Frame actualizeLazyMatrix() {
            return this.matrix(this.matrix.actualizeLazy());
        }

        public Frame subFrameWithZeroContinuation(IRectangularArea other) {
            if (other.equals((Object)this.position)) {
                return this;
            }
            IRectangularArea subRectangle = other.shiftBack(this.position.min());
            return new Frame(other.min(), this.matrix.apply(m -> m.subMatrix(subRectangle, Matrix.ContinuationMode.ZERO_CONSTANT)));
        }

        public int nextIndexingBase(int currentIndexingBase, boolean zerosLabelReservedForBackground) {
            FrameObjectStitcher.checkLabels(this.matrix);
            int maxLabel = (int)Arrays.rangeOf((PArray)((PArray)this.channel0.array())).max();
            if (maxLabel < 0) {
                throw new IllegalStateException("Cannot auto-index: matrix contains negative label " + maxLabel);
            }
            if (maxLabel == Integer.MAX_VALUE) {
                throw new IllegalStateException("Cannot continue auto-indexing: maximal label is 2147483647");
            }
            return Math.max(currentIndexingBase, zerosLabelReservedForBackground ? maxLabel : maxLabel + 1);
        }

        public Frame addIndexingBase(boolean zerosLabelReservedForBackground, int indexingBase) {
            FrameObjectStitcher.checkLabels(this.matrix);
            if (indexingBase == 0) {
                return this.actualizeLazyMatrix();
            }
            Func adding = MapBuffer.incrementingFunc(zerosLabelReservedForBackground, indexingBase);
            return this.matrix(MultiMatrix.ofMono((Matrix)Matrices.asFuncMatrix((Func)adding, (Class)this.channel0.type(PArray.class), this.channel0).clone()));
        }

        public ReindexedFrame sequentiallyReindex(boolean includeReservedInRestoringTable) {
            return new ReindexedFrame(this, includeReservedInRestoringTable);
        }

        public String toString() {
            return "frame " + String.valueOf(this.position) + " with " + String.valueOf(this.matrix);
        }

        public final class ReindexedFrame {
            private final int[] restoringTable;
            private final Frame reindexed;

            private ReindexedFrame(Frame this$0, boolean includeReservedInRestoringTable) {
                int maxLabel;
                FrameObjectStitcher.checkLabels(this$0.matrix);
                int[] labels = this$0.matrix.channel(0).toInt();
                UpdatableIntArray labelsArray = SimpleMemoryModel.asUpdatableIntArray((int[])labels);
                Range range = MultiMatrix.nonZeroRangeOf((PArray)labelsArray);
                int minLabel = range == null ? 0 : (int)range.min();
                int n = maxLabel = range == null ? 0 : (int)range.max();
                if (minLabel < 0) {
                    throw new IllegalStateException("Cannot sequentially reindex: matrix contains negative label " + minLabel);
                }
                assert ((long)maxLabel + 1L - (long)minLabel <= Integer.MAX_VALUE) : "because minLabel >= 0";
                int[] map = new int[maxLabel + 1 - minLabel];
                IntStream.range(0, labels.length + 255 >>> 8).parallel().forEach(block -> {
                    int i;
                    int to = (int)Math.min((long)i + 256L, (long)labels.length);
                    for (i = block << 8; i < to; ++i) {
                        int label = labels[i];
                        if (label == 0) continue;
                        map[label - minLabel] = -157;
                    }
                });
                int count = 1;
                for (int labelMinusMin = 0; labelMinusMin < map.length; ++labelMinusMin) {
                    if (map[labelMinusMin] == 0) continue;
                    map[labelMinusMin] = count++;
                }
                this.restoringTable = includeReservedInRestoringTable ? MapBuffer.buildRestoringTableWithReserved(map, count, 1, minLabel) : MapBuffer.buildRestoringTableWithoutReserved(map, count, 1, minLabel);
                IntStream.range(0, labels.length + 255 >>> 8).parallel().forEach(block -> {
                    int i;
                    int to = (int)Math.min((long)i + 256L, (long)labels.length);
                    for (i = block << 8; i < to; ++i) {
                        int label = labels[i];
                        if (label == 0) continue;
                        labels[i] = map[label - minLabel];
                    }
                });
                this.reindexed = this$0.matrix((MultiMatrix)MultiMatrix.of2DMono((Matrix)labelsArray.matrix(this$0.matrix.dimensions())));
            }

            public int[] sequentialResrotingTable() {
                return this.restoringTable;
            }

            public Frame reindexed() {
                return this.reindexed;
            }
        }
    }
}

