/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames.graph;

import java.util.Objects;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.modules.maps.frames.graph.ShortestPathFinder;
import net.algart.executors.modules.maps.frames.graph.WeightedDirectedGraph;

public final class MinimalCostLinkingOnStraight
implements WeightedDirectedGraph {
    private final double[] source;
    private final double[] target;
    private final int numberOfVertices;
    private final int[] sIndex;
    private final int[] tIndex;
    private final int[] neighbourOffset;
    private final ShortestPathFinder finder;
    private final int[] resultShortestPath;
    private int numberOfLinks = 0;

    private MinimalCostLinkingOnStraight(ShortestPathFinder.Algorithm algorithm, double[] source, double[] target) {
        Objects.requireNonNull(algorithm, "Null algorithm");
        Objects.requireNonNull(source, "Null source");
        Objects.requireNonNull(target, "Null target");
        if ((long)source.length * (long)target.length + 1L > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large array: source.length * target.length + 1 = " + source.length + " * " + target.length + " + 1 > Integer.MAX_VALUE");
        }
        this.checkSorted(source);
        this.checkSorted(target);
        this.source = source;
        this.target = target;
        this.numberOfVertices = source.length * target.length + 1;
        this.sIndex = new int[this.numberOfVertices];
        this.tIndex = new int[this.numberOfVertices];
        for (int v = 1; v < this.numberOfVertices; ++v) {
            this.sIndex[v] = (v - 1) % this.source.length;
            this.tIndex[v] = (v - 1) / this.source.length;
        }
        this.neighbourOffset = new int[]{1, source.length, source.length + 1};
        this.finder = ShortestPathFinder.newInstance(algorithm, this);
        this.resultShortestPath = new int[source.length + target.length + 1];
    }

    public static MinimalCostLinkingOnStraight newInstance(ShortestPathFinder.Algorithm algorithm, double[] source, double[] target) {
        return new MinimalCostLinkingOnStraight(algorithm, source, target);
    }

    public double[] source() {
        return this.source;
    }

    public double[] target() {
        return this.target;
    }

    public void findBestLinks() {
        this.finder.findShortestPaths(0);
        int targetVertex = this.numberOfVertices - 1;
        this.numberOfLinks = this.finder.getPath(this.resultShortestPath, targetVertex) - 1;
    }

    public int getNumberOfLinks() {
        return this.numberOfLinks;
    }

    public int getSourceIndex(int linkIndex) {
        this.checkIndex(linkIndex);
        return this.sIndex[this.resultShortestPath[linkIndex + 1]];
    }

    public int getTargetIndex(int linkIndex) {
        this.checkIndex(linkIndex);
        return this.tIndex[this.resultShortestPath[linkIndex + 1]];
    }

    public double getLinkCost(int linkIndex) {
        int sIndex = this.getSourceIndex(linkIndex);
        int tIndex = this.getTargetIndex(linkIndex);
        return Math.abs(this.source[sIndex] - this.target[tIndex]);
    }

    public double getSummaryCost() {
        double sum = 0.0;
        for (int k = 0; k < this.numberOfLinks; ++k) {
            sum += this.getLinkCost(k);
        }
        return sum;
    }

    @Override
    public int numberOfVertices() {
        return this.numberOfVertices;
    }

    @Override
    public int numberOfOutgoingEdges(int vertex) {
        if (vertex == 0) {
            return this.numberOfVertices > 1 ? 1 : 0;
        }
        if (this.sIndex[vertex] < this.source.length - 1) {
            return this.tIndex[vertex] < this.target.length - 1 ? 3 : 1;
        }
        return this.tIndex[vertex] < this.target.length - 1 ? 1 : 0;
    }

    @Override
    public int neighbourVertex(int vertex, int neighbourIndex) {
        if (vertex == 0) {
            if (this.numberOfVertices <= 1) {
                throw new IndexOutOfBoundsException("Degenerated graph: no edges");
            }
            return 1;
        }
        if (this.sIndex[vertex] < this.source.length - 1) {
            if (this.tIndex[vertex] < this.target.length - 1) {
                return vertex + this.neighbourOffset[neighbourIndex];
            }
            return vertex + 1;
        }
        if (this.tIndex[vertex] < this.target.length - 1) {
            return vertex + this.source.length;
        }
        throw new IndexOutOfBoundsException("No neighbours for last points");
    }

    @Override
    public double edgeWeight(int vertex, int neighbourIndex) {
        if (vertex == 0) {
            return Math.abs(this.source[0] - this.target[0]);
        }
        int sIndex = this.sIndex[vertex];
        int tIndex = this.tIndex[vertex];
        if (sIndex < this.source.length - 1) {
            if (tIndex < this.target.length - 1) {
                switch (neighbourIndex) {
                    case 0: {
                        return Math.abs(this.source[sIndex + 1] - this.target[tIndex]);
                    }
                    case 1: {
                        return Math.abs(this.source[sIndex] - this.target[tIndex + 1]);
                    }
                    case 2: {
                        return Math.abs(this.source[sIndex + 1] - this.target[tIndex + 1]);
                    }
                }
                throw new IndexOutOfBoundsException("neighbourIndex = " + neighbourIndex + " > 2");
            }
            return Math.abs(this.source[sIndex + 1] - this.target[tIndex]);
        }
        if (tIndex < this.target.length - 1) {
            return Math.abs(this.source[sIndex] - this.target[tIndex + 1]);
        }
        throw new IndexOutOfBoundsException("No neighbours");
    }

    private void checkSorted(double[] points) {
        for (int k = 1; k < points.length; ++k) {
            if (!(points[k] < points[k - 1])) continue;
            throw new IllegalArgumentException("Array of points is not sorted: p[" + k + "] = " + points[k] + " < p[" + (k - 1) + "] = " + points[k - 1]);
        }
    }

    private void checkIndex(int k) {
        if (this.numberOfLinks == 0) {
            throw new IllegalStateException("Links are not found");
        }
        if (k < 0 || k >= this.numberOfLinks) {
            throw new IndexOutOfBoundsException("Index of link " + k + " is out of range 0.." + (this.numberOfLinks - 1));
        }
    }
}

