/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames.graph;

import java.util.Objects;
import net.algart.executors.modules.maps.frames.graph.WeightedDirectedGraph;

public final class SimpleWeightedDirectedGraph
implements WeightedDirectedGraph {
    private final int numberOfVertices;
    private final int[] numberOfOutgoingEdges;
    private final int[][] neighboursVertices;
    private final double[][] edgeWeights;

    public SimpleWeightedDirectedGraph(Iterable<Edge> edges) {
        this(SimpleWeightedDirectedGraph.maxVertexIndex(edges) + 1, edges);
    }

    public SimpleWeightedDirectedGraph(int numberOfVertices, Iterable<Edge> edges) {
        Objects.requireNonNull(edges, "Null edges");
        if (numberOfVertices < 0) {
            throw new IllegalArgumentException("Negative numberOfVertices");
        }
        this.numberOfVertices = numberOfVertices;
        this.numberOfOutgoingEdges = new int[numberOfVertices];
        for (Edge edge : edges) {
            this.checkVertexIndex(edge.vertexFrom);
            this.checkVertexIndex(edge.vertexTo);
            int n = edge.vertexFrom;
            this.numberOfOutgoingEdges[n] = this.numberOfOutgoingEdges[n] + 1;
        }
        this.neighboursVertices = new int[numberOfVertices][];
        this.edgeWeights = new double[numberOfVertices][];
        for (int k = 0; k < numberOfVertices; ++k) {
            this.neighboursVertices[k] = new int[this.numberOfOutgoingEdges(k)];
            this.edgeWeights[k] = new double[this.numberOfOutgoingEdges(k)];
        }
        int[] indexes = new int[numberOfVertices];
        for (Edge edge : edges) {
            int v = edge.vertexFrom;
            this.neighboursVertices[v][indexes[v]] = edge.vertexTo;
            this.edgeWeights[v][indexes[v]] = edge.weight;
            int n = v;
            indexes[n] = indexes[n] + 1;
        }
    }

    @Override
    public int numberOfVertices() {
        return this.numberOfVertices;
    }

    @Override
    public int numberOfOutgoingEdges(int vertex) {
        return this.numberOfOutgoingEdges[vertex];
    }

    @Override
    public int neighbourVertex(int vertex, int neighbourIndex) {
        return this.neighboursVertices[vertex][neighbourIndex];
    }

    @Override
    public double edgeWeight(int vertex, int neighbourIndex) {
        return this.edgeWeights[vertex][neighbourIndex];
    }

    private static int maxVertexIndex(Iterable<Edge> edges) {
        Objects.requireNonNull(edges, "Null edges");
        int result = -1;
        for (Edge edge : edges) {
            result = Math.max(result, edge.vertexFrom);
            result = Math.max(result, edge.vertexTo);
        }
        return result;
    }

    public static class Edge {
        final int vertexFrom;
        final int vertexTo;
        final double weight;

        public Edge(int vertexFrom, int vertexTo, double weight) {
            if (vertexFrom < 0) {
                throw new IllegalArgumentException("Negative vertexFrom");
            }
            if (vertexTo < 0) {
                throw new IllegalArgumentException("Negative vertexTo");
            }
            this.vertexFrom = vertexFrom;
            this.vertexTo = vertexTo;
            this.weight = weight;
        }

        public int vertexFrom() {
            return this.vertexFrom;
        }

        public int vertexTo() {
            return this.vertexTo;
        }

        public double weight() {
            return this.weight;
        }

        public Edge reverse() {
            return new Edge(this.vertexTo, this.vertexFrom, this.weight);
        }
    }
}

