/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.pyramids.io;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.maps.pyramids.io.api.sources.ImageIOPlanePyramidSourceFactory;
import net.algart.maps.pyramids.io.formats.sources.svs.SVSPlanePyramidSourceFactory;

public enum ImagePyramidFormatKind {
    AUTO_DETECT_BY_EXTENSION(null, new String[0]),
    JAVA_IMAGEIO(ImageIOPlanePyramidSourceFactory.class.getName(), new String[0]),
    SVS(ImagePyramidFormatKind.factory(new String[]{"net.algart.maps.pyramids.io.formats.sources.factories.SVS"}, SVSPlanePyramidSourceFactory.class), "svs"),
    CUSTOM(null, new String[0]);

    private final String factoryClassName;
    private final String[] extensions;

    private ImagePyramidFormatKind(String factoryClassName, String ... extensions) {
        this.factoryClassName = factoryClassName;
        this.extensions = Objects.requireNonNull(extensions);
    }

    public boolean isAutoDetection() {
        return this == AUTO_DETECT_BY_EXTENSION;
    }

    public boolean hasFactory() {
        return this.factoryClassName != null;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public String[] getExtensions() {
        return (String[])this.extensions.clone();
    }

    public static ImagePyramidFormatKind ofExtension(String extension) {
        for (ImagePyramidFormatKind format : ImagePyramidFormatKind.values()) {
            if (format.extensions == null) continue;
            for (String e : format.extensions) {
                if (!e.equalsIgnoreCase(extension)) continue;
                return format;
            }
        }
        return JAVA_IMAGEIO;
    }

    private static String factory(String[] propertyNames, Class<?> defaultFactory) {
        Objects.requireNonNull(defaultFactory, "Null defaultFactory");
        for (int i = propertyNames.length - 1; i >= 0; --i) {
            String result = Arrays.SystemSettings.getStringProperty((String)propertyNames[i], null);
            if (result == null) continue;
            return result;
        }
        return defaultFactory.getName();
    }
}

