/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.pyramids.io;

import java.util.Objects;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

class SimpleFormula {
    private final ScriptEngine context;
    private final String formula;
    private final Long longValue;
    private final CompiledScript compiledFormula;

    public SimpleFormula(ScriptEngine context, String formula) {
        this.context = Objects.requireNonNull(context);
        this.formula = Objects.requireNonNull(formula);
        Long longValue = null;
        try {
            longValue = Long.parseLong(formula);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.longValue = longValue;
        try {
            this.compiledFormula = longValue == null && context instanceof Compilable ? ((Compilable)((Object)context)).compile(formula) : null;
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException("Cannot evaluate JavaScript formula \"" + formula + "\"", e);
        }
    }

    public void putVariable(String variableName, Object value) {
        this.context.put(variableName, value);
    }

    public String toString() {
        return "formula: " + this.formula;
    }

    String formula() {
        return this.formula;
    }

    double evalDouble() {
        if (this.longValue != null) {
            return this.longValue.longValue();
        }
        Object eval = this.evalObject();
        if (eval == null) {
            return 0.0;
        }
        return Double.parseDouble(eval.toString());
    }

    private Object evalObject() {
        try {
            return this.compiledFormula == null ? this.context.eval(this.formula) : this.compiledFormula.eval();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException("Cannot evaluate JavaScript formula \"" + this.formula + "\"", e);
        }
    }
}

