/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.api;

import java.awt.Color;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatablePArray;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.maps.pyramids.io.api.PlanePyramidTools;
import net.algart.maps.pyramids.io.api.sources.RotatingPlanePyramidSource;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.Range;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;

public abstract class AbstractPlanePyramidSource
implements PlanePyramidSource {
    private static final int MAX_NON_TILED_READING_DIM = Math.max(16, Arrays.SystemSettings.getIntProperty((String)"net.algart.maps.pyramids.io.maxNonTiledReadingDim", (int)4096));
    private static final int READING_TILE_DIM = (int)Math.min(16384L, Arrays.SystemSettings.getLongProperty((String)"net.algart.maps.pyramids.io.readingTile", (long)(2L * DEFAULT_TILE_DIM)));
    private static final long TILE_CACHING_MEMORY = Math.max(16L, Arrays.SystemSettings.getLongProperty((String)"net.algart.maps.pyramids.io.tileCachingMemory", (long)0x4000000L));
    private static final System.Logger LOG = System.getLogger(AbstractPlanePyramidSource.class.getName());
    private MemoryModel memoryModel = Arrays.SMM;
    private boolean skipCoarseData = false;
    private double skippingFiller = 0.0;
    private TileDirection tileCacheDirection = null;
    private volatile long tileCachingMemory = TILE_CACHING_MEMORY;
    private volatile RotatingPlanePyramidSource.RotationMode labelRotation = RotatingPlanePyramidSource.RotationMode.NONE;
    private volatile Color labelRotationBackground = Color.GRAY;
    private final AtomicReference<TileCache> tileCacheContainer = new AtomicReference();
    private final SpeedInfo speedInfo = new SpeedInfo();

    protected AbstractPlanePyramidSource() {
    }

    public final MemoryModel getMemoryModel() {
        return this.memoryModel;
    }

    public final void setMemoryModel(MemoryModel memoryModel) {
        this.memoryModel = Objects.requireNonNull(memoryModel, "Null memoryModel");
    }

    public final boolean isSkipCoarseData() {
        return this.skipCoarseData;
    }

    public final void setSkipCoarseData(boolean skipCoarseData) {
        this.skipCoarseData = skipCoarseData;
    }

    public final double getSkippingFiller() {
        return this.skippingFiller;
    }

    public final void setSkippingFiller(double skippingFiller) {
        this.skippingFiller = skippingFiller;
    }

    @Override
    public abstract int numberOfResolutions();

    @Override
    public int compression() {
        return PlanePyramidTools.defaultCompression(this);
    }

    @Override
    public abstract int bandCount();

    @Override
    public boolean isResolutionLevelAvailable(int resolutionLevel) {
        return true;
    }

    @Override
    public boolean[] getResolutionLevelsAvailability() {
        boolean[] result = new boolean[this.numberOfResolutions()];
        for (int k = 0; k < result.length; ++k) {
            result[k] = this.isResolutionLevelAvailable(k);
        }
        return result;
    }

    @Override
    public abstract long[] dimensions(int var1) throws NoSuchElementException;

    @Override
    public abstract long dim(int var1, int var2);

    @Override
    public boolean isElementTypeSupported() {
        return false;
    }

    @Override
    public Class<?> elementType() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("elementType() method is not supported by " + String.valueOf(super.getClass()));
    }

    @Override
    public List<List<List<IPoint>>> zeroLevelActualAreaBoundaries() {
        List<IRectangularArea> rectangles = this.zeroLevelActualRectangles();
        if (rectangles == null) {
            return null;
        }
        ArrayList<List<List<IPoint>>> result = new ArrayList<List<List<IPoint>>>();
        for (IRectangularArea rectangle : rectangles) {
            ArrayList<IPoint> vertices = new ArrayList<IPoint>();
            vertices.add(rectangle.min());
            vertices.add(IPoint.of((long)rectangle.max(0), (long)rectangle.min(1)));
            vertices.add(rectangle.max());
            vertices.add(IPoint.of((long)rectangle.min(0), (long)rectangle.max(1)));
            result.add(Collections.singletonList(vertices));
        }
        return result;
    }

    @Override
    public Matrix<? extends PArray> readSubMatrix(int resolutionLevel, long fromX, long fromY, long toX, long toY) throws NoSuchElementException, NotYetConnectedException {
        int bandCount = this.bandCount();
        long[] dimensions = this.dimensions(resolutionLevel);
        AbstractPlanePyramidSource.checkSubMatrixRanges(dimensions, fromX, fromY, toX, toY, false);
        long totalElements = Arrays.longMul((long[])new long[]{bandCount, toX - fromX, toY - fromY});
        assert (totalElements != Long.MIN_VALUE);
        if (fromX == toX || fromY == toY || !this.isTileCachingEnabled() && Math.max(toX - fromX, toY - fromY) <= (long)MAX_NON_TILED_READING_DIM) {
            return this.readSubMatrixViaTileCache(resolutionLevel, fromX, fromY, toX, toY, null);
        }
        Matrix result = null;
        long readyElements = 0L;
        TileDirection direction = this.isTileCachingEnabled() ? this.getTileCacheDirection() : TileDirection.RIGHT_DOWN;
        long dimX = dimensions[1];
        long dimY = dimensions[2];
        int readingTileDim = this.readingTileDim();
        long y = fromY;
        while (y < toY) {
            IRectangularArea leftTile = direction.findTile(readingTileDim, dimX, dimY, fromX, y);
            long x = fromX;
            while (x < toX) {
                Matrix subMatrix;
                IRectangularArea tile = direction.findTile(readingTileDim, dimX, dimY, x, y);
                long tileFromX = Math.max(tile.min(0), fromX);
                long tileFromY = Math.max(tile.min(1), fromY);
                long tileToX = Math.min(tile.max(0) + 1L, toX);
                long tileToY = Math.min(tile.max(1) + 1L, toY);
                assert (tileFromX <= tileToX);
                assert (tileFromY <= tileToY);
                Matrix<? extends PArray> m = this.readSubMatrixViaTileCache(resolutionLevel, tileFromX, tileFromY, tileToX, tileToY, tile);
                if (fromX == tileFromX && fromY == tileFromY && toX == tileToX && toY == tileToY) {
                    assert (result == null) : "Unexpected non-null result = " + String.valueOf(result) + " for tile " + tileFromX + ".." + tileToX + "x" + tileFromY + ".." + tileToY;
                    LOG.log(System.Logger.Level.TRACE, () -> AbstractPlanePyramidSource.class.getSimpleName() + " quickly returned result: " + String.valueOf(m));
                    return m;
                }
                if (result == null) {
                    Object mm = Arrays.sizeOf((Class)m.elementType(), (long)totalElements) <= Arrays.SystemSettings.maxTempJavaMemory() ? Arrays.SMM : this.memoryModel;
                    result = mm.newMatrix(UpdatablePArray.class, m.elementType(), new long[]{bandCount, toX - fromX, toY - fromY});
                    if (!SimpleMemoryModel.isSimpleArray((Array)result.array())) {
                        result = result.tile(new long[]{bandCount, DEFAULT_TILE_DIM, DEFAULT_TILE_DIM});
                    }
                    LOG.log(System.Logger.Level.TRACE, AbstractPlanePyramidSource.class.getSimpleName() + " created result " + String.valueOf(result));
                }
                if (!m.dimEquals(subMatrix = result.subMatrix(0L, tileFromX - fromX, tileFromY - fromY, (long)bandCount, tileToX - fromX, tileToY - fromY))) {
                    throw new AssertionError((Object)("Internal bug in readSubMatrixViaCache: incorrect dimensions of the result " + m.dim(0) + "x" + m.dim(1) + "x" + m.dim(2) + " instead of " + bandCount + "x" + (tileToX - tileFromX) + "x" + (tileToY - tileFromY)));
                }
                ((UpdatablePArray)subMatrix.array()).copy(m.array());
                readyElements += m.size();
                x = tile.max(0) + 1L;
            }
            y = leftTile.max(1) + 1L;
        }
        return result;
    }

    @Override
    public Matrix<? extends PArray> readFullMatrix(int resolutionLevel) throws NoSuchElementException, NotYetConnectedException, UnsupportedOperationException {
        if (!this.isFullMatrixSupported()) {
            throw new UnsupportedOperationException("readFullMatrix method is not supported");
        }
        long[] dimensions = this.dimensions(resolutionLevel);
        return this.readSubMatrix(resolutionLevel, 0L, 0L, dimensions[1], dimensions[2]);
    }

    @Override
    public boolean isSpecialMatrixSupported(PlanePyramidSource.SpecialImageKind kind) {
        return false;
    }

    @Override
    public Optional<Matrix<? extends PArray>> readSpecialMatrix(PlanePyramidSource.SpecialImageKind kind) throws NotYetConnectedException {
        Objects.requireNonNull(kind, "Null image kind");
        if (kind == PlanePyramidSource.SpecialImageKind.SMALLEST_LAYER) {
            int resolutionLevel = this.numberOfResolutions() - 1;
            long[] dimensions = this.dimensions(resolutionLevel);
            return Optional.of(this.readSubMatrix(resolutionLevel, 0L, 0L, dimensions[1], dimensions[2]));
        }
        return Optional.empty();
    }

    @Override
    public boolean isDataReady() {
        return true;
    }

    @Override
    public void loadResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeResources(PlanePyramidSource.FlushMode flushMode) {
        AtomicReference<TileCache> atomicReference = this.tileCacheContainer;
        synchronized (atomicReference) {
            if (this.tileCacheContainer.get() != null) {
                LOG.log(System.Logger.Level.DEBUG, () -> AbstractPlanePyramidSource.class.getSimpleName() + " is freeing tile cache");
                this.tileCacheContainer.set(null);
            }
        }
    }

    public void fillBySkippingFiller(Matrix<? extends UpdatablePArray> matrix, boolean fillWhenZero) {
        if (this.skipCoarseData && (fillWhenZero || this.skippingFiller != 0.0)) {
            double filler = this.skippingFiller * ((UpdatablePArray)matrix.array()).maxPossibleValue(1.0);
            ((UpdatablePArray)matrix.array()).fill(filler);
        }
    }

    public Matrix<? extends PArray> constantMatrixSkippingFiller(Class<?> elementType, long dimX, long dimY) {
        Class arrayType = Arrays.type(PArray.class, elementType);
        double filler = this.skippingFiller * Arrays.maxPossibleValue((Class)arrayType, (double)1.0);
        return Matrices.constantMatrix((double)filler, (Class)arrayType, (long[])new long[]{this.bandCount(), dimX, dimY});
    }

    public final boolean isTileCachingEnabled() {
        return this.tileCacheDirection != null;
    }

    public final TileDirection getTileCacheDirection() {
        if (this.tileCacheDirection == null) {
            throw new IllegalStateException("Tile caching is disabled: cannot read tile cache direction");
        }
        return this.tileCacheDirection;
    }

    public final void enableTileCaching(TileDirection tileDirection) {
        if (tileDirection == null) {
            throw new NullPointerException("Null tileCacheDirection argument");
        }
        this.tileCacheDirection = tileDirection;
    }

    public final void disableTileCaching() {
        this.tileCacheDirection = null;
    }

    public final long getTileCachingMemory() {
        return this.tileCachingMemory;
    }

    public final void setTileCachingMemory(long tileCachingMemory) {
        if (tileCachingMemory < 0L) {
            throw new IllegalArgumentException("Negative tileCachingMemory");
        }
        this.tileCachingMemory = tileCachingMemory;
    }

    public final RotatingPlanePyramidSource.RotationMode getLabelRotation() {
        return this.labelRotation;
    }

    public final void setLabelRotation(RotatingPlanePyramidSource.RotationMode labelRotation) {
        if (labelRotation == null) {
            throw new NullPointerException("Null labelRotation");
        }
        this.labelRotation = labelRotation;
    }

    public final Color getLabelRotationBackground() {
        return this.labelRotationBackground;
    }

    public final void setLabelRotationBackground(Color labelRotationBackground) {
        if (labelRotationBackground == null) {
            throw new NullPointerException("Null labelRotationBackground");
        }
        this.labelRotationBackground = labelRotationBackground;
    }

    public final void checkSubMatrixRanges(int resolutionLevel, long fromX, long fromY, long toX, long toY, boolean require31BitSize) {
        AbstractPlanePyramidSource.checkSubMatrixRanges(this.dimensions(resolutionLevel), fromX, fromY, toX, toY, require31BitSize);
    }

    protected int readingTileDim() {
        return READING_TILE_DIM;
    }

    protected abstract Matrix<? extends PArray> readLittleSubMatrix(int var1, long var2, long var4, long var6, long var8) throws NoSuchElementException, NotYetConnectedException;

    protected final Matrix<? extends PArray> makeWholeSlideFromLabelAndMap(LabelPosition labelPosition) {
        if (labelPosition == null) {
            throw new NullPointerException("Null labelPosition");
        }
        long t1 = System.nanoTime();
        MapOrLabelParallelReader labelReader = new MapOrLabelParallelReader(PlanePyramidSource.SpecialImageKind.LABEL_ONLY_IMAGE);
        MapOrLabelParallelReader mapReader = new MapOrLabelParallelReader(PlanePyramidSource.SpecialImageKind.MAP_IMAGE);
        Thread labelReaderThread = new Thread(labelReader);
        Thread mapReaderThread = new Thread(mapReader);
        labelReaderThread.start();
        mapReaderThread.start();
        try {
            labelReaderThread.join();
            mapReaderThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        long labelDimX = labelReader.data.dim(1);
        long labelDimY = labelReader.data.dim(2);
        long mapDimX = mapReader.data.dim(1);
        long mapDimY = mapReader.data.dim(2);
        long t2 = System.nanoTime();
        long wholeSlideDimX = AbstractPlanePyramidSource.wholeSlideDimX(mapDimX, mapDimY, labelDimX, labelDimY);
        long wholeSlideDimY = mapDimY;
        int bandCount = this.bandCount();
        Matrix result = Arrays.SMM.newByteMatrix(new long[]{bandCount, wholeSlideDimX, wholeSlideDimY});
        long resultDimX = result.dim(1);
        long t3 = System.nanoTime();
        Matrices.copy(null, (Matrix)result.subMatr(0L, labelPosition == LabelPosition.RIGHT_OF_THE_MAP ? 0L : resultDimX - mapDimX, 0L, (long)bandCount, mapDimX, mapDimY), mapReader.data);
        long t4 = System.nanoTime();
        Matrices.resize(null, (Matrices.ResizingMethod)Matrices.ResizingMethod.POLYLINEAR_AVERAGING, (Matrix)result.subMatr(0L, labelPosition == LabelPosition.RIGHT_OF_THE_MAP ? mapDimX : 0L, 0L, (long)bandCount, resultDimX - mapDimX, mapDimY), labelReader.data);
        long t5 = System.nanoTime();
        LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "Combining MAP and LABEL: %.3f ms (%.3f parallel reading [%.3f reading LABEL + %.3f rotating LABEL + %.3f + %.3f correcting LABEL || %.3f reading MAP] + %.3f allocating result + %.3f inserting MAP + %.3f inserting resized LABEL)", (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)labelReader.readingTime * 1.0E-6, (double)labelReader.rotatingTime * 1.0E-6, (double)labelReader.correctingBitDepthTime * 1.0E-6, (double)labelReader.correctingBandCountTime * 1.0E-6, (double)mapReader.readingTime * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6));
        return result;
    }

    protected final Matrix<UpdatablePArray> newResultMatrix(long dimX, long dimY) {
        Matrix result = this.memoryModel.newMatrix(Arrays.SystemSettings.maxTempJavaMemory(), UpdatablePArray.class, this.elementType(), new long[]{this.bandCount(), dimX, dimY});
        if (!SimpleMemoryModel.isSimpleArray((Array)result.array())) {
            result = result.tile(new long[]{result.dim(0), 1024L, 1024L});
        }
        return result;
    }

    protected final Matrix<UpdatablePArray> newFilledResultMatrix(long dimX, long dimY, Color backgroundColor) {
        Matrix<UpdatablePArray> result = this.newResultMatrix(dimX, dimY);
        if (this.isSkipCoarseData()) {
            this.fillBySkippingFiller(result, false);
        } else {
            PlanePyramidTools.fillMatrix(result, backgroundColor);
        }
        return result;
    }

    public static List<IRectangularArea> defaultZeroLevelActualRectangles(PlanePyramidSource source) {
        if (source == null) {
            throw new NullPointerException("Null source argument");
        }
        long[] dimensions = source.dimensions(0);
        if (dimensions[1] == 0L || dimensions[2] == 0L) {
            return null;
        }
        return Collections.singletonList(IRectangularArea.of((IPoint)IPoint.of((long)0L, (long)0L), (IPoint)IPoint.of((long)(dimensions[1] - 1L), (long)dimensions[1])));
    }

    public static void checkSubMatrixRanges(long[] dimensions, long fromX, long fromY, long toX, long toY, boolean require31BitSize) {
        if (Arrays.longMul((long[])dimensions) == Long.MIN_VALUE) {
            throw new TooLargeArrayException("Product of all dimensions >Long.MAX_VALUE");
        }
        long dimX = dimensions[1];
        long dimY = dimensions[2];
        long bandCount = dimensions[0];
        if (fromX < 0L || fromY < 0L || fromX > toX || fromY > toY || toX > dimX || toY > dimY) {
            throw new IndexOutOfBoundsException("Illegal fromX..toX=" + fromX + ".." + toX + " or fromY..toY=" + fromY + ".." + toY + ": must be in ranges 0.." + dimX + ", 0.." + dimY + ", fromX<=toX, fromY<=toY");
        }
        if (require31BitSize && (toX - fromX > Integer.MAX_VALUE || toY - fromY > Integer.MAX_VALUE || (toX - fromX) * (toY - fromY) >= Integer.MAX_VALUE / bandCount)) {
            throw new IllegalArgumentException("Too large rectangle " + (toX - fromX) + "x" + (toY - fromY));
        }
    }

    public static long wholeSlideDimX(long mapDimX, long mapDimY, long labelDimX, long labelDimY) {
        return mapDimX + Math.round((double)labelDimX * (double)mapDimY / (double)labelDimY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Matrix<? extends PArray> readSubMatrixViaTileCache(int resolutionLevel, long fromX, long fromY, long toX, long toY, IRectangularArea containingTile) throws NoSuchElementException, NotYetConnectedException {
        Matrix<? extends PArray> tileData;
        if (fromX == toX || fromY == toY || !this.isTileCachingEnabled()) {
            return this.callAndCheckReadLittleSubMatrix(resolutionLevel, fromX, fromY, toX, toY);
        }
        if (containingTile == null) {
            throw new AssertionError((Object)"Internal bug in readSubMatrix implementation: tile cache is enabled, by the containing tile is null (not calculated?)");
        }
        if (containingTile.min(0) > fromX || toX > containingTile.max(0) + 1L || containingTile.min(1) > fromY || toY > containingTile.max(1) + 1L || fromX >= toX || fromY >= toY) {
            throw new AssertionError((Object)("Internal bug in readSubMatrix implementation: the containing tile " + String.valueOf(containingTile) + " does not contain the required area " + fromX + ".." + (toX - 1L) + " x " + fromY + ".." + (toY - 1L) + " or this area is negative"));
        }
        AtomicReference<TileCache> atomicReference = this.tileCacheContainer;
        synchronized (atomicReference) {
            if (this.tileCacheContainer.get() == null) {
                this.tileCacheContainer.set(new TileCache(this.readingTileDim(), this.tileCachingMemory));
            }
            if ((tileData = this.tileCacheContainer.get().getTile(resolutionLevel, containingTile)) == null) {
                tileData = this.callAndCheckReadLittleSubMatrix(resolutionLevel, containingTile.min(0), containingTile.min(1), containingTile.max(0) + 1L, containingTile.max(1) + 1L);
                if (!SimpleMemoryModel.isSimpleArray((Array)tileData.array()) && !Arrays.isNCopies((Array)tileData.array())) {
                    tileData = tileData.matrix((Array)((PArray)tileData.array()).updatableClone((MemoryModel)Arrays.SMM));
                }
                this.tileCacheContainer.get().putTile(resolutionLevel, containingTile, tileData);
            }
        }
        return tileData.subMatrix(0L, fromX - containingTile.min(0), fromY - containingTile.min(1), tileData.dim(0), toX - containingTile.min(0), toY - containingTile.min(1));
    }

    private Matrix<? extends PArray> callAndCheckReadLittleSubMatrix(int resolutionLevel, long fromX, long fromY, long toX, long toY) throws NoSuchElementException, NotYetConnectedException {
        long t1 = System.nanoTime();
        Matrix<? extends PArray> m = this.readLittleSubMatrix(resolutionLevel, fromX, fromY, toX, toY);
        long t2 = System.nanoTime();
        if (m.dim(0) != (long)this.bandCount() || m.dim(1) != toX - fromX || m.dim(2) != toY - fromY) {
            throw new AssertionError((Object)("Illegal implementation of readLittleSubMatrix: incorrect dimensions of the result " + m.dim(0) + "x" + m.dim(1) + "x" + m.dim(2) + " instead of " + this.bandCount() + "x" + (toX - fromX) + "x" + (toY - fromY)));
        }
        String averageSpeed = this.speedInfo.update(Matrices.sizeOf(m), t2 - t1);
        LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "%s has read (level %d): %d..%d x %d..%d (%d x %d) in %.5f ms, %.3f MB/sec, average %s (reader: %s)", AbstractPlanePyramidSource.class.getSimpleName(), resolutionLevel, fromX, toX, fromY, toY, toX - fromX, toY - fromY, (double)(t2 - t1) * 1.0E-6, (double)Matrices.sizeOf((Matrix)m) / 1048576.0 / ((double)(t2 - t1) * 1.0E-9), averageSpeed, super.getClass().getSimpleName()));
        return m;
    }

    private Matrix<? extends PArray> rotateLabelImage(Matrix<? extends PArray> label) {
        if (this.labelRotation == RotatingPlanePyramidSource.RotationMode.NONE) {
            return label;
        }
        Matrix<? extends PArray> rotated = this.labelRotation.asRotated(label);
        long newWidth = rotated.dim(1);
        long newHeight = rotated.dim(2);
        if (newWidth > label.dim(1)) {
            newHeight = (long)((double)newHeight * ((double)label.dim(1) / (double)newWidth));
            newWidth = label.dim(1);
        }
        if (newHeight > label.dim(2)) {
            newWidth = (long)((double)newWidth * ((double)label.dim(2) / (double)newHeight));
            newHeight = label.dim(2);
        }
        assert (newWidth <= label.dim(1));
        assert (newHeight <= label.dim(2));
        Matrix result = Arrays.SMM.newMatrix(UpdatablePArray.class, label);
        PlanePyramidTools.fillMatrix((Matrix<? extends UpdatablePArray>)result, this.labelRotationBackground);
        Matrix centralArea = result.subMatr(0L, (result.dim(1) - newWidth) / 2L, (result.dim(2) - newHeight) / 2L, result.dim(0), newWidth, newHeight);
        Matrices.resize(null, (Matrices.ResizingMethod)Matrices.ResizingMethod.POLYLINEAR_AVERAGING, (Matrix)centralArea, rotated);
        return result;
    }

    public static enum TileDirection {
        RIGHT_DOWN{

            @Override
            IRectangularArea findTile(long tileDim, long dimX, long dimY, long x, long y) {
                assert (dimX > 0L && dimY > 0L);
                assert (tileDim > 0L);
                assert (x >= 0L && y >= 0L && x < dimX && y < dimY);
                long minX = x - x % tileDim;
                long minY = y - y % tileDim;
                long maxX = Math.min(minX + tileDim, dimX) - 1L;
                long maxY = Math.min(minY + tileDim, dimY) - 1L;
                return IRectangularArea.of((IPoint)IPoint.of((long)minX, (long)minY), (IPoint)IPoint.of((long)maxX, (long)maxY));
            }
        }
        ,
        LEFT_DOWN{

            @Override
            IRectangularArea findTile(long tileDim, long dimX, long dimY, long x, long y) {
                assert (dimX > 0L && dimY > 0L);
                assert (tileDim > 0L);
                assert (x >= 0L && y >= 0L && x < dimX && y < dimY);
                x = dimX - 1L - x;
                long minX = x - x % tileDim;
                long minY = y - y % tileDim;
                long maxX = Math.min(minX + tileDim, dimX) - 1L;
                long maxY = Math.min(minY + tileDim, dimY) - 1L;
                return IRectangularArea.of((IPoint)IPoint.of((long)(dimX - 1L - maxX), (long)minY), (IPoint)IPoint.of((long)(dimX - 1L - minX), (long)maxY));
            }
        }
        ,
        RIGHT_UP{

            @Override
            IRectangularArea findTile(long tileDim, long dimX, long dimY, long x, long y) {
                assert (dimX > 0L && dimY > 0L);
                assert (tileDim > 0L);
                assert (x >= 0L && y >= 0L && x < dimX && y < dimY);
                y = dimY - 1L - y;
                long minX = x - x % tileDim;
                long minY = y - y % tileDim;
                long maxX = Math.min(minX + tileDim, dimX) - 1L;
                long maxY = Math.min(minY + tileDim, dimY) - 1L;
                return IRectangularArea.of((IPoint)IPoint.of((long)minX, (long)(dimY - 1L - maxY)), (IPoint)IPoint.of((long)maxX, (long)(dimY - 1L - minY)));
            }
        }
        ,
        LEFT_UP{

            @Override
            IRectangularArea findTile(long tileDim, long dimX, long dimY, long x, long y) {
                assert (dimX > 0L && dimY > 0L);
                assert (tileDim > 0L);
                assert (x >= 0L && y >= 0L && x < dimX && y < dimY);
                x = dimX - 1L - x;
                y = dimY - 1L - y;
                long minX = x - x % tileDim;
                long minY = y - y % tileDim;
                long maxX = Math.min(minX + tileDim, dimX) - 1L;
                long maxY = Math.min(minY + tileDim, dimY) - 1L;
                return IRectangularArea.of((IPoint)IPoint.of((long)(dimX - 1L - maxX), (long)(dimY - 1L - maxY)), (IPoint)IPoint.of((long)(dimX - 1L - minX), (long)(dimY - 1L - minY)));
            }
        };


        abstract IRectangularArea findTile(long var1, long var3, long var5, long var7, long var9);
    }

    private static class SpeedInfo {
        double totalMemory = 0.0;
        double elapsedTime = 0.0;

        private SpeedInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String update(long memory, long time) {
            String result;
            SpeedInfo speedInfo = this;
            synchronized (speedInfo) {
                this.totalMemory += (double)memory;
                this.elapsedTime += (double)time;
                long t = System.currentTimeMillis();
                result = String.format(Locale.US, "%.1f MB / %.3f sec = %.3f MB/sec", this.totalMemory / 1048576.0, this.elapsedTime * 1.0E-9, this.totalMemory / 1048576.0 / (this.elapsedTime * 1.0E-9));
            }
            return result;
        }
    }

    private class MapOrLabelParallelReader
    implements Runnable {
        final PlanePyramidSource.SpecialImageKind kind;
        Matrix<? extends PArray> data = null;
        long readingTime = 0L;
        long rotatingTime = 0L;
        long correctingBandCountTime = 0L;
        long correctingBitDepthTime = 0L;

        private MapOrLabelParallelReader(PlanePyramidSource.SpecialImageKind kind) {
            this.kind = kind;
        }

        @Override
        public void run() {
            long t1 = System.nanoTime();
            this.data = PlanePyramidTools.readSpecialOrSmallestMatrix(AbstractPlanePyramidSource.this, this.kind);
            long t2 = System.nanoTime();
            if (this.data.elementType() != Byte.TYPE) {
                Matrix newData = Arrays.SMM.newByteMatrix(this.data.dimensions());
                Range srcRange = Range.of((double)0.0, (double)((PArray)this.data.array()).maxPossibleValue(1.0));
                Range destRange = Range.of((double)0.0, (double)((UpdatablePArray)newData.array()).maxPossibleValue(1.0));
                Matrices.applyFunc(null, (Func)LinearFunc.getInstance((Range)destRange, (Range)srcRange), (Matrix)newData, this.data);
                this.data = newData;
            }
            long t3 = System.nanoTime();
            if (this.kind == PlanePyramidSource.SpecialImageKind.LABEL_ONLY_IMAGE) {
                this.data = AbstractPlanePyramidSource.this.rotateLabelImage(this.data);
            }
            long t4 = System.nanoTime();
            int requiredBandCount = AbstractPlanePyramidSource.this.bandCount();
            if (this.data.dim(0) != (long)requiredBandCount) {
                Matrix newData = Arrays.SMM.newMatrix(UpdatablePArray.class, this.data.elementType(), new long[]{requiredBandCount, this.data.dim(1), this.data.dim(2)});
                Matrices.resize(null, (Matrices.ResizingMethod)Matrices.ResizingMethod.SIMPLE, (Matrix)newData, this.data);
                this.data = newData;
            }
            long t5 = System.nanoTime();
            this.readingTime += t2 - t1;
            this.correctingBitDepthTime += t3 - t2;
            this.rotatingTime += t4 - t3;
            this.correctingBandCountTime += t5 - t4;
        }
    }

    public static enum LabelPosition {
        LEFT_OF_THE_MAP,
        RIGHT_OF_THE_MAP;

    }

    private static class TileCache {
        final int tileDim;
        final long tileCachingMemory;
        final TileCacheHashMap tileCacheHashMap;

        private TileCache(int tileDim, long tileCachingMemory) {
            this.tileDim = tileDim;
            this.tileCachingMemory = tileCachingMemory;
            this.tileCacheHashMap = new TileCacheHashMap();
            LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, AbstractPlanePyramidSource.class.getSimpleName() + " is creating tile cache for tiles %dx%d, memory limit %.2f MB", tileDim, tileDim, (double)tileCachingMemory / 1048576.0));
        }

        Matrix<? extends PArray> getTile(int resolutionLevel, IRectangularArea tile) {
            Matrix result = (Matrix)this.tileCacheHashMap.get(new TileCacheIndex(resolutionLevel, tile));
            LOG.log(System.Logger.Level.DEBUG, () -> String.format("  " + AbstractPlanePyramidSource.class.getSimpleName() + " has " + (result != null ? "loaded data from the cache" : "NOT FOUND data in the cache") + " (level %d): %s", resolutionLevel, tile));
            return result;
        }

        void putTile(int resolutionLevel, IRectangularArea tile, Matrix<? extends PArray> matrix) {
            Matrix<? extends PArray> prev = this.tileCacheHashMap.put(new TileCacheIndex(resolutionLevel, tile), matrix);
            if (prev == null) {
                LOG.log(System.Logger.Level.TRACE, () -> String.format("  " + AbstractPlanePyramidSource.class.getSimpleName() + " has stored data in the cache (level %d): %s", resolutionLevel, tile));
            }
        }

        private class TileCacheHashMap
        extends LinkedHashMap<TileCacheIndex, Matrix<? extends PArray>> {
            private TileCacheHashMap() {
                super(16, 0.75f, true);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<TileCacheIndex, Matrix<? extends PArray>> eldest) {
                boolean result;
                boolean bl = result = this.usedMemory() > (double)TileCache.this.tileCachingMemory;
                if (result) {
                    LOG.log(System.Logger.Level.DEBUG, () -> AbstractPlanePyramidSource.class.getSimpleName() + " will remove the eldest entry from the cache");
                }
                return result;
            }

            private double usedMemory() {
                double sum = 0.0;
                for (Matrix m : this.values()) {
                    sum += (double)Matrices.sizeOf((Matrix)m);
                }
                return sum;
            }
        }
    }

    private static final class TileCacheIndex {
        final int resolutionLevel;
        final IRectangularArea tile;

        private TileCacheIndex(int resolutionLevel, IRectangularArea tile) {
            assert (tile != null);
            this.resolutionLevel = resolutionLevel;
            this.tile = tile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TileCacheIndex)) {
                return false;
            }
            TileCacheIndex that = (TileCacheIndex)o;
            return this.resolutionLevel == that.resolutionLevel && this.tile.equals((Object)that.tile);
        }

        public int hashCode() {
            int result = this.resolutionLevel;
            result = 31 * result + this.tile.hashCode();
            return result;
        }
    }

    protected final class WholeSlideScaler {
        private final int suitableWholeSlideLevel;
        private final Matrix<? extends PArray> suitableWholeSlide;
        private final double scaleX;
        private final double scaleY;
        Matrix<? extends UpdatablePArray> resultBackground = null;
        volatile long fromXAtSlide;
        volatile long fromYAtSlide;
        volatile long toXAtSlide;
        volatile long toYAtSlide;
        long scalingTime = 0L;

        public WholeSlideScaler(List<Matrix<? extends PArray>> wholeSlidePyramid, int resolutionLevel) {
            Matrix<? extends PArray> m;
            if (wholeSlidePyramid == null) {
                throw new NullPointerException("Null wholeSlidePyramid");
            }
            long[] dim = AbstractPlanePyramidSource.this.dimensions(resolutionLevel);
            long levelDimX = dim[1];
            long levelDimY = dim[2];
            int suitableLevel = 0;
            int k = 1;
            while (k < wholeSlidePyramid.size() && (m = wholeSlidePyramid.get(k)).dim(1) >= levelDimX && m.dim(2) >= levelDimY) {
                suitableLevel = k++;
            }
            this.suitableWholeSlideLevel = suitableLevel;
            Matrix matrix = wholeSlidePyramid.get(suitableLevel);
            Class<?> requiredElementType = AbstractPlanePyramidSource.this.elementType();
            if (requiredElementType != matrix.elementType()) {
                Class destType = Arrays.type(PArray.class, requiredElementType);
                Range srcRange = Range.of((double)0.0, (double)((PArray)matrix.array()).maxPossibleValue(1.0));
                Range destRange = Range.of((double)0.0, (double)Arrays.maxPossibleValue((Class)destType, (double)1.0));
                matrix = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((Range)destRange, (Range)srcRange), (Class)destType, matrix);
            }
            this.suitableWholeSlide = matrix;
            this.scaleX = (double)this.suitableWholeSlide.dim(1) / (double)levelDimX;
            this.scaleY = (double)this.suitableWholeSlide.dim(2) / (double)levelDimY;
        }

        public double scaleX() {
            return this.scaleX;
        }

        public double scaleY() {
            return this.scaleY;
        }

        public Matrix<? extends UpdatablePArray> scaleWholeSlide(IRectangularArea area) {
            return this.scaleWholeSlide(area.min(0), area.min(1), area.max(0) + 1L, area.max(1) + 1L);
        }

        public Matrix<? extends UpdatablePArray> scaleWholeSlide(long fromX, long fromY, long toX, long toY) {
            long t1 = System.nanoTime();
            this.resultBackground = AbstractPlanePyramidSource.this.newResultMatrix(toX - fromX, toY - fromY);
            if (fromX == toX || fromY == toY) {
                return this.resultBackground;
            }
            this.fromXAtSlide = Math.round((double)fromX * this.scaleX);
            this.fromYAtSlide = Math.round((double)fromY * this.scaleY);
            this.toXAtSlide = Math.round((double)toX * this.scaleX);
            this.toYAtSlide = Math.round((double)toY * this.scaleY);
            Matrix subMatrixAtWholeSlide = this.suitableWholeSlide.subMatrix(0L, this.fromXAtSlide, this.fromYAtSlide, (long)AbstractPlanePyramidSource.this.bandCount(), this.toXAtSlide, this.toYAtSlide, Matrix.ContinuationMode.ZERO_CONSTANT);
            if (AbstractPlanePyramidSource.this.isSkipCoarseData()) {
                AbstractPlanePyramidSource.this.fillBySkippingFiller(this.resultBackground, false);
            } else {
                Matrices.resize(null, (Matrices.ResizingMethod)Matrices.ResizingMethod.SIMPLE, this.resultBackground, (Matrix)subMatrixAtWholeSlide);
            }
            long t2 = System.nanoTime();
            LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "Scaling background %s %d..%dx%d..%d (%d x %d), at whole-slide pyramid: level %d, %d..%dx%d..%d (%d x %d): %.3f ms, %.3f MB/sec)", AbstractPlanePyramidSource.this.isSkipCoarseData() ? "(filling)" : "(scaling whole-slide image)", fromX, toX, fromY, toY, toX - fromX, toY - fromY, this.suitableWholeSlideLevel, this.fromXAtSlide, this.toXAtSlide, this.fromYAtSlide, this.toYAtSlide, this.toXAtSlide - this.fromXAtSlide, this.toYAtSlide - this.fromYAtSlide, (double)(t2 - t1) * 1.0E-6, (double)Matrices.sizeOf(this.resultBackground) / 1048576.0 / ((double)(t2 - t1) * 1.0E-9)));
            this.scalingTime += t2 - t1;
            return this.resultBackground;
        }

        public Matrix<? extends UpdatablePArray> resultBackground() {
            return this.resultBackground;
        }

        public boolean done() {
            return this.resultBackground != null;
        }

        public long scalingTime() {
            return this.scalingTime;
        }
    }
}

