/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.api;

import java.nio.channels.NotYetConnectedException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.functions.Func;

public interface PlanePyramidSource {
    public static final int DIM_BAND = 0;
    public static final int DIM_WIDTH = 1;
    public static final int DIM_HEIGHT = 2;
    public static final int DEFAULT_COMPRESSION = Math.max(2, Arrays.SystemSettings.getIntProperty((String)"net.algart.maps.pyramids.io.defaultPyramidCompression", (int)4));
    public static final long DEFAULT_TILE_DIM = Math.max(16L, Arrays.SystemSettings.getLongProperty((String)"net.algart.maps.pyramids.io.tile", (long)1024L));
    public static final long DEFAULT_MINIMAL_PYRAMID_SIZE = 8L;

    public int numberOfResolutions();

    public int compression();

    public int bandCount();

    public boolean[] getResolutionLevelsAvailability();

    public boolean isResolutionLevelAvailable(int var1);

    public long[] dimensions(int var1) throws NoSuchElementException;

    default public long dim(int resolutionLevel, int index) {
        return this.dimensions(resolutionLevel)[index];
    }

    default public long width(int resolutionLevel) {
        return this.dim(resolutionLevel, 1);
    }

    default public long height(int resolutionLevel) {
        return this.dim(resolutionLevel, 2);
    }

    public boolean isElementTypeSupported();

    public Class<?> elementType() throws UnsupportedOperationException;

    default public OptionalDouble pixelSizeInMicrons() {
        return OptionalDouble.empty();
    }

    default public OptionalDouble magnification() {
        return OptionalDouble.empty();
    }

    default public List<IRectangularArea> zeroLevelActualRectangles() {
        return null;
    }

    default public List<List<List<IPoint>>> zeroLevelActualAreaBoundaries() {
        return null;
    }

    public Matrix<? extends PArray> readSubMatrix(int var1, long var2, long var4, long var6, long var8) throws NoSuchElementException, NotYetConnectedException;

    default public boolean isFullMatrixSupported() {
        return true;
    }

    public Matrix<? extends PArray> readFullMatrix(int var1) throws NoSuchElementException, NotYetConnectedException, UnsupportedOperationException;

    public boolean isSpecialMatrixSupported(SpecialImageKind var1);

    public Optional<Matrix<? extends PArray>> readSpecialMatrix(SpecialImageKind var1) throws NotYetConnectedException;

    public boolean isDataReady();

    default public Optional<String> metadata() {
        return Optional.empty();
    }

    public void loadResources();

    public void freeResources(FlushMode var1);

    public static enum AveragingMode {
        DEFAULT,
        AVERAGING,
        SIMPLE,
        AND,
        OR,
        MIN,
        MAX;

        private static final Matrices.ResizingMethod.Averaging AVERAGING_MIN;
        private static final Matrices.ResizingMethod.Averaging AVERAGING_MAX;

        public Matrices.ResizingMethod averagingMethod(Matrix<?> matrix) {
            switch (this.ordinal()) {
                case 3: {
                    if (matrix.elementType() != Boolean.TYPE) break;
                }
                case 5: {
                    return AVERAGING_MIN;
                }
                case 4: {
                    if (matrix.elementType() != Boolean.TYPE) break;
                }
                case 6: {
                    return AVERAGING_MAX;
                }
                case 0: 
                case 1: {
                    if (matrix.elementType() != Boolean.TYPE) break;
                    return Matrices.ResizingMethod.SIMPLE;
                }
                case 2: {
                    return Matrices.ResizingMethod.SIMPLE;
                }
            }
            return Matrices.ResizingMethod.POLYLINEAR_AVERAGING;
        }

        static {
            AVERAGING_MIN = new Matrices.ResizingMethod.Averaging(Matrices.InterpolationMethod.STEP_FUNCTION){

                protected Func getAveragingFunc(long[] apertureDim) {
                    return Func.MIN;
                }
            };
            AVERAGING_MAX = new Matrices.ResizingMethod.Averaging(Matrices.InterpolationMethod.STEP_FUNCTION){

                protected Func getAveragingFunc(long[] apertureDim) {
                    return Func.MAX;
                }
            };
        }
    }

    public static enum FlushMode {
        QUICK_WITH_POSSIBLE_LOSS_OF_DATA{

            @Override
            public boolean dataMustBeFlushed() {
                return false;
            }

            @Override
            public boolean forcePhysicalWriting() {
                return false;
            }

            @Override
            public boolean flushLongTermResources() {
                return false;
            }
        }
        ,
        STANDARD{

            @Override
            public boolean dataMustBeFlushed() {
                return true;
            }

            @Override
            public boolean forcePhysicalWriting() {
                return false;
            }

            @Override
            public boolean flushLongTermResources() {
                return false;
            }
        }
        ,
        FLUSH_LONG_TERM_RESOURCES{

            @Override
            public boolean dataMustBeFlushed() {
                return true;
            }

            @Override
            public boolean forcePhysicalWriting() {
                return true;
            }

            @Override
            public boolean flushLongTermResources() {
                return true;
            }
        };


        public abstract boolean dataMustBeFlushed();

        public abstract boolean forcePhysicalWriting();

        public abstract boolean flushLongTermResources();
    }

    public static enum SpecialImageKind {
        NONE,
        WHOLE_SLIDE,
        MAP_IMAGE,
        LABEL_ONLY_IMAGE,
        THUMBNAIL_IMAGE,
        SMALLEST_LAYER,
        CUSTOM_KIND_1,
        CUSTOM_KIND_2,
        CUSTOM_KIND_3,
        CUSTOM_KIND_4,
        CUSTOM_KIND_5,
        INVALID;

    }
}

