/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.api;

import java.awt.Color;
import java.io.IOException;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.math.Range;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.ConstantFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;

public class PlanePyramidTools {
    public static final int MIN_PYRAMID_LEVEL_SIDE = 256;
    private static final System.Logger LOG = System.getLogger(PlanePyramidTools.class.getName());

    private PlanePyramidTools() {
    }

    public static Matrix<? extends PArray> readSpecialOrSmallestMatrix(PlanePyramidSource source, PlanePyramidSource.SpecialImageKind kind) throws NotYetConnectedException {
        Objects.requireNonNull(source, "Null source");
        Objects.requireNonNull(kind, "Null kind");
        Optional<Matrix<? extends PArray>> matrix = source.readSpecialMatrix(kind);
        if (matrix.isEmpty() && (matrix = source.readSpecialMatrix(PlanePyramidSource.SpecialImageKind.SMALLEST_LAYER)).isEmpty()) {
            throw new AssertionError((Object)("Invalid implementation of readSpecialMatrix in " + String.valueOf(source.getClass()) + ": empty result for " + String.valueOf((Object)PlanePyramidSource.SpecialImageKind.SMALLEST_LAYER)));
        }
        return matrix.get();
    }

    public static boolean isDimensionsRelationCorrect(long[] dimOfSomeLevel, long[] dimOfNextLevel, int compression) {
        if (dimOfSomeLevel.length != 3 || dimOfNextLevel.length != 3) {
            throw new IllegalArgumentException("Illegal number of dimensions: must be 3");
        }
        if (compression <= 1) {
            throw new IllegalArgumentException("Invalid compression " + compression + " (must be 2 or greater)");
        }
        long predictedNextWidth = dimOfSomeLevel[1] / (long)compression;
        long predictedNextHeight = dimOfSomeLevel[2] / (long)compression;
        return !(dimOfNextLevel[0] != dimOfSomeLevel[0] || dimOfNextLevel[1] != predictedNextWidth && dimOfNextLevel[1] != predictedNextWidth + 1L || dimOfNextLevel[2] != predictedNextHeight && dimOfNextLevel[2] != predictedNextHeight + 1L);
    }

    public static int findCompression(long[] dimensionsOfSomeLevel, long[] dimensionsOnNextLevel) {
        for (int probeCompression = 2; probeCompression <= 32; ++probeCompression) {
            if (!PlanePyramidTools.isDimensionsRelationCorrect(dimensionsOfSomeLevel, dimensionsOnNextLevel, probeCompression)) continue;
            return probeCompression;
        }
        return 0;
    }

    public static int numberOfResolutions(long dimX, long dimY, int compression, long minimalPyramidSize) {
        if (dimX <= 0L || dimY <= 0L) {
            throw new IllegalArgumentException("Illegal area dimensions " + dimX + "x" + dimY + " (must be positive)");
        }
        if (compression <= 1) {
            throw new IllegalArgumentException("Invalid compression " + compression + " (must be 2 or greater)");
        }
        if (minimalPyramidSize <= 0L) {
            throw new IllegalArgumentException("Minimal pyramid size must be positive");
        }
        int count = 0;
        do {
            ++count;
        } while ((dimX /= (long)compression) >= minimalPyramidSize || (dimY /= (long)compression) >= minimalPyramidSize);
        return count;
    }

    public static boolean areVeryLittleSizes(long dimX, long dimY) {
        return dimX < 1L || dimY < 1L || dimX < 256L && dimY < 256L;
    }

    public static IOException rmiSafeWrapper(Exception nonStandardException) {
        IOException exception = new IOException(nonStandardException.toString());
        exception.setStackTrace(nonStandardException.getStackTrace());
        return exception;
    }

    public static int defaultCompression(PlanePyramidSource source) {
        if (source.numberOfResolutions() <= 1 || !source.isResolutionLevelAvailable(0) || !source.isResolutionLevelAvailable(1)) {
            return PlanePyramidSource.DEFAULT_COMPRESSION;
        }
        int compression = PlanePyramidTools.findCompression(source.dimensions(0), source.dimensions(1));
        return compression == 0 ? PlanePyramidSource.DEFAULT_COMPRESSION : compression;
    }

    public static List<Matrix<? extends PArray>> equalizePrecisionToTheBest(List<? extends Matrix<? extends PArray>> matrices) {
        if (matrices == null) {
            throw new NullPointerException("Null matrices");
        }
        ArrayList<? extends Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>(matrices);
        Class bestElementType = null;
        for (Matrix<? extends PArray> matrix : result) {
            if (matrix == null || bestElementType != null && PlanePyramidTools.precision(matrix.elementType()) <= PlanePyramidTools.precision(bestElementType)) continue;
            bestElementType = matrix.elementType();
        }
        if (bestElementType == null) {
            return result;
        }
        int n = result.size();
        for (int k = 0; k < n; ++k) {
            Matrix<? extends PArray> m = result.get(k);
            if (m == null || m.elementType() == bestElementType) continue;
            Class destType = Arrays.type(PArray.class, (Class)bestElementType);
            Range srcRange = Range.of((double)0.0, (double)((PArray)m.array()).maxPossibleValue(1.0));
            Range destRange = Range.of((double)0.0, (double)Arrays.maxPossibleValue((Class)destType, (double)1.0));
            result.set(k, (Matrix<? extends PArray>)Matrices.asFuncMatrix((Func)LinearFunc.getInstance((Range)destRange, (Range)srcRange), (Class)destType, m));
        }
        return result;
    }

    public static Matrix<? extends PArray> asBackground(Class<?> elementType, long dimX, long dimY, double[] backgroundColor) {
        if (backgroundColor == null) {
            throw new NullPointerException("Null background color");
        }
        int bandCount = backgroundColor.length;
        if (bandCount <= 0) {
            throw new IllegalArgumentException("Number of color components must be positive");
        }
        Class arrayType = Arrays.type(PArray.class, elementType);
        double scale = Arrays.maxPossibleValue((Class)arrayType, (double)1.0);
        final double[] filler = new double[bandCount];
        for (int k = 0; k < bandCount; ++k) {
            filler[k] = backgroundColor[k] * scale;
        }
        boolean identical = true;
        for (double v : filler) {
            identical &= v == filler[0];
        }
        AbstractFunc constantFunc = identical ? ConstantFunc.getInstance((double)filler[0]) : new AbstractFunc(){

            public double get(double ... x) {
                return filler[(int)x[0]];
            }

            public double get(double x0, double x1, double x2) {
                return filler[(int)x0];
            }
        };
        return Matrices.asCoordFuncMatrix((Func)constantFunc, (Class)arrayType, (long[])new long[]{bandCount, dimX, dimY});
    }

    public static void fillMatrix(Matrix<? extends UpdatablePArray> m, long fromX, long fromY, long toX, long toY, Color color) {
        PlanePyramidTools.fillMatrix((Matrix<? extends UpdatablePArray>)m.subMatrix(0L, fromX, fromY, m.dim(0), toX, toY), color);
    }

    public static void fillMatrix(Matrix<? extends UpdatablePArray> m, long fromX, long fromY, long toX, long toY, double[] color) {
        PlanePyramidTools.fillMatrix((Matrix<? extends UpdatablePArray>)m.subMatrix(0L, fromX, fromY, m.dim(0), toX, toY), color);
    }

    public static void fillMatrix(Matrix<? extends UpdatablePArray> m, Color color) {
        long bandCount = m.dim(0);
        if (bandCount != 1L && bandCount != 3L && bandCount != 4L) {
            return;
        }
        double[] a = new double[(int)bandCount];
        switch (a.length) {
            case 1: {
                a[0] = (0.3 * (double)color.getRed() + 0.59 * (double)color.getGreen() + 0.11 * (double)color.getBlue()) / 255.0;
                break;
            }
            case 4: {
                a[3] = (double)color.getAlpha() / 255.0;
            }
            case 3: {
                a[0] = (double)color.getRed() / 255.0;
                a[1] = (double)color.getGreen() / 255.0;
                a[2] = (double)color.getBlue() / 255.0;
            }
        }
        PlanePyramidTools.fillMatrix(m, a);
    }

    public static void fillMatrix(Matrix<? extends UpdatablePArray> m, double[] color) {
        long bandCount = m.dim(0);
        UpdatablePArray array = (UpdatablePArray)m.array();
        if (bandCount > 32L) {
            throw new IllegalArgumentException("This method should be not used for true 3D matrices");
        }
        if (bandCount != (long)color.length) {
            if (bandCount == 1L) {
                color = color.length >= 3 ? new double[]{0.3 * color[0] + 0.59 * color[1] + 0.11 * color[2]} : new double[]{color[0]};
            } else {
                double[] newColor = new double[(int)bandCount];
                for (int k = 0; k < newColor.length; ++k) {
                    newColor[k] = k < color.length ? color[k] : color[color.length - 1];
                }
                color = newColor;
            }
        }
        assert (bandCount == (long)color.length);
        PArray pattern = (PArray)PlanePyramidTools.asBackground(m.elementType(), m.dim(1), m.dim(2), color).array();
        assert (pattern.length() % (long)color.length == 0L);
        if (Arrays.isNCopies((Array)pattern)) {
            array.copy((Array)pattern);
        } else {
            int blockLen;
            long n = pattern.length();
            int initialLen = (int)Math.min(n, (long)(blockLen = 1024 * color.length));
            if ((long)initialLen == n) {
                array.copy((Array)pattern);
            } else {
                Object buffer = pattern.newJavaArray(initialLen);
                pattern.getData(0L, buffer, 0, initialLen);
                for (long p = 0L; p < n; p += (long)blockLen) {
                    array.setData(p, buffer, 0, (int)Math.min((long)blockLen, n - p));
                }
            }
        }
    }

    public static List<Matrix<? extends PArray>> buildPyramid(Matrix<? extends PArray> matrix) {
        return PlanePyramidTools.buildPyramid(matrix, 2);
    }

    public static List<Matrix<? extends PArray>> buildPyramid(Matrix<? extends PArray> matrix, int compression) {
        long t1 = System.nanoTime();
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        result.add(matrix);
        long dimX = matrix.dim(1) / (long)compression;
        long dimY = matrix.dim(2) / (long)compression;
        while (!PlanePyramidTools.areVeryLittleSizes(dimX, dimY)) {
            Matrix compressed = Arrays.SMM.newMatrix(UpdatablePArray.class, matrix.elementType(), new long[]{matrix.dim(0), dimX, dimY});
            if (matrix.dim(1) != dimX * (long)compression || matrix.dim(2) != dimY * (long)compression) {
                matrix = matrix.subMatr(0L, 0L, 0L, matrix.dim(0), dimX * (long)compression, dimY * (long)compression);
            }
            Matrices.resize(null, (Matrices.ResizingMethod)Matrices.ResizingMethod.AVERAGING, (Matrix)compressed, matrix);
            matrix = compressed;
            result.add((Matrix<? extends PArray>)matrix);
            dimX /= (long)compression;
            dimY /= (long)compression;
        }
        long t2 = System.nanoTime();
        Matrix m = matrix;
        LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "Building pyramid in memory from %d x %d until %d x %d: %.3f ms", ((Matrix)result.get(0)).dim(1), ((Matrix)result.get(0)).dim(2), m.dim(1), m.dim(2), (double)(t2 - t1) * 1.0E-6));
        return result;
    }

    public static double usedMemory() {
        Runtime runtime = Runtime.getRuntime();
        System.gc();
        return (double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0;
    }

    private static long precision(Class<?> elementType) {
        long bits = Arrays.bitsPerElement(elementType);
        return elementType == Float.TYPE || elementType == Double.TYPE ? bits + 1024L : bits;
    }
}

