/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.api.sources;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.maps.pyramids.io.api.AbstractPlanePyramidSource;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.maps.pyramids.io.api.PlanePyramidTools;

public final class DefaultPlanePyramidSource
extends AbstractPlanePyramidSource
implements PlanePyramidSource {
    private final List<Matrix<? extends PArray>> packedImagePyramid;
    private final Class<?> elementType;
    private final int bandCount;
    volatile boolean continuationEnabled = true;

    public DefaultPlanePyramidSource(List<? extends Matrix<? extends PArray>> packedImagePyramid) {
        Objects.requireNonNull(packedImagePyramid, "Null packedImagePyramid");
        packedImagePyramid = new ArrayList<Matrix<? extends PArray>>(packedImagePyramid);
        if (packedImagePyramid.isEmpty()) {
            throw new IllegalArgumentException("Empty packedImagePyramid");
        }
        int firstNonNullIndex = -1;
        int bandCount = -1;
        int n = packedImagePyramid.size();
        for (int k = 0; k < n; ++k) {
            Matrix<? extends PArray> m = packedImagePyramid.get(k);
            if (m == null) continue;
            if (m.dimCount() != 3) {
                throw new IllegalArgumentException("Illegal number of dimensions (" + m.dimCount() + ") in packedImagePyramid[" + k + "]: all matrices must be 3-dimensional");
            }
            if (m.dim(0) > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Too large bandCount (>Integer.MAX_VALUE)");
            }
            if (firstNonNullIndex == -1) {
                firstNonNullIndex = k;
                bandCount = (int)m.dim(0);
                continue;
            }
            if (m.dim(0) == (long)bandCount) continue;
            throw new IllegalArgumentException("Different lowest dimension packedImagePyramid[" + k + "].dim(0) = " + m.dim(0) + " != packedImagePyramid[" + firstNonNullIndex + "].dim(0) = " + bandCount);
        }
        if (firstNonNullIndex == -1) {
            throw new IllegalArgumentException("All elements in packedImagePyramid are null");
        }
        this.packedImagePyramid = PlanePyramidTools.equalizePrecisionToTheBest(packedImagePyramid);
        this.elementType = this.packedImagePyramid.get(firstNonNullIndex).elementType();
        this.bandCount = bandCount;
    }

    public boolean isContinuationEnabled() {
        return this.continuationEnabled;
    }

    public DefaultPlanePyramidSource setContinuationEnabled(boolean continuationEnabled) {
        this.continuationEnabled = continuationEnabled;
        return this;
    }

    @Override
    public int numberOfResolutions() {
        return this.packedImagePyramid.size();
    }

    @Override
    public int bandCount() {
        return this.bandCount;
    }

    @Override
    public boolean isResolutionLevelAvailable(int resolutionLevel) {
        return this.packedImagePyramid.get(resolutionLevel) != null;
    }

    @Override
    public long[] dimensions(int resolutionLevel) throws NoSuchElementException {
        Matrix<? extends PArray> m = this.packedImagePyramid.get(resolutionLevel);
        if (m == null) {
            throw new NoSuchElementException("Resolution level #" + resolutionLevel + " is absent");
        }
        return m.dimensions();
    }

    @Override
    public long dim(int resolutionLevel, int index) {
        Matrix<? extends PArray> m = this.packedImagePyramid.get(resolutionLevel);
        if (m == null) {
            throw new NoSuchElementException("Resolution level #" + resolutionLevel + " is absent");
        }
        if (index < 0 || index >= m.dimCount()) {
            throw new IndexOutOfBoundsException("Invalid index " + index);
        }
        return m.dim(index);
    }

    @Override
    public boolean isElementTypeSupported() {
        return true;
    }

    @Override
    public Class<?> elementType() {
        return this.elementType;
    }

    @Override
    public boolean isFullMatrixSupported() {
        return true;
    }

    @Override
    public Matrix<? extends PArray> readSubMatrix(int resolutionLevel, long fromX, long fromY, long toX, long toY) throws NoSuchElementException {
        Matrix<? extends PArray> m = this.packedImagePyramid.get(resolutionLevel);
        if (m == null) {
            throw new NoSuchElementException("Resolution level #" + resolutionLevel + " is absent");
        }
        return m.subMatrix(0L, fromX, fromY, (long)this.bandCount(), toX, toY, this.continuationEnabled ? Matrix.ContinuationMode.NAN_CONSTANT : Matrix.ContinuationMode.NONE);
    }

    @Override
    public Matrix<? extends PArray> readFullMatrix(int resolutionLevel) throws NoSuchElementException {
        Matrix<? extends PArray> m = this.packedImagePyramid.get(resolutionLevel);
        if (m == null) {
            throw new NoSuchElementException("Resolution level #" + resolutionLevel + " is absent");
        }
        return m;
    }

    @Override
    public void freeResources(PlanePyramidSource.FlushMode flushMode) {
        super.freeResources(flushMode);
        for (Matrix<? extends PArray> m : this.packedImagePyramid) {
            if (m == null) continue;
            Array a = flushMode.dataMustBeFlushed() ? m.array() : ((PArray)m.array()).subArray(0L, 0L);
            a.freeResources(null, flushMode.forcePhysicalWriting());
        }
    }

    @Override
    protected Matrix<? extends PArray> readLittleSubMatrix(int resolutionLevel, long fromX, long fromY, long toX, long toY) {
        throw new AssertionError((Object)"Not used in this class!");
    }
}

