/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.api.sources;

import java.awt.Color;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.maps.pyramids.io.api.AbstractPlanePyramidSource;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.maps.pyramids.io.api.PlanePyramidTools;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;

public final class ExtendingPlanePyramidSource
extends AbstractPlanePyramidSource
implements PlanePyramidSource {
    private static final System.Logger LOG = System.getLogger(ExtendingPlanePyramidSource.class.getName());
    private final PlanePyramidSource parent;
    private final List<long[]> dimensions;
    private final int compression;
    private final int bandCount;
    private final long extendedDimX;
    private final long extendedDimY;
    private final long positionXInExtendedMatrix;
    private final long positionYInExtendedMatrix;
    private final double[] backgroundColor;
    private int extendingBorderWidth = 0;
    private Color extendingBorderColor = Color.GRAY;

    private ExtendingPlanePyramidSource(PlanePyramidSource parent, long extendedDimX, long extendedDimY, long positionXInExtendedMatrix, long positionYInExtendedMatrix, double[] backgroundColor) {
        Objects.requireNonNull(parent, "Null parent");
        Objects.requireNonNull(backgroundColor, "Null backgroundColor");
        if (extendedDimX <= 0L || extendedDimY <= 0L) {
            throw new IllegalArgumentException("Illegal extended dimensions " + extendedDimX + "x" + extendedDimY + " (must be positive)");
        }
        if (backgroundColor.length == 0) {
            throw new IllegalArgumentException("Empty backgroundColor");
        }
        if (backgroundColor.length != 1 && backgroundColor.length != 3 && backgroundColor.length != 4) {
            throw new IllegalArgumentException("Illegal backgroundColor[" + backgroundColor.length + "]: it must contain 1, 3 or 4 elements");
        }
        this.parent = parent;
        this.bandCount = Math.max(parent.bandCount(), backgroundColor.length);
        this.backgroundColor = new double[this.bandCount];
        for (int k = 0; k < this.bandCount; ++k) {
            this.backgroundColor[k] = backgroundColor[Math.min(k, backgroundColor.length - 1)];
        }
        this.extendedDimX = extendedDimX;
        this.extendedDimY = extendedDimY;
        this.positionXInExtendedMatrix = positionXInExtendedMatrix;
        this.positionYInExtendedMatrix = positionYInExtendedMatrix;
        this.dimensions = new ArrayList<long[]>();
        this.compression = parent.compression();
        long lastDimX = this.extendedDimX;
        long lastDimY = this.extendedDimY;
        this.dimensions.add(new long[]{this.bandCount, lastDimX, lastDimY});
        int n = parent.numberOfResolutions();
        for (int k = 1; k < n; ++k) {
            this.dimensions.add(new long[]{this.bandCount, lastDimX /= (long)this.compression, lastDimY /= (long)this.compression});
        }
        LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "ExtendingPlanePyramidSource created on the base of %s: %dx%d, contains sub-image %dx%d at (%d,%d), %d bands, %d levels, compression in %d times", parent, extendedDimX, extendedDimY, parent.dim(0, 1), parent.dim(0, 2), positionXInExtendedMatrix, positionYInExtendedMatrix, this.bandCount, this.dimensions.size(), this.compression));
    }

    public static ExtendingPlanePyramidSource newInstance(PlanePyramidSource parent, long extendedDimX, long extendedDimY, long positionXInExtendedMatrix, long positionYInExtendedMatrix, double[] backgroundColor) {
        return new ExtendingPlanePyramidSource(parent, extendedDimX, extendedDimY, positionXInExtendedMatrix, positionYInExtendedMatrix, backgroundColor);
    }

    public PlanePyramidSource parent() {
        return this.parent;
    }

    public long getExtendedDimX() {
        return this.extendedDimX;
    }

    public long getExtendedDimY() {
        return this.extendedDimY;
    }

    public long getPositionXInExtendedMatrix() {
        return this.positionXInExtendedMatrix;
    }

    public long getPositionYInExtendedMatrix() {
        return this.positionYInExtendedMatrix;
    }

    public int getExtendingBorderWidth() {
        if (this.extendingBorderWidth < 0) {
            throw new IllegalArgumentException("Negative extendingBorderWidth");
        }
        return this.extendingBorderWidth;
    }

    public void setExtendingBorderWidth(int extendingBorderWidth) {
        this.extendingBorderWidth = extendingBorderWidth;
    }

    public Color getExtendingBorderColor() {
        return this.extendingBorderColor;
    }

    public void setExtendingBorderColor(Color extendingBorderColor) {
        if (extendingBorderColor == null) {
            throw new NullPointerException("Null extendingBorderColor");
        }
        this.extendingBorderColor = extendingBorderColor;
    }

    @Override
    public int numberOfResolutions() {
        return this.dimensions.size();
    }

    @Override
    public int compression() {
        return this.compression;
    }

    @Override
    public int bandCount() {
        return this.bandCount;
    }

    @Override
    public boolean isResolutionLevelAvailable(int resolutionLevel) {
        return this.parent.isResolutionLevelAvailable(resolutionLevel);
    }

    @Override
    public boolean[] getResolutionLevelsAvailability() {
        return this.parent.getResolutionLevelsAvailability();
    }

    @Override
    public long[] dimensions(int resolutionLevel) {
        return (long[])this.dimensions.get(resolutionLevel).clone();
    }

    @Override
    public long dim(int resolutionLevel, int index) {
        return this.dimensions.get(resolutionLevel)[index];
    }

    @Override
    public boolean isElementTypeSupported() {
        return this.parent.isElementTypeSupported();
    }

    @Override
    public Class<?> elementType() throws UnsupportedOperationException {
        return this.parent.elementType();
    }

    @Override
    public OptionalDouble pixelSizeInMicrons() {
        return this.parent.pixelSizeInMicrons();
    }

    @Override
    public OptionalDouble magnification() {
        return this.parent.magnification();
    }

    @Override
    public List<IRectangularArea> zeroLevelActualRectangles() {
        List<IRectangularArea> parentRectangles = this.parent.zeroLevelActualRectangles();
        if (parentRectangles == null) {
            parentRectangles = ExtendingPlanePyramidSource.defaultZeroLevelActualRectangles(this.parent);
            if (parentRectangles == null) {
                return null;
            }
            List<IRectangularArea> pr = parentRectangles;
            LOG.log(System.Logger.Level.DEBUG, () -> "Creating default zero-level actual rectangle: " + String.valueOf(pr));
        }
        IPoint shift = IPoint.of((long)this.positionXInExtendedMatrix, (long)this.positionYInExtendedMatrix);
        ArrayList<IRectangularArea> result = new ArrayList<IRectangularArea>(parentRectangles.size());
        for (IRectangularArea parentRectangle : parentRectangles) {
            IRectangularArea shiftedRectangle = parentRectangle.shift(shift);
            LOG.log(System.Logger.Level.DEBUG, () -> String.format("Shifting zero-level actual rectangle %s by (%d,%d)", parentRectangle, this.positionXInExtendedMatrix, this.positionYInExtendedMatrix));
            result.add(shiftedRectangle);
        }
        return result;
    }

    @Override
    public List<List<List<IPoint>>> zeroLevelActualAreaBoundaries() {
        List<List<List<IPoint>>> boundaries = this.parent.zeroLevelActualAreaBoundaries();
        if (boundaries == null) {
            return super.zeroLevelActualAreaBoundaries();
        }
        IPoint shift = IPoint.of((long)this.positionXInExtendedMatrix, (long)this.positionYInExtendedMatrix);
        ArrayList<List<List<IPoint>>> result = new ArrayList<List<List<IPoint>>>();
        for (List<List<IPoint>> area : boundaries) {
            ArrayList shiftedArea = new ArrayList();
            for (List<IPoint> boundary : area) {
                ArrayList<IPoint> shiftedBoundary = new ArrayList<IPoint>();
                for (IPoint p : boundary) {
                    shiftedBoundary.add(p.add(shift));
                }
                LOG.log(System.Logger.Level.DEBUG, () -> String.format("Shifting zero-level actual area boundary %s by (%d,%d)", boundary, this.positionXInExtendedMatrix, this.positionYInExtendedMatrix));
                shiftedArea.add(shiftedBoundary);
            }
            result.add(shiftedArea);
        }
        return result;
    }

    @Override
    public boolean isSpecialMatrixSupported(PlanePyramidSource.SpecialImageKind kind) {
        return this.parent.isSpecialMatrixSupported(kind);
    }

    @Override
    public Optional<Matrix<? extends PArray>> readSpecialMatrix(PlanePyramidSource.SpecialImageKind kind) throws NotYetConnectedException {
        return this.parent.readSpecialMatrix(kind);
    }

    @Override
    public boolean isDataReady() {
        return this.parent.isDataReady();
    }

    @Override
    public Optional<String> metadata() {
        return this.parent.metadata();
    }

    @Override
    public void loadResources() {
        this.parent.loadResources();
        super.loadResources();
    }

    @Override
    public void freeResources(PlanePyramidSource.FlushMode flushMode) {
        super.freeResources(flushMode);
        this.parent.freeResources(flushMode);
    }

    @Override
    protected Matrix<? extends PArray> readLittleSubMatrix(int resolutionLevel, long fromX, long fromY, long toX, long toY) throws NoSuchElementException, NotYetConnectedException {
        this.checkSubMatrixRanges(resolutionLevel, fromX, fromY, toX, toY, false);
        long sizeX = toX - fromX;
        long sizeY = toY - fromY;
        if (sizeX == 0L || sizeY == 0L) {
            Class elementType = this.parent.readSubMatrix(resolutionLevel, 0L, 0L, sizeX, sizeY).elementType();
            return Arrays.SMM.newMatrix(UpdatablePArray.class, elementType, new long[]{this.bandCount, sizeX, sizeY});
        }
        long x = this.positionXInExtendedMatrix;
        long y = this.positionYInExtendedMatrix;
        for (int k = 0; k < resolutionLevel; ++k) {
            x /= (long)this.compression;
            y /= (long)this.compression;
        }
        long[] parentDimensions = this.parent.dimensions(resolutionLevel);
        long aMinX = x;
        long aMinY = y;
        long aMaxX = x + parentDimensions[1] - 1L;
        long aMaxY = y + parentDimensions[2] - 1L;
        assert (aMinX <= aMaxX && aMinY <= aMaxY) : "Illegal implementation of " + String.valueOf(this.parent);
        if (aMinX <= fromX && aMinY <= fromY && aMaxX + 1L >= toX && aMaxY + 1L >= toY && this.bandCount == this.parent.bandCount()) {
            return this.parent.readSubMatrix(resolutionLevel, fromX - x, fromY - y, toX - x, toY - y);
        }
        long partFromX = Math.max(fromX, aMinX);
        long partFromY = Math.max(fromY, aMinY);
        long partToX = Math.min(toX, aMaxX + 1L);
        long partToY = Math.min(toY, aMaxY + 1L);
        boolean hasActualData = partFromX < partToX && partFromY < partToY;
        Matrix<? extends PArray> actual = hasActualData ? this.parent.readSubMatrix(resolutionLevel, partFromX - x, partFromY - y, partToX - x, partToY - y) : this.parent.readSubMatrix(resolutionLevel, 0L, 0L, 0L, 0L);
        long aBandCount = actual.dim(0);
        Matrix result = Arrays.SMM.newMatrix(UpdatablePArray.class, actual.elementType(), new long[]{this.bandCount, sizeX, sizeY});
        PlanePyramidTools.fillMatrix((Matrix<? extends UpdatablePArray>)result, this.backgroundColor);
        if (hasActualData && this.bandCount == 4 && aBandCount < 4L) {
            PlanePyramidTools.fillMatrix((Matrix<? extends UpdatablePArray>)result, partFromX - fromX, partFromY - fromY, partToX - fromX, partToY - fromY, new double[]{1.0, 1.0, 1.0, 1.0});
        }
        long borderedMinX = aMinX - (long)this.extendingBorderWidth;
        long borderedMaxX = aMaxX + (long)this.extendingBorderWidth;
        long borderedMinY = aMinY - (long)this.extendingBorderWidth;
        long borderedMaxY = aMaxY + (long)this.extendingBorderWidth;
        if (fromX > borderedMaxX || fromY > borderedMaxY || toX <= borderedMinX || toY <= borderedMinY) {
            return result;
        }
        if (this.extendingBorderWidth > 0) {
            long borderedPartFromX = Math.max(fromX, borderedMinX);
            long borderedPartFromY = Math.max(fromY, borderedMinY);
            long borderedPartToX = Math.min(toX, borderedMaxX + 1L);
            long borderedPartToY = Math.min(toY, borderedMaxY + 1L);
            PlanePyramidTools.fillMatrix((Matrix<? extends UpdatablePArray>)result, borderedPartFromX - fromX, borderedPartFromY - fromY, borderedPartToX - fromX, borderedPartToY - fromY, this.extendingBorderColor);
        }
        if (!hasActualData) {
            return result;
        }
        ((UpdatablePArray)result.subMatrix(0L, partFromX - fromX, partFromY - fromY, aBandCount, partToX - fromX, partToY - fromY).array()).copy(actual.array());
        if (aBandCount == 1L && this.bandCount >= 3) {
            ((UpdatablePArray)result.subMatrix(1L, partFromX - fromX, partFromY - fromY, 2L, partToX - fromX, partToY - fromY).array()).copy(actual.array());
            ((UpdatablePArray)result.subMatrix(2L, partFromX - fromX, partFromY - fromY, 3L, partToX - fromX, partToY - fromY).array()).copy(actual.array());
        }
        return result;
    }
}

