/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.api.sources;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.ByteArray;
import net.algart.arrays.DataFileModel;
import net.algart.arrays.DefaultDataFileModel;
import net.algart.arrays.IllegalInfoSyntaxException;
import net.algart.arrays.JArrays;
import net.algart.arrays.LargeMemoryModel;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MatrixInfo;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.StandardIODataFileModel;
import net.algart.arrays.UpdatablePArray;
import net.algart.io.awt.ImageToMatrix;
import net.algart.maps.pyramids.io.api.AbstractPlanePyramidSourceWrapper;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.maps.pyramids.io.api.PlanePyramidTools;
import net.algart.maps.pyramids.io.api.sources.DefaultPlanePyramidSource;

public final class ImageIOPlanePyramidSource
extends AbstractPlanePyramidSourceWrapper
implements PlanePyramidSource {
    private static final String CACHE_READY_MARKER_FILE = ".ready";
    private static final int COMPRESSION = Math.max(2, Arrays.SystemSettings.getIntProperty((String)"net.algart.maps.pyramids.io.api.sources.ImageIOPlanePyramidSource.compression", (int)2));
    private static final int MIN_PYRAMID_LEVEL_SIDE = Arrays.SystemSettings.getIntProperty((String)"net.algart.maps.pyramids.io.api.sources.ImageIOPlanePyramidSource.minPyramidLevelSide", (int)512);
    private static final System.Logger LOG = System.getLogger(ImageIOPlanePyramidSource.class.getName());
    private final DefaultPlanePyramidSource parent;

    public ImageIOPlanePyramidSource(File imageFile) throws IOException {
        this(null, imageFile, null, new ImageIOReadingBehaviour());
    }

    public ImageIOPlanePyramidSource(File pyramidCacheDir, File imageFile, ImageIOReadingBehaviour imageIOReadingBehaviour) throws IOException {
        this(pyramidCacheDir, imageFile, null, imageIOReadingBehaviour);
    }

    public ImageIOPlanePyramidSource(File pyramidCacheDir, BufferedImage image, ImageIOReadingBehaviour imageIOReadingBehaviour) throws IOException {
        this(pyramidCacheDir, null, image, imageIOReadingBehaviour);
    }

    private ImageIOPlanePyramidSource(File pyramidCacheDir, File imageFile, BufferedImage image, ImageIOReadingBehaviour imageIOReadingBehaviour) throws IOException {
        if (imageFile == null && image == null) {
            throw new NullPointerException("Null image or path to image");
        }
        Objects.requireNonNull(imageIOReadingBehaviour, "Null imageIOReadingBehaviour");
        long t1 = System.nanoTime();
        List<Matrix<? extends PArray>> pyramid = ImageIOPlanePyramidSource.openExistingPyramid(pyramidCacheDir);
        if (pyramid != null) {
            int[] nArray;
            if (image != null) {
                int[] nArray2 = new int[2];
                nArray2[0] = image.getWidth();
                nArray = nArray2;
                nArray2[1] = image.getHeight();
            } else {
                nArray = ImageIOPlanePyramidSource.readImageDimensions(imageFile);
            }
            int[] dimensions = nArray;
            Matrix<? extends PArray> first = pyramid.getFirst();
            if (first.dim(1) != (long)dimensions[0] || first.dim(2) != (long)dimensions[1]) {
                throw new IOException("Illegal or corrupted cache: the pyramid in cache has zero-level " + first.dim(1) + "x" + first.dim(2) + "(x" + first.dim(0) + "), but the passed image is " + dimensions[0] + "x" + dimensions[1]);
            }
            this.parent = new DefaultPlanePyramidSource(pyramid);
            long t2 = System.nanoTime();
            LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "ImageIOPlanePyramidSource opens image from cache %s: %dx%d, %d bands, %d levels (%.3f ms)", pyramidCacheDir, first.dim(1), first.dim(2), this.parent.bandCount(), this.parent.numberOfResolutions(), (double)(t2 - t1) * 1.0E-6));
            return;
        }
        long t2 = System.nanoTime();
        if (image == null) {
            image = imageIOReadingBehaviour.read(imageFile);
        }
        int[] bitsPerElements = image.getSampleModel().getSampleSize();
        boolean depth8 = true;
        for (int sampleSize : bitsPerElements) {
            depth8 &= sampleSize == 8;
        }
        Matrix matrixZero = new ImageToMatrix.ToInterleavedRGB().setReadingViaColorModel(imageIOReadingBehaviour.readingViaColorModel).setReadingViaGraphics(imageIOReadingBehaviour.readingViaGraphics || !depth8).setEnableAlpha(imageIOReadingBehaviour.addAlphaWhenExist).toMatrix(image);
        image = null;
        if (pyramidCacheDir != null && !pyramidCacheDir.mkdir()) {
            if (pyramidCacheDir.exists()) {
                throw new IOException("Cannot create " + String.valueOf(pyramidCacheDir) + ": this directory already exists, and " + String.valueOf(this.getClass()) + " has no right to overwrite it");
            }
            throw new FileNotFoundException("Cannot create " + String.valueOf(pyramidCacheDir));
        }
        long t3 = System.nanoTime();
        int numberOfResolutions = PlanePyramidTools.numberOfResolutions(matrixZero.dim(1), matrixZero.dim(2), COMPRESSION, MIN_PYRAMID_LEVEL_SIDE);
        List<Matrix<? extends UpdatablePArray>> newPyramid = ImageIOPlanePyramidSource.createNewPyramid(pyramidCacheDir, matrixZero.elementType(), matrixZero.dim(0), matrixZero.dim(1), matrixZero.dim(2), COMPRESSION, numberOfResolutions);
        long t4 = System.nanoTime();
        ImageIOPlanePyramidSource.buildNewPyramid(newPyramid, (Matrix<? extends PArray>)matrixZero, COMPRESSION, Matrices.ResizingMethod.AVERAGING);
        long t5 = System.nanoTime();
        ImageIOPlanePyramidSource.finishNewPyramid(pyramidCacheDir, newPyramid);
        this.parent = new DefaultPlanePyramidSource(newPyramid);
        long t6 = System.nanoTime();
        LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "ImageIOPlanePyramidSource created new plane pyramid %s (source #%d/%d, [%s] bits/pixel): %dx%d, %d bands, %d levels, compression in %d times (%.3f ms = %.3f start + %.3f reading  + %.3f creating + %.3f compression + %.3f finish);  settings: %s", pyramidCacheDir == null ? "in temporary files" : "cached in " + String.valueOf(pyramidCacheDir), imageIOReadingBehaviour.getImageIndex(), imageIOReadingBehaviour.getLastImageCount(), JArrays.toString((int[])bitsPerElements, (String)",", (int)200), ((Matrix)newPyramid.get(0)).dim(1), ((Matrix)newPyramid.get(0)).dim(2), this.parent.bandCount(), this.parent.numberOfResolutions(), this.parent.compression(), (double)(t6 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6, (double)(t6 - t5) * 1.0E-6, imageIOReadingBehaviour));
    }

    @Override
    protected PlanePyramidSource parent() {
        return this.parent;
    }

    public boolean isContinuationEnabled() {
        return this.parent.isContinuationEnabled();
    }

    public ImageIOPlanePyramidSource setContinuationEnabled(boolean continuationEnabled) {
        this.parent.setContinuationEnabled(continuationEnabled);
        return this;
    }

    private static List<Matrix<? extends PArray>> openExistingPyramid(File pyramidDir) throws IOException {
        if (pyramidDir == null) {
            return null;
        }
        if (pyramidDir.exists() && new File(pyramidDir, CACHE_READY_MARKER_FILE).exists()) {
            ArrayList<Matrix<? extends PArray>> pyramid = new ArrayList<Matrix<? extends PArray>>();
            int level = 0;
            while (true) {
                Matrix matrix;
                File matrixDir = new File(pyramidDir, "m" + level);
                if (level > 0 && !matrixDir.exists()) break;
                String path = matrixDir.getAbsolutePath();
                if (!matrixDir.isDirectory()) {
                    throw new FileNotFoundException("Matrix path not found or not a directory: " + path);
                }
                MatrixInfo mi = ImageIOPlanePyramidSource.readMatrixInfo(matrixDir, "index");
                File matrixFile = new File(matrixDir, "matrix");
                try {
                    matrix = LargeMemoryModel.getInstance((DataFileModel)new StandardIODataFileModel()).asMatrix((Object)matrixFile.getAbsoluteFile(), mi);
                }
                catch (IllegalInfoSyntaxException e) {
                    IOException ex = new IOException(e.getMessage());
                    ex.initCause(e);
                    throw ex;
                }
                pyramid.add((Matrix<? extends PArray>)matrix);
                ++level;
            }
            assert (pyramid.size() > 0);
            return pyramid;
        }
        return null;
    }

    private static List<Matrix<? extends UpdatablePArray>> createNewPyramid(File pyramidDir, Class<?> elementType, long bandCount, long dimX, long dimY, int compression, int numberOfResolutions) throws IOException {
        ArrayList<Matrix<? extends UpdatablePArray>> result = new ArrayList<Matrix<? extends UpdatablePArray>>();
        for (int level = 0; level < numberOfResolutions; ++level) {
            PArray a;
            SimpleMemoryModel mm;
            if (pyramidDir != null) {
                File matrixDir = new File(pyramidDir, "m" + level);
                if (!matrixDir.mkdir()) {
                    throw new IOException("Cannot create " + String.valueOf(matrixDir));
                }
                mm = LargeMemoryModel.getInstance((DataFileModel)new DefaultDataFileModel(new File(matrixDir, "matrix")));
            } else {
                mm = Arrays.SMM;
            }
            Matrix m = mm.newMatrix(UpdatablePArray.class, elementType, new long[]{bandCount, dimX, dimY});
            m = m.tile(new long[]{bandCount, DEFAULT_TILE_DIM, DEFAULT_TILE_DIM});
            if (pyramidDir != null && LargeMemoryModel.isLargeArray((Array)(a = LargeMemoryModel.getRawArrayForSavingInFile((Matrix)m)))) {
                LargeMemoryModel.setTemporary((Array)a, (boolean)false);
            }
            result.add((Matrix<? extends UpdatablePArray>)m);
            dimX /= (long)compression;
            dimY /= (long)compression;
        }
        return result;
    }

    private static void buildNewPyramid(List<Matrix<? extends UpdatablePArray>> pyramid, Matrix<? extends PArray> matrixZero, int compression, Matrices.ResizingMethod resizingMethod) {
        int numberOfResolutions = pyramid.size();
        Matrices.copy(null, pyramid.get(0), matrixZero);
        for (int level = 1; level < numberOfResolutions; ++level) {
            Matrix src = level == 1 ? matrixZero : pyramid.get(level - 1);
            Matrix<? extends UpdatablePArray> dest = pyramid.get(level);
            if (src.dim(1) != dest.dim(1) * (long)compression || src.dim(2) != dest.dim(2) * (long)compression) {
                src = src.subMatr(0L, 0L, 0L, src.dim(0), dest.dim(1) * (long)compression, dest.dim(2) * (long)compression);
            }
            Matrices.resize(null, (Matrices.ResizingMethod)resizingMethod, dest, src);
        }
    }

    private static void finishNewPyramid(File pyramidDir, List<Matrix<? extends UpdatablePArray>> pyramid) throws IOException {
        if (pyramidDir == null) {
            return;
        }
        for (Matrix<? extends UpdatablePArray> m : pyramid) {
            PArray array = LargeMemoryModel.getRawArrayForSavingInFile(m);
            File data = (File)LargeMemoryModel.getInstance().getDataFilePath((Array)array);
            File matrixDir = data.getParentFile();
            MatrixInfo mi = LargeMemoryModel.getMatrixInfoForSavingInFile(m, (long)0L);
            File indexFile = new File(matrixDir, "index");
            assert (!indexFile.exists());
            try (FileOutputStream outputStream = new FileOutputStream(indexFile);){
                outputStream.write(mi.toBytes());
            }
        }
        if (!new File(pyramidDir, CACHE_READY_MARKER_FILE).createNewFile()) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MatrixInfo readMatrixInfo(File directory, String indexFileName) throws IOException {
        MatrixInfo matrixInfo;
        File indexFile = new File(directory, indexFileName);
        ByteArray byteArray = LargeMemoryModel.getInstance((DataFileModel)new StandardIODataFileModel(false, false)).asByteArray((Object)indexFile, 0L, -1L, ByteOrder.nativeOrder());
        try {
            byte[] ja = new byte[8192];
            byteArray.getData(0L, (Object)ja);
            matrixInfo = MatrixInfo.of((byte[])ja);
        }
        catch (Throwable throwable) {
            try {
                byteArray.freeResources(null);
                throw throwable;
            }
            catch (IllegalInfoSyntaxException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        byteArray.freeResources(null);
        return matrixInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readImageDimensions(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("Image file " + String.valueOf(file) + " does not exist");
        }
        try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(iis);
            if (!iterator.hasNext()) {
                throw new IIOException("Unknown image format: can't create an ImageInputStream");
            }
            ImageReader reader = iterator.next();
            try {
                reader.setInput(iis);
                int[] nArray = new int[]{reader.getWidth(0), reader.getHeight(0)};
                reader.dispose();
                return nArray;
            }
            catch (Throwable throwable) {
                reader.dispose();
                throw throwable;
            }
        }
    }

    public static class ImageIOReadingBehaviour
    implements Cloneable {
        protected int imageIndex = 0;
        private boolean addAlphaWhenExist = false;
        private boolean readingViaColorModel = false;
        private boolean readingViaGraphics = false;
        private boolean dicomReader = false;
        private volatile int lastImageCount = -1;

        public int getImageIndex() {
            return this.imageIndex;
        }

        public void setImageIndex(int imageIndex) {
            this.imageIndex = imageIndex;
        }

        public boolean isAddAlphaWhenExist() {
            return this.addAlphaWhenExist;
        }

        public ImageIOReadingBehaviour setAddAlphaWhenExist(boolean addAlphaWhenExist) {
            this.addAlphaWhenExist = addAlphaWhenExist;
            return this;
        }

        public boolean isReadingViaColorModel() {
            return this.readingViaColorModel;
        }

        public ImageIOReadingBehaviour setReadingViaColorModel(boolean readingViaColorModel) {
            this.readingViaColorModel = readingViaColorModel;
            return this;
        }

        public boolean isReadingViaGraphics() {
            return this.readingViaGraphics;
        }

        public ImageIOReadingBehaviour setReadingViaGraphics(boolean readingViaGraphics) {
            this.readingViaGraphics = readingViaGraphics;
            return this;
        }

        public boolean isDicomReader() {
            return this.dicomReader;
        }

        public ImageIOReadingBehaviour setDicomReader(boolean dicomReader) {
            this.dicomReader = dicomReader;
            return this;
        }

        public int getLastImageCount() {
            return this.lastImageCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage read(File imageFile) throws IOException {
            Objects.requireNonNull(imageFile, "Null image file");
            if (!imageFile.isFile()) {
                throw new FileNotFoundException("Image file " + String.valueOf(imageFile) + " is not a regular file");
            }
            try (ImageInputStream iis = ImageIO.createImageInputStream(imageFile);){
                ImageReader reader = this.getImageReader(iis);
                try {
                    ImageReadParam param = this.getReadParam(reader);
                    reader.setInput(iis, false, true);
                    BufferedImage result = this.readBufferedImageByReader(reader, param);
                    this.lastImageCount = reader.getNumImages(false);
                    BufferedImage bufferedImage = result;
                    reader.dispose();
                    return bufferedImage;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int imageCount(File imageFile) throws IOException {
            try (ImageInputStream iis = ImageIO.createImageInputStream(imageFile);){
                ImageReader reader = this.getImageReader(iis);
                try {
                    reader.setInput(iis, false);
                    int n = reader.getNumImages(true);
                    reader.dispose();
                    return n;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
        }

        public ImageIOReadingBehaviour clone() {
            try {
                return (ImageIOReadingBehaviour)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.toString());
            }
        }

        public String toString() {
            return "ImageIOReadingBehaviour{imageIndex=" + this.getImageIndex() + ", addAlphaWhenExist=" + this.isAddAlphaWhenExist() + ", isReadingViaColorModel=" + this.isReadingViaColorModel() + ", isReadingViaGraphics=" + this.isReadingViaGraphics() + ", dicomReader=" + this.dicomReader + "}";
        }

        protected ImageReader getImageReader(ImageInputStream imageInputStream) throws IIOException {
            Iterator<ImageReader> iterator;
            if (imageInputStream == null) {
                throw new IIOException("Cannot create image input stream: no suitable ImageInputStreamSpi exists");
            }
            if (this.dicomReader) {
                iterator = ImageIO.getImageReadersByFormatName("DICOM");
                if (!iterator.hasNext()) {
                    throw new IIOException("No available DICOM image reader");
                }
            } else {
                iterator = ImageIO.getImageReaders(imageInputStream);
                if (!iterator.hasNext()) {
                    throw new IIOException("Unknown image format: no suitable ImageIO readers");
                }
            }
            return iterator.next();
        }

        protected ImageReadParam getReadParam(ImageReader imageReader) {
            return imageReader.getDefaultReadParam();
        }

        protected BufferedImage readBufferedImageByReader(ImageReader reader, ImageReadParam param) throws IOException {
            return reader.read(this.imageIndex, param);
        }
    }
}

