/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.formats.common.recognition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatablePIntegerArray;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.UniformGridPattern;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.IterativeErosion;
import net.algart.matrices.morphology.Morphology;

public class SquaresAtObject {
    private static boolean DEBUG_EROSION_OPTIMIZATION = false;
    private static final System.Logger LOG = System.getLogger(SquaresAtObject.class.getName());
    private final Matrix<? extends BitArray> sourceMatrix;
    private final Matrix<UpdatableBitArray> workMatrix;
    private final int dimCount;
    private final List<IRectangularArea> foundSquares = new ArrayList<IRectangularArea>();
    private volatile int maxNumberOfSquares = 10000;
    private volatile long fixedSquareSide = 100L;
    private volatile long overlapOfSquares = 0L;

    private SquaresAtObject(Matrix<? extends BitArray> sourceMatrix) {
        Objects.requireNonNull(sourceMatrix, "Null source matrix");
        this.sourceMatrix = sourceMatrix;
        this.workMatrix = Arrays.SMM.newBitMatrix(sourceMatrix.dimensions());
        this.dimCount = this.workMatrix.dimCount();
        long[] from = new long[this.dimCount];
        long[] to = new long[this.dimCount];
        for (int k = 0; k < this.dimCount; ++k) {
            from[k] = 1L;
            to[k] = this.workMatrix.dim(k) - 1L;
            if (from[k] < to[k]) continue;
            return;
        }
        ((UpdatableBitArray)this.workMatrix.subMatrix(from, to).array()).copy(sourceMatrix.subMatrix(from, to).array());
    }

    public static SquaresAtObject getInstance(Matrix<? extends BitArray> sourceMatrix) {
        return new SquaresAtObject(sourceMatrix);
    }

    public Matrix<? extends BitArray> getSourceMatrix() {
        return this.sourceMatrix;
    }

    public Matrix<UpdatableBitArray> getWorkMatrix() {
        return this.workMatrix;
    }

    public List<IRectangularArea> getFoundSquares() {
        return Collections.unmodifiableList(this.foundSquares);
    }

    public int getMaxNumberOfSquares() {
        return this.maxNumberOfSquares;
    }

    public void setMaxNumberOfSquares(int maxNumberOfSquares) {
        if (maxNumberOfSquares < 0) {
            throw new IllegalArgumentException("Negative maxNumberOfSquares");
        }
        this.maxNumberOfSquares = maxNumberOfSquares;
    }

    public long getFixedSquareSide() {
        return this.fixedSquareSide;
    }

    public void setFixedSquareSide(long fixedSquareSide) {
        if (fixedSquareSide <= 0L) {
            throw new IllegalArgumentException("Zero or negative fixedSquareSide");
        }
        this.fixedSquareSide = fixedSquareSide;
    }

    public long getOverlapOfSquares() {
        return this.overlapOfSquares;
    }

    public void setOverlapOfSquares(long overlapOfSquares) {
        this.overlapOfSquares = overlapOfSquares;
    }

    public void findSquaresWithFixedSizes() {
        int squareCount;
        if (this.overlapOfSquares >= this.fixedSquareSide) {
            throw new IllegalStateException("Cannot find squares of fixed sizes with overlap " + this.overlapOfSquares + " >= square side" + this.fixedSquareSide);
        }
        long t1 = System.nanoTime();
        BasicMorphology morphology = BasicMorphology.getInstance(null);
        UniformGridPattern requiredSquarePattern = Patterns.newRectangularIntegerPattern((IPoint)IPoint.ofEqualCoordinates((int)this.dimCount, (long)0L), (IPoint)IPoint.ofEqualCoordinates((int)this.dimCount, (long)(this.fixedSquareSide - 1L)));
        long reducedSide = this.fixedSquareSide - this.overlapOfSquares;
        Matrix erosion = morphology.erosion(this.workMatrix, (Pattern)requiredSquarePattern);
        BitArray erosionArray = (BitArray)erosion.array();
        long t2 = System.nanoTime();
        long lastNonZeroIndex = -1L;
        IPoint leftTop = null;
        for (squareCount = 0; squareCount < this.maxNumberOfSquares; ++squareCount) {
            IRectangularArea square;
            long tt1 = System.nanoTime();
            long index = -1L;
            if (leftTop != null) {
                long[] coordinates = leftTop.coordinates();
                int n = coordinates.length - 1;
                coordinates[n] = coordinates[n] + reducedSide;
                index = erosion.index(coordinates);
                if (index < 0L || index >= erosionArray.length() || !erosionArray.getBit(index)) {
                    index = -1L;
                }
            }
            if (index == -1L) {
                index = lastNonZeroIndex = ((BitArray)erosion.array()).indexOf(lastNonZeroIndex + 1L, Long.MAX_VALUE, true);
            }
            long tt2 = System.nanoTime();
            if (index != -1L) {
                leftTop = IPoint.of((long[])this.workMatrix.coordinates(index, null));
                square = IRectangularArea.of((IPoint)leftTop, (IPoint)leftTop.add(IPoint.ofEqualCoordinates((int)this.dimCount, (long)(this.fixedSquareSide - 1L))));
                this.foundSquares.add(square);
                if (!DEBUG_EROSION_OPTIMIZATION) {
                    IRectangularArea reducedSquare = IRectangularArea.of((IPoint)leftTop.add(IPoint.ofEqualCoordinates((int)this.dimCount, (long)(-this.fixedSquareSide + 1L))), (IPoint)leftTop.add(IPoint.ofEqualCoordinates((int)this.dimCount, (long)(reducedSide - 1L))));
                    ((UpdatablePArray)erosion.subMatrix(reducedSquare, Matrix.ContinuationMode.NULL_CONSTANT).array()).fill(0L);
                } else {
                    IRectangularArea reducedSquare = IRectangularArea.of((IPoint)leftTop, (IPoint)leftTop.add(IPoint.ofEqualCoordinates((int)this.dimCount, (long)(reducedSide - 1L))));
                    ((UpdatableBitArray)this.workMatrix.subMatrix(reducedSquare, Matrix.ContinuationMode.NULL_CONSTANT).array()).fill(0L);
                    erosion = morphology.erosion(this.workMatrix, (Pattern)requiredSquarePattern);
                }
            } else {
                square = null;
            }
            long tt3 = System.nanoTime();
            SquaresAtObject.debug(System.Logger.Level.TRACE, "Square #%d/%d %s in %.3f ms (%.3f search + %.3f removing from search)", squareCount + 1, this.maxNumberOfSquares, square == null ? "not found" : "found (" + String.valueOf(square) + ")", (double)(tt3 - tt1) * 1.0E-6, (double)(tt2 - tt1) * 1.0E-6, (double)(tt3 - tt2) * 1.0E-6);
            if (square != null) continue;
            SquaresAtObject.debug(System.Logger.Level.DEBUG, "Finishing loop: all squares are already found", new Object[0]);
            break;
        }
        long t3 = System.nanoTime();
        SquaresAtObject.debug(System.Logger.Level.DEBUG, "%d squares found in %.3f ms (%.3f preprocessing + %.3f search)", squareCount, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6);
    }

    public void findSquaresWithDecreasingSizes() {
        int squareCount;
        long t1 = System.nanoTime();
        for (squareCount = 0; squareCount < this.maxNumberOfSquares; ++squareCount) {
            long tt1 = System.nanoTime();
            IterativeErosion iterativeErosion = IterativeErosion.getInstance((Morphology)BasicMorphology.getInstance(null), UpdatableIntArray.class, this.workMatrix, (Pattern[])new Pattern[]{Patterns.newRectangularIntegerPattern((IPoint)IPoint.ofEqualCoordinates((int)this.dimCount, (long)-1L), (IPoint)IPoint.ofEqualCoordinates((int)this.dimCount, (long)1L))});
            long tt2 = System.nanoTime();
            iterativeErosion.process();
            long tt3 = System.nanoTime();
            Arrays.MinMaxInfo minMaxInfo = new Arrays.MinMaxInfo();
            UpdatablePIntegerArray resultArray = (UpdatablePIntegerArray)iterativeErosion.result().array();
            Arrays.rangeOf(null, (PArray)resultArray, (Arrays.MinMaxInfo)minMaxInfo);
            IPoint center = IPoint.of((long[])this.workMatrix.coordinates(minMaxInfo.indexOfMax(), null));
            long distanceToEdge = resultArray.getLong(minMaxInfo.indexOfMax());
            IRectangularArea square = IRectangularArea.of((IPoint)center.add(IPoint.ofEqualCoordinates((int)this.dimCount, (long)(-distanceToEdge))), (IPoint)center.add(IPoint.ofEqualCoordinates((int)this.dimCount, (long)distanceToEdge)));
            long reducedSide = 2L * distanceToEdge + 1L - this.overlapOfSquares;
            long tt4 = System.nanoTime();
            SquaresAtObject.debug(System.Logger.Level.TRACE, "Square #%d/%d found (%s) in %.3f ms (%.3f preparig + %.3f erosion + %.3f finding center)", squareCount + 1, this.maxNumberOfSquares, square, (double)(tt4 - tt1) * 1.0E-6, (double)(tt2 - tt1) * 1.0E-6, (double)(tt3 - tt2) * 1.0E-6, (double)(tt4 - tt3) * 1.0E-6);
            if (reducedSide <= 1L) {
                SquaresAtObject.debug(System.Logger.Level.DEBUG, "Finishing loop: all squares are already found", new Object[0]);
                break;
            }
            this.foundSquares.add(square);
            IRectangularArea reducedSquare = IRectangularArea.of((IPoint)center.add(IPoint.ofEqualCoordinates((int)this.dimCount, (long)(-reducedSide / 2L))), (IPoint)center.add(IPoint.ofEqualCoordinates((int)this.dimCount, (long)(-reducedSide / 2L + reducedSide - 1L))));
            Matrix squareSubMatrix = this.workMatrix.subMatrix(reducedSquare, Matrix.ContinuationMode.NULL_CONSTANT);
            ((UpdatableBitArray)squareSubMatrix.array()).fill(false);
        }
        long t2 = System.nanoTime();
        SquaresAtObject.debug(System.Logger.Level.DEBUG, "%d squares found in %.3f ms", squareCount, (double)(t2 - t1) * 1.0E-6);
    }

    private static void debug(System.Logger.Level level, String format, Object ... args) {
        LOG.log(level, () -> String.format(Locale.US, format, args));
    }
}

