/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.formats.sources.svs;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import net.algart.arrays.Arrays;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.maps.pyramids.io.formats.sources.svs.SVSPlanePyramidSource;
import net.algart.matrices.tiff.TiffException;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.tags.TagCompression;
import net.algart.matrices.tiff.tiles.TiffMap;

public final class SVSIFDClassifier {
    private static final int THUMBNAIL_IFD_INDEX = 1;
    private static final int MAX_PIXEL_COUNT_IN_SPECIAL_IMAGES = 0x400000;
    private static final double STANDARD_MACRO_ASPECT_RATIO = 2.8846153846153846;
    private static final double ALLOWED_ASPECT_RATION_DEVIATION = 0.2;
    private static final boolean ALWAYS_USE_SVS_SPECIFICATION_FOR_LABEL_AND_MACRO = Arrays.SystemSettings.getBooleanEnv((String)"ALWAYS_USE_SVS_SPECIFICATION_FOR_LABEL_AND_MACRO", (boolean)false);
    private static final System.Logger LOG = System.getLogger(SVSPlanePyramidSource.class.getName());
    private final List<? extends TiffMap> maps;
    private final int ifdCount;
    private int thumbnailIndex = -1;
    private int labelIndex = -1;
    private int macroIndex = -1;
    private final List<Integer> unknownSpecialIndexes = new ArrayList<Integer>();

    public SVSIFDClassifier(List<? extends TiffMap> maps) throws TiffException {
        Objects.requireNonNull(maps);
        this.maps = maps;
        this.ifdCount = maps.size();
        this.detectThumbnail();
        if (!this.detectTwoLastImages()) {
            this.detectSingleLastImage();
        }
        for (int k = 1; k < this.ifdCount; ++k) {
            if (this.isSpecial(k) || !SVSIFDClassifier.isSmallImage(this.maps.get(k).ifd())) continue;
            this.unknownSpecialIndexes.add(k);
        }
    }

    public boolean isSpecial(int ifdIndex) {
        if (ifdIndex < 0) {
            throw new IllegalArgumentException("Negative ifdIndex");
        }
        return ifdIndex == this.thumbnailIndex || ifdIndex == this.labelIndex || ifdIndex == this.macroIndex;
    }

    public boolean isUnknownSpecial(int ifdIndex) {
        return this.unknownSpecialIndexes.contains(ifdIndex);
    }

    public boolean hasThumbnail() {
        return this.thumbnailIndex != -1;
    }

    public int getThumbnailIndex() {
        return this.thumbnailIndex;
    }

    public boolean hasLabel() {
        return this.labelIndex != -1;
    }

    public int getLabelIndex() {
        return this.labelIndex;
    }

    public boolean hasMacro() {
        return this.macroIndex != -1;
    }

    public int getMacroIndex() {
        return this.macroIndex;
    }

    public boolean hasUnknownSpecial() {
        return !this.unknownSpecialIndexes.isEmpty();
    }

    public List<Integer> getUnknownSpecialIndexes() {
        return Collections.unmodifiableList(this.unknownSpecialIndexes);
    }

    public OptionalInt getSpecialKindIndex(PlanePyramidSource.SpecialImageKind kind) {
        Objects.requireNonNull(kind, "Null image kind");
        Integer ifdIndex = null;
        switch (kind) {
            case LABEL_ONLY_IMAGE: {
                if (this.labelIndex == -1) break;
                ifdIndex = this.labelIndex;
                break;
            }
            case WHOLE_SLIDE: {
                if (this.macroIndex == -1) break;
                ifdIndex = this.macroIndex;
                break;
            }
            case THUMBNAIL_IMAGE: {
                if (this.thumbnailIndex == -1) break;
                ifdIndex = this.thumbnailIndex;
                break;
            }
            case CUSTOM_KIND_1: {
                if (this.unknownSpecialIndexes.size() < 1) break;
                ifdIndex = this.unknownSpecialIndexes.get(0);
                break;
            }
            case CUSTOM_KIND_2: {
                if (this.unknownSpecialIndexes.size() < 2) break;
                ifdIndex = this.unknownSpecialIndexes.get(1);
                break;
            }
            case CUSTOM_KIND_3: {
                if (this.unknownSpecialIndexes.size() < 3) break;
                ifdIndex = this.unknownSpecialIndexes.get(2);
                break;
            }
            case CUSTOM_KIND_4: {
                if (this.unknownSpecialIndexes.size() < 4) break;
                ifdIndex = this.unknownSpecialIndexes.get(3);
                break;
            }
            case CUSTOM_KIND_5: {
                if (this.unknownSpecialIndexes.size() < 5) break;
                ifdIndex = this.unknownSpecialIndexes.get(4);
            }
        }
        return ifdIndex == null ? OptionalInt.empty() : OptionalInt.of(ifdIndex);
    }

    public boolean isSpecialMatrixSupported(PlanePyramidSource.SpecialImageKind kind) {
        return switch (kind) {
            case PlanePyramidSource.SpecialImageKind.LABEL_ONLY_IMAGE -> {
                if (this.labelIndex != -1) {
                    yield true;
                }
                yield false;
            }
            case PlanePyramidSource.SpecialImageKind.WHOLE_SLIDE -> {
                if (this.macroIndex != -1) {
                    yield true;
                }
                yield false;
            }
            case PlanePyramidSource.SpecialImageKind.THUMBNAIL_IMAGE -> {
                if (this.thumbnailIndex != -1) {
                    yield true;
                }
                yield false;
            }
            case PlanePyramidSource.SpecialImageKind.CUSTOM_KIND_1 -> {
                if (this.unknownSpecialIndexes.size() >= 1) {
                    yield true;
                }
                yield false;
            }
            case PlanePyramidSource.SpecialImageKind.CUSTOM_KIND_2 -> {
                if (this.unknownSpecialIndexes.size() >= 2) {
                    yield true;
                }
                yield false;
            }
            case PlanePyramidSource.SpecialImageKind.CUSTOM_KIND_3 -> {
                if (this.unknownSpecialIndexes.size() >= 3) {
                    yield true;
                }
                yield false;
            }
            case PlanePyramidSource.SpecialImageKind.CUSTOM_KIND_4 -> {
                if (this.unknownSpecialIndexes.size() >= 4) {
                    yield true;
                }
                yield false;
            }
            case PlanePyramidSource.SpecialImageKind.CUSTOM_KIND_5 -> {
                if (this.unknownSpecialIndexes.size() >= 5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public String toString() {
        return "special image positions among " + this.ifdCount + " total images: thumbnail " + (String)(this.thumbnailIndex == -1 ? "NOT FOUND" : "at " + this.thumbnailIndex) + ", label " + (String)(this.labelIndex == -1 ? "NOT FOUND" : "at " + this.labelIndex) + ", macro " + (String)(this.macroIndex == -1 ? "NOT FOUND" : "at " + this.macroIndex) + ", unknown " + String.valueOf(this.unknownSpecialIndexes);
    }

    private void detectThumbnail() throws TiffException {
        if (this.ifdCount <= 1) {
            return;
        }
        TiffIFD ifd = this.maps.get(1).ifd();
        if (SVSIFDClassifier.isSmallImage(ifd)) {
            this.thumbnailIndex = 1;
        }
    }

    private boolean detectTwoLastImages() throws TiffException {
        double area2;
        if (this.ifdCount <= 3) {
            return false;
        }
        int index1 = this.ifdCount - 2;
        int index2 = this.ifdCount - 1;
        TiffMap map1 = this.maps.get(index1);
        TiffMap map2 = this.maps.get(index2);
        TiffIFD ifd1 = map1.ifd();
        TiffIFD ifd2 = map2.ifd();
        if (!SVSIFDClassifier.isSmallImage(ifd1) || !SVSIFDClassifier.isSmallImage(ifd2)) {
            return false;
        }
        LOG.log(System.Logger.Level.DEBUG, () -> String.format("  Checking last 2 small IFDs #%d %s and #%d %s for Label and Macro...", index1, SVSIFDClassifier.sizesToString(map1), index2, SVSIFDClassifier.sizesToString(map2)));
        if (ALWAYS_USE_SVS_SPECIFICATION_FOR_LABEL_AND_MACRO) {
            int compression1 = ifd1.getCompressionCode();
            int compression2 = ifd2.getCompressionCode();
            boolean found = false;
            if (compression1 == TagCompression.LZW.code() && compression2 == TagCompression.JPEG.code()) {
                this.labelIndex = index1;
                this.macroIndex = index2;
                found = true;
            }
            if (compression1 == TagCompression.JPEG.code() && compression2 == TagCompression.LZW.code()) {
                this.labelIndex = index2;
                this.macroIndex = index1;
                found = true;
            }
            if (found) {
                LOG.log(System.Logger.Level.DEBUG, () -> String.format("  Label %d / Macro %d detected by SVS specification", this.labelIndex, this.macroIndex));
                return true;
            }
        }
        double ratio1 = SVSIFDClassifier.ratio(ifd1);
        double ratio2 = SVSIFDClassifier.ratio(ifd2);
        LOG.log(System.Logger.Level.DEBUG, () -> String.format("  Last 2 IFD ratios: %.5f for %d, %.5f for %d, standard Macro %.5f", ratio1, index1, ratio2, index2, 2.8846153846153846));
        double maxRatio = Math.max(ratio1, ratio2);
        if (maxRatio > 2.307692307692308 && maxRatio < 3.6057692307692304) {
            this.macroIndex = ratio1 > ratio2 ? index1 : index2;
            this.labelIndex = ratio1 > ratio2 ? index2 : index1;
            LOG.log(System.Logger.Level.DEBUG, () -> String.format("  Label %d / Macro %d detected by form", this.labelIndex, this.macroIndex));
            return true;
        }
        double area1 = SVSIFDClassifier.area(ifd1);
        this.macroIndex = area1 > (area2 = SVSIFDClassifier.area(ifd2)) ? index1 : index2;
        this.labelIndex = area1 > area2 ? index2 : index1;
        LOG.log(System.Logger.Level.DEBUG, () -> String.format("  Label %d / Macro %d detected by area", this.labelIndex, this.macroIndex));
        return true;
    }

    private void detectSingleLastImage() throws TiffException {
        if (this.ifdCount <= 2) {
            return;
        }
        int index = this.ifdCount - 1;
        TiffMap map = this.maps.get(index);
        TiffIFD ifd = map.ifd();
        if (!SVSIFDClassifier.isSmallImage(ifd)) {
            return;
        }
        double ratio = SVSIFDClassifier.ratio(ifd);
        LOG.log(System.Logger.Level.DEBUG, () -> String.format("  Checking last 1 small IFDs #%d %s for Label or Macro...", index, SVSIFDClassifier.sizesToString(map)));
        LOG.log(System.Logger.Level.DEBUG, () -> String.format("  Last IFD #%d, ratio: %.5f, standard Macro %.5f", index, ratio, 2.8846153846153846));
        if (ratio <= 2.307692307692308) {
            if (ifd.getCompressionCode() == TagCompression.JPEG.code()) {
                this.macroIndex = index;
                LOG.log(System.Logger.Level.DEBUG, () -> String.format("  Macro %d with strange form detected by JPEG compression", index));
            } else {
                this.labelIndex = index;
                LOG.log(System.Logger.Level.DEBUG, () -> String.format("  Label %d detected by form", index));
            }
        } else if (ratio < 3.6057692307692304) {
            this.macroIndex = index;
            LOG.log(System.Logger.Level.DEBUG, () -> String.format("  Macro %d detected by form", index));
        } else {
            LOG.log(System.Logger.Level.DEBUG, () -> String.format("  Last IFD %d is UNKNOWN", index));
        }
    }

    static boolean isSmallImage(TiffIFD ifd) throws TiffException {
        long[] tileOffsets = ifd.getLongArray(324);
        return tileOffsets == null && (long)ifd.getImageDimX() * (long)ifd.getImageDimY() < 0x400000L;
    }

    static String sizesToString(TiffMap map) {
        Objects.requireNonNull(map, "Null map");
        return map.dimX() + "x" + map.dimY();
    }

    static String compressionToString(TiffMap map) {
        Objects.requireNonNull(map, "Null map");
        return String.valueOf(map.ifd().optCompression());
    }

    private static double area(TiffIFD ifd) throws TiffException {
        long dimX = ifd.getImageDimX();
        long dimY = ifd.getImageDimY();
        return (double)dimX * (double)dimY;
    }

    private static double ratio(TiffIFD ifd) throws TiffException {
        long dimX = ifd.getImageDimX();
        long dimY = ifd.getImageDimY();
        assert (dimX > 0L && dimY > 0L);
        return (double)Math.max(dimX, dimY) / (double)Math.min(dimX, dimY);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: " + SVSIFDClassifier.class.getName() + " file1.svs file2.svs ...");
            return;
        }
        for (String arg : args) {
            Path file = Paths.get(arg, new String[0]);
            try (TiffReader reader = new TiffReader(file);){
                SVSIFDClassifier detector = new SVSIFDClassifier(reader.allMaps());
                System.out.printf("%s:%n%s%n%n", file, detector);
            }
        }
    }
}

