/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Context;
import org.bytedeco.opencv.opencv_core.Device;

public final class GPUDevices {
    private static String info(Device device) {
        return String.format("%s %s by %s%n", device.name().getString(), device.version().getString(), device.vendorName().getString());
    }

    public static void main(String[] args) {
        System.out.printf("OpenCL existence: %s%n", opencv_core.haveOpenCL());
        System.out.printf("OpenCL usage: %s%n", opencv_core.useOpenCL());
        try (Context context = new Context(4);){
            System.out.printf("OpenCL default device: %s%n", GPUDevices.info(Device.getDefault()));
            System.out.printf("Number of GPU devices: %d%n", context.ndevices());
            int k = 0;
            while ((long)k < context.ndevices()) {
                System.out.printf("GPU device #%d: %s%n", k, GPUDevices.info(context.device((long)k)));
                ++k;
            }
            new Device(context.device(0L));
        }
        System.out.printf("OpenCL default device: %s%n", GPUDevices.info(Device.getDefault()));
    }
}

