/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import java.util.ArrayList;
import net.algart.executors.api.Executor;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public final class UMatMemoryTest {
    private static final Size SIZE = new Size(2000, 2000);

    public static void main(String[] args) throws InterruptedException {
        opencv_core.setUseOpenCL((boolean)true);
        if (args.length < 2) {
            System.out.printf("Usage: %s source_image number_of_copies%n", UMatMemoryTest.class.getName());
            return;
        }
        String sourceFile = args[0];
        int n = Integer.parseInt(args[1]);
        Mat source = opencv_imgcodecs.imread((String)sourceFile);
        ArrayList<UMat> list = new ArrayList<UMat>();
        Thread.sleep(1000L);
        for (int k = 1; k <= n; ++k) {
            UMat uMat = source.getUMat(0x3000000);
            UMat uResized = new UMat();
            opencv_imgproc.resize((UMat)uMat, (UMat)uResized, (Size)SIZE);
            list.add(uResized);
            uMat.close();
            System.out.printf("%d/%d: %s", k, n, Executor.Timing.memoryInfo());
            Thread.sleep(50L);
        }
    }
}

