/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.dashboard.data;

import com.siams.cv.monitor.dashboard.data.DashboardControl;
import com.siams.cv.monitor.model.worker.control.SCColor;
import com.siams.cv.monitor.model.worker.control.SCEItem;
import com.siams.cv.monitor.model.worker.control.SCEnum;
import com.siams.cv.monitor.model.worker.control.SCFile;
import com.siams.cv.monitor.model.worker.control.SCFileToSave;
import com.siams.cv.monitor.model.worker.control.SCFolder;
import com.siams.cv.monitor.model.worker.control.SCText;
import com.siams.cv.monitor.model.worker.control.SCValue;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.control.UIControlBuilder;
import com.siams.fx.control.UIControlContainer;
import com.siams.stare.api.data.Control;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class PropertyControl
implements DashboardControl {
    private final Control control;
    private UIControlContainer controlContainer = null;

    public PropertyControl(Control control) {
        this.control = control;
    }

    public Control getBackedControl() {
        return this.control;
    }

    public UIControlContainer getControlContainer() {
        if (this.controlContainer == null) {
            this.createControlContainer();
        }
        return this.controlContainer;
    }

    @Override
    public Node getView() {
        return this.getControlContainer().getNode();
    }

    private void createControlContainer() {
        SControl sControl = this.createStructureControl(this.control);
        this.controlContainer = UIControlBuilder.createUIControl((SControl)sControl);
    }

    private SControl createStructureControl(Control control) {
        SCColor sControl = switch (control.editionType) {
            case Control.EditionType.ENUM -> {
                SCEnum scEnum = new SCEnum();
                scEnum.setItems(control.items.stream().map(item -> {
                    SCEItem sItem = new SCEItem();
                    sItem.setCaption(item.caption);
                    sItem.setValue(item.value);
                    return sItem;
                }).collect(Collectors.toList()));
                yield scEnum;
            }
            case Control.EditionType.FILE, Control.EditionType.FILE_TO_SAVE -> {
                SCFileToSave scFile;
                if (control.editionType == Control.EditionType.FILE_TO_SAVE || control.dialog == Control.FileDialog.SAVE) {
                    scFile = new SCFileToSave();
                } else if (control.dialog == Control.FileDialog.OPEN) {
                    scFile = new SCFile();
                } else {
                    throw new RuntimeException("Unsupported");
                }
                yield scFile;
            }
            case Control.EditionType.COLOR -> new SCColor();
            case Control.EditionType.FOLDER -> new SCFolder();
            case Control.EditionType.TEXT -> new SCText();
            case Control.EditionType.VALUE -> {
                SCValue scValue = new SCValue();
                scValue.setMultiline(control.multiline);
                yield scValue;
            }
            default -> throw new IllegalArgumentException("Failed create SControl");
        };
        this.updateControlProperties((SControl)sControl, control);
        return sControl;
    }

    private void updateControlProperties(SControl sControl, Control control) {
        sControl.setName(control.name);
        sControl.setCaption(control.caption);
        sControl.setDef(control.def);
        sControl.setValueType(control.valueType.toString());
        sControl.setDescription(control.description);
    }
}

