/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.ImmutableSortedListOfRanges;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.RegexASTBuilder;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.ArrayList;

public final class OracleDBCharClassTrieNode {
    private CodePointSet codepoints;
    private final ArrayList<OracleDBCharClassTrieNode> children = new ArrayList();
    private boolean isEndOfString;

    private OracleDBCharClassTrieNode(CodePointSet codepoints, boolean isEndOfString) {
        this.codepoints = codepoints;
        this.isEndOfString = isEndOfString;
    }

    public static OracleDBCharClassTrieNode createTreeRoot() {
        return new OracleDBCharClassTrieNode(null, false);
    }

    private static OracleDBCharClassTrieNode createNode(CodePointSet codepoints, boolean isEndOfString) {
        return new OracleDBCharClassTrieNode(codepoints, isEndOfString);
    }

    public ArrayList<OracleDBCharClassTrieNode> getOrAddChildren(CodePointSet cps, boolean endOfString, CompilationBuffer compilationBuffer) {
        if (this.isEndOfString) {
            return null;
        }
        ArrayList<OracleDBCharClassTrieNode> ret = new ArrayList<OracleDBCharClassTrieNode>();
        CodePointSet remaining = cps;
        int length = this.children.size();
        OracleDBCharClassTrieNode leaf = null;
        for (int i = 0; i < length; ++i) {
            OracleDBCharClassTrieNode child = this.children.get(i);
            if (child.children.isEmpty() && endOfString && child.isEndOfString) {
                leaf = child;
            }
            ImmutableSortedListOfRanges.IntersectAndSubtractResult<CodePointSet> result = remaining.intersectAndSubtract(child.codepoints, compilationBuffer);
            if (((CodePointSet)result.intersection).isEmpty()) continue;
            remaining = (CodePointSet)result.subtractedA;
            if (((CodePointSet)result.subtractedB).isEmpty()) {
                ret.add(child);
            } else {
                OracleDBCharClassTrieNode copy = child.copySubtree();
                child.codepoints = (CodePointSet)result.subtractedB;
                copy.codepoints = (CodePointSet)result.intersection;
                this.children.add(copy);
                ret.add(copy);
            }
            if (!remaining.isEmpty()) continue;
            return ret;
        }
        assert (!remaining.isEmpty());
        if (leaf != null) {
            leaf.codepoints = leaf.codepoints.union(remaining, compilationBuffer);
            ret.add(leaf);
        } else {
            OracleDBCharClassTrieNode child = OracleDBCharClassTrieNode.createNode(remaining, endOfString);
            this.children.add(child);
            ret.add(child);
        }
        return ret;
    }

    private OracleDBCharClassTrieNode copySubtree() {
        OracleDBCharClassTrieNode copy = OracleDBCharClassTrieNode.createNode(this.codepoints, this.isEndOfString);
        for (OracleDBCharClassTrieNode child : this.children) {
            copy.children.add(child.copySubtree());
        }
        return copy;
    }

    public boolean isEndOfString() {
        return this.isEndOfString;
    }

    public void setEndOfString() {
        this.isEndOfString = true;
    }

    public void clear() {
        assert (this.codepoints == null && !this.isEndOfString) : "clear can only be called on the root node";
        this.children.clear();
    }

    public void generateAST(RegexASTBuilder astBuilder, boolean negate) {
        if (this.rootNeedsGroupWrapper(negate)) {
            astBuilder.pushGroup();
        }
        if (negate) {
            CodePointSetAccumulator acc = new CodePointSetAccumulator();
            for (OracleDBCharClassTrieNode child : this.children) {
                acc.addSet(child.codepoints);
                if (child.isEndOfString) continue;
                astBuilder.addCharClass(child.codepoints);
                astBuilder.pushLookAheadAssertion(true);
                child.generateASTInner(astBuilder, true);
                astBuilder.popGroup();
                astBuilder.nextSequence();
            }
            acc.invert(Encodings.UTF_8);
            astBuilder.addCharClass(acc.toCodePointSet());
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                OracleDBCharClassTrieNode child = this.children.get(i);
                if (i > 0) {
                    astBuilder.nextSequence();
                }
                astBuilder.addCharClass(child.codepoints);
                if (child.needsGroupWrapper(false)) {
                    astBuilder.pushGroup();
                }
                child.generateASTInner(astBuilder, false);
                if (!child.needsGroupWrapper(false)) continue;
                astBuilder.popGroup();
            }
        }
        if (this.rootNeedsGroupWrapper(negate)) {
            astBuilder.popGroup();
        }
    }

    private void generateASTInner(RegexASTBuilder astBuilder, boolean negate) {
        for (int i = 0; i < this.children.size(); ++i) {
            OracleDBCharClassTrieNode child = this.children.get(i);
            if (i > 0) {
                astBuilder.nextSequence();
            }
            astBuilder.addCharClass(child.codepoints);
            if (child.children.isEmpty() || negate && child.isEndOfString()) continue;
            if (child.needsGroupWrapper(negate)) {
                astBuilder.pushGroup();
                child.generateASTInner(astBuilder, negate);
                astBuilder.popGroup();
                continue;
            }
            child.generateASTInner(astBuilder, negate);
        }
        if (!negate && this.isEndOfString() && !this.children.isEmpty()) {
            astBuilder.nextSequence();
            astBuilder.pushLookAheadAssertion(true);
            this.generateASTInner(astBuilder, true);
            astBuilder.popGroup();
        }
    }

    private boolean needsGroupWrapper(boolean negate) {
        return this.children.size() > 1 || !negate && this.isEndOfString() && !this.children.isEmpty();
    }

    private boolean rootNeedsGroupWrapper(boolean negate) {
        return this.needsGroupWrapper(negate) || negate && this.children.size() == 1 && !this.children.get((int)0).isEndOfString;
    }
}

