/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.algart.arrays.JArrays;
import net.algart.json.Jsons;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestriction;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestrictionFactory;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;

public final class SpherePolyhedronKindSet
implements PackingRestrictionFactory {
    public static final String APP_NAME = "sphere-polyhedra-kinds";
    private final Map<Long, List<SpherePolyhedronKind>> kindMap = new LinkedHashMap<Long, List<SpherePolyhedronKind>>();
    private final List<SpherePolyhedronKind> firstKinds = new ArrayList<SpherePolyhedronKind>();
    private final Settings settings;
    private final SpherePolyhedronKind[] kindArray;
    private final double[] probabilities;
    private final double[] probabilityLevels;

    private SpherePolyhedronKindSet(Collection<SpherePolyhedronKind> kinds, Settings settings, boolean supportFractionProbabilities) {
        Objects.requireNonNull(kinds, "Null kinds");
        Objects.requireNonNull(settings, "Null settings");
        kinds = new ArrayList<SpherePolyhedronKind>(kinds);
        if (kinds.isEmpty() && supportFractionProbabilities) {
            throw new IllegalArgumentException("No kinds (at least 1 kind required when fraction probabilities are used)");
        }
        for (SpherePolyhedronKind spherePolyhedronKind : kinds) {
            List list = this.kindMap.computeIfAbsent(spherePolyhedronKind.getId(), id -> new ArrayList());
            if (list.isEmpty()) {
                this.firstKinds.add(spherePolyhedronKind);
            }
            list.add(spherePolyhedronKind);
        }
        this.settings = settings;
        this.kindArray = new SpherePolyhedronKind[kinds.size()];
        this.probabilities = supportFractionProbabilities ? new double[kinds.size()] : null;
        this.probabilityLevels = supportFractionProbabilities ? new double[kinds.size()] : null;
        int kindIndex = 0;
        for (SpherePolyhedronKind kind : kinds) {
            this.kindArray[kindIndex++] = kind;
        }
        if (supportFractionProbabilities) {
            IntStream.range(0, this.probabilities.length).parallel().forEach(k -> {
                this.probabilities[k] = settings.fraction.mode.estimateProbability(this.kindArray[k]);
            });
            double d = 0.0;
            for (int k2 = 0; k2 < this.probabilities.length; ++k2) {
                this.probabilityLevels[k2] = d += this.probabilities[k2];
            }
            if (d == 0.0) {
                d = 1.0;
            }
            int k2 = 0;
            while (k2 < this.probabilityLevels.length) {
                int n = k2;
                this.probabilities[n] = this.probabilities[n] / d;
                int n2 = k2++;
                this.probabilityLevels[n2] = this.probabilityLevels[n2] / d;
            }
        }
    }

    public static SpherePolyhedronKindSet newEmpty() {
        return new SpherePolyhedronKindSet(Collections.emptyList(), new Settings(), false);
    }

    public static SpherePolyhedronKindSet of(Collection<SpherePolyhedronKind> kinds, Settings settings, boolean supportFractionProbabilities) {
        return new SpherePolyhedronKindSet(kinds, settings, supportFractionProbabilities);
    }

    public static SpherePolyhedronKindSet of(JsonObject json, boolean supportFractionProbabilities) {
        return SpherePolyhedronKindSet.of(SpherePolyhedronKindSet.readKinds(json), SpherePolyhedronKindSet.readSettings(json), supportFractionProbabilities);
    }

    public static List<SpherePolyhedronKind> readKinds(JsonObject json) {
        SpherePolyhedronKindSet.checkAppName(json);
        ArrayList<SpherePolyhedronKind> kinds = new ArrayList<SpherePolyhedronKind>();
        List kindsJson = Jsons.reqJsonObjects((JsonObject)json, (String)"kinds");
        for (JsonObject kindJson : kindsJson) {
            kinds.add(SpherePolyhedronKind.of(kindJson));
        }
        return kinds;
    }

    public static Settings readSettings(JsonObject json) {
        SpherePolyhedronKindSet.checkAppName(json);
        Settings settings = new Settings();
        JsonObject settingsJson = json.getJsonObject("settings");
        if (settingsJson != null) {
            settings.setToJson(settingsJson);
        }
        return settings;
    }

    public Settings settings() {
        return this.settings;
    }

    public Map<Long, List<SpherePolyhedronKind>> kindMap() {
        return Collections.unmodifiableMap(this.kindMap);
    }

    public List<SpherePolyhedronKind> allFirstKinds() {
        return Collections.unmodifiableList(this.firstKinds);
    }

    public List<SpherePolyhedronKind> allKinds() {
        return Collections.unmodifiableList(Arrays.asList(this.kindArray));
    }

    public SpherePolyhedronKind[] kindArray() {
        return (SpherePolyhedronKind[])this.kindArray.clone();
    }

    public double[] probabilities() {
        return this.probabilities == null ? null : (double[])this.probabilities.clone();
    }

    public boolean isFractionProbabilitiesSupoorted() {
        return this.probabilities != null;
    }

    public boolean contains(long id) {
        return this.kindMap.containsKey(id);
    }

    public List<SpherePolyhedronKind> getKinds(long id) {
        return this.kindMap.get(id);
    }

    public Color getFirstColor(long id, Color defaultValue) {
        List<SpherePolyhedronKind> kindList = this.kindMap.get(id);
        return kindList != null ? kindList.getFirst().getColor() : defaultValue;
    }

    public int getFirstLabel(long id, int defaultValue) {
        List<SpherePolyhedronKind> kindList = this.kindMap.get(id);
        return kindList != null ? kindList.getFirst().getLabel() : defaultValue;
    }

    public int getMinFirstLabel() {
        int result = Integer.MAX_VALUE;
        for (List<SpherePolyhedronKind> kindList : this.kindMap.values()) {
            result = Math.min(result, kindList.getFirst().getLabel());
        }
        return result;
    }

    public int getMaxFirstLabel() {
        int result = Integer.MIN_VALUE;
        for (List<SpherePolyhedronKind> kindList : this.kindMap.values()) {
            result = Math.max(result, kindList.getFirst().getLabel());
        }
        return result;
    }

    public String[] idsToFriendlyStrings(long[] kindIds) {
        Objects.requireNonNull(kindIds, "Null kind IDs array");
        return (String[])Arrays.stream(kindIds).parallel().mapToObj(SpherePolyhedronKind::idToFriendlyString).toArray(String[]::new);
    }

    public SpherePolyhedronKindSet selectKinds(String kindsList) {
        if (kindsList == null || (kindsList = kindsList.trim()).isEmpty()) {
            return this;
        }
        List<SpherePolyhedronKind> allKinds = this.allKinds();
        Collection<SpherePolyhedronKind> selectedKinds = SpherePolyhedronKind.selectKinds(kindsList, allKinds);
        if (selectedKinds.isEmpty()) {
            throw new IllegalArgumentException("No kinds \"" + kindsList + "\" in " + String.valueOf(this));
        }
        return new SpherePolyhedronKindSet(selectedKinds, this.settings, this.isFractionProbabilitiesSupoorted());
    }

    @Override
    public PackingRestriction getRecommendedPackingRestriction(SpherePolyhedrion objectToPack) {
        List<SpherePolyhedronKind> kindList = this.getKinds(objectToPack.kindId());
        return kindList == null ? PackingRestriction.NONE : kindList.getFirst().getRestrictionSet();
    }

    public Color getFirstColor(SpherePolyhedron spherePolyhedron) {
        return this.getFirstColor(spherePolyhedron.kindId(), null);
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("app", APP_NAME);
        builder.add("settings", (JsonValue)this.settings.toJson());
        List<JsonObject> kindJsons = ((Stream)Arrays.stream(this.kindArray).parallel()).map(SpherePolyhedronKind::toJson).toList();
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        kindJsons.forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        builder.add("kinds", (JsonValue)arrayBuilder.build());
        return builder.build();
    }

    public String toJsonString() {
        return Jsons.toPrettyString((JsonObject)this.toJson());
    }

    public SpherePolyhedronKind nextKind(Random random) {
        int k;
        if (!this.isFractionProbabilitiesSupoorted()) {
            throw new IllegalStateException("This kind set cannot be used for selecting random kinds: it was created without support of fraction probabilities");
        }
        double p = random.nextDouble();
        for (k = 0; k < this.probabilityLevels.length && p >= this.probabilityLevels[k]; ++k) {
        }
        if (k == this.probabilityLevels.length) {
            --k;
        }
        return this.kindArray[k];
    }

    public String toString() {
        Object[] different = this.allKinds().stream().map(SpherePolyhedronKind::getFriendlyId).distinct().toArray();
        return "sphere-polyhedra kind set of " + this.kindArray.length + " kinds (different IDs: " + JArrays.toString((Object[])different, (String)", ", (int)256) + ")";
    }

    private static void checkAppName(JsonObject json) {
        Objects.requireNonNull(json, "Null json");
        if (!APP_NAME.equals(json.getString("app", null))) {
            throw new JsonException("JSON is not a kind set of sphere-polyhedra: no \"app\": \"sphere-polyhedra-kinds\" element");
        }
    }

    public static final class Settings {
        private Fraction fraction = new Fraction();

        public Fraction getFraction() {
            return this.fraction;
        }

        public Settings setFraction(Fraction fraction) {
            this.fraction = Objects.requireNonNull(fraction);
            return this;
        }

        public Settings setToJson(JsonObject json) {
            Objects.requireNonNull(json, "Null json");
            JsonObject fractionJson = json.getJsonObject("fraction");
            if (fractionJson != null) {
                this.setFraction(new Fraction().setToJson(fractionJson));
            }
            return this;
        }

        public JsonObject toJson() {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("fraction", (JsonValue)this.fraction.toJson());
            return builder.build();
        }

        public static final class Fraction {
            private static final int NUMBER_OF_RANDOM_EXAMPLES_TO_ESTIMATE_AVERAGE_VOLUME = 4096;
            private Mode mode = Mode.NUMBER_OF_OBJECTS;

            public Mode getMode() {
                return this.mode;
            }

            public Fraction setMode(Mode mode) {
                this.mode = Objects.requireNonNull(mode, "Null mode");
                return this;
            }

            public Fraction setToJson(JsonObject json) {
                Objects.requireNonNull(json, "Null json");
                String modeName = json.getString("mode", Mode.NUMBER_OF_OBJECTS.name());
                this.setMode(Mode.fromName(modeName).orElseThrow(() -> Jsons.badValue((JsonObject)json, (String)"mode", (String)modeName, Mode.modeNames())));
                return this;
            }

            public JsonObject toJson() {
                JsonObjectBuilder builder = Json.createObjectBuilder();
                builder.add("mode", this.mode.name());
                return builder.build();
            }

            public static enum Mode {
                NUMBER_OF_OBJECTS("number"){

                    @Override
                    public double estimateProbability(SpherePolyhedronKind kind) {
                        return kind.getFraction();
                    }
                }
                ,
                SUMMARY_VOLUME("volume"){

                    @Override
                    public double estimateProbability(SpherePolyhedronKind kind) {
                        double fraction = kind.getFraction();
                        Random random = new Random(157L);
                        double summaryVolume = 0.0;
                        for (int m = 0; m < 4096; ++m) {
                            summaryVolume += kind.newSpherePolyhedrionSummaryVolume(random);
                        }
                        double averageVolume = summaryVolume / 4096.0;
                        return fraction / averageVolume;
                    }
                };

                private final String modeName;

                private Mode(String modeName) {
                    this.modeName = Objects.requireNonNull(modeName);
                }

                public abstract double estimateProbability(SpherePolyhedronKind var1);

                public static Collection<String> modeNames() {
                    return Arrays.stream(Mode.values()).map(Mode::modeName).toList();
                }

                public String modeName() {
                    return this.modeName;
                }

                public static Optional<Mode> fromName(String name) {
                    for (Mode value : Mode.values()) {
                        if (!value.name().equalsIgnoreCase(name) && !value.modeName.equalsIgnoreCase(name)) continue;
                        return Optional.of(value);
                    }
                    return Optional.empty();
                }
            }
        }
    }
}

