/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds.restrictions;

import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestriction;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class NeighbourKindRequirement
implements PackingRestriction {
    private long requiredNeighbourKindId = 0L;
    private int minimalNumberOfRequiredNeighbours = 1;

    public long getRequiredNeighbourKindId() {
        return this.requiredNeighbourKindId;
    }

    public NeighbourKindRequirement setRequiredNeighbourKindId(long requiredNeighbourKindId) {
        this.requiredNeighbourKindId = requiredNeighbourKindId;
        return this;
    }

    public int getMinimalNumberOfRequiredNeighbours() {
        return this.minimalNumberOfRequiredNeighbours;
    }

    public NeighbourKindRequirement setMinimalNumberOfRequiredNeighbours(int minimalNumberOfRequiredNeighbours) {
        if (minimalNumberOfRequiredNeighbours < 0 || minimalNumberOfRequiredNeighbours > 3) {
            throw new IllegalArgumentException("Illegal minimal number of required neighbours " + minimalNumberOfRequiredNeighbours + " (must be in 0..3 range)");
        }
        this.minimalNumberOfRequiredNeighbours = minimalNumberOfRequiredNeighbours;
        return this;
    }

    @Override
    public boolean allowFirstNeighbour(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex, long neighbourKindId) {
        return this.minimalNumberOfRequiredNeighbours <= 0 || neighbourKindId == this.requiredNeighbourKindId;
    }

    @Override
    public boolean allowAllNeighbours(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex1, long neighbourKindId1, int neighbourIndex2, long neighbourKindId2, int neighbourIndex3, long neighbourKindId3) {
        if (this.minimalNumberOfRequiredNeighbours <= 0) {
            return true;
        }
        return (neighbourKindId1 == this.requiredNeighbourKindId ? 1 : 0) + (neighbourKindId2 == this.requiredNeighbourKindId ? 1 : 0) + (neighbourKindId3 == this.requiredNeighbourKindId ? 1 : 0) >= this.minimalNumberOfRequiredNeighbours;
    }

    public String toString() {
        return "require >=" + this.minimalNumberOfRequiredNeighbours + " neighbours " + SpherePolyhedronKind.idToFriendlyString(this.requiredNeighbourKindId);
    }
}

