/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Objects;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.objects.Generatrix;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.TooLargeSpherePolyhedronException;

public final class GeneratrixSegment
extends Generatrix {
    final double x;
    final double y;
    final double z;

    private GeneratrixSegment(double x, double y, double z) {
        GeneratrixSegment.checkSegment(x, y, z, false);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static GeneratrixSegment newSegment(double x, double y, double z) throws TooLargeSpherePolyhedronException {
        return new GeneratrixSegment(x, y, z);
    }

    public static GeneratrixSegment newSegmentAlongI(Orthonormal3DBasis basis, double length) {
        Objects.requireNonNull(basis, "Null basis");
        return GeneratrixSegment.newSegment(0.5 * length * basis.ix(), 0.5 * length * basis.iy(), 0.5 * length * basis.iz());
    }

    public static GeneratrixSegment newSegmentAlongJ(Orthonormal3DBasis basis, double length) {
        Objects.requireNonNull(basis, "Null basis");
        return GeneratrixSegment.newSegment(0.5 * length * basis.jx(), 0.5 * length * basis.jy(), 0.5 * length * basis.jz());
    }

    public static GeneratrixSegment newSegmentAlongK(Orthonormal3DBasis basis, double length) {
        Objects.requireNonNull(basis, "Null basis");
        return GeneratrixSegment.newSegment(0.5 * length * basis.kx(), 0.5 * length * basis.ky(), 0.5 * length * basis.kz());
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double halfLength() {
        return Orthonormal3DBasis.length((double)this.x, (double)this.y, (double)this.z);
    }

    public String toString() {
        return "generatrix segment (" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    @Override
    void add(GeneratrixSet.Builder builder) {
        builder.addSegment(this.x, this.y, this.z, false);
    }

    static void checkSegment(double x, double y, double z, boolean weakenedCheck) {
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException("NaN x segment component");
        }
        if (Double.isNaN(y)) {
            throw new IllegalArgumentException("NaN y segment component");
        }
        if (Double.isNaN(z)) {
            throw new IllegalArgumentException("NaN z segment component");
        }
        double lengthSqr = x * x + y * y + z * z;
        double d = weakenedCheck ? 1.0E80 : 1.0E40;
        if (lengthSqr > d) {
            throw new TooLargeSpherePolyhedronException("Too large segment (" + x + ", " + y + ", " + z + "): its length " + Math.sqrt(lengthSqr) + " > 1.0E20 (allowed maximum" + (weakenedCheck ? " for internal needs)" : ")"));
        }
    }
}

