/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Arrays;
import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.arrays.TooLargeArrayException;
import net.algart.math.MutableInt128;
import net.algart.math.Range;
import net.algart.math.geometry.Collinearity;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;

class KernelPolyhedron {
    private static final int INITIAL_MAX_NUMBER_OF_VERTICES = 16;
    private static final int INITIAL_MAX_NUMBER_OF_EDGES = 32;
    private static final int INITIAL_MAX_NUMBER_OF_FACETS = 16;
    private static final long[] SINGLE_ZERO_VERTEX = new long[]{0L, 0L, 0L};
    private static final byte[] SINGLE_ZERO_BYTE = new byte[]{0};
    static final int EXACTLY_DEGENERATED_FLAG = 1;
    static final int ALMOST_DEGENERATED_FLAG = 2;
    private static final double DEGENERATED_EDGES_MAXIMAL_EPSILON = 1.0E-5;
    GeneratrixSet generatrixSet;
    private double xyzScale;
    private double xyzScaleSqr;
    private double xyzScaleCube;
    double generatrixRadius;
    double generatrixRadiusSquare;
    double generatrixRadiusInv;
    int numberOfVertices;
    int numberOfEdges;
    int numberOfFacets;
    int numberOfExactlyDegeneratedEdges;
    int numberOfExactlyDegeneratedVertices;
    int numberOfAlmostDegeneratedEdges;
    int numberOfAlmostDegeneratedVertices;
    double kernelVolume;
    double kernelSurfaceArea;
    double summaryLengthOfEdges;
    double summaryLengthOfGeneratrixSegments;
    long[] verticesXYZ = SINGLE_ZERO_VERTEX;
    int[] edgesGeneratrixSegmentIndexes = JArrays.EMPTY_INTS;
    int[] edgesVertices = JArrays.EMPTY_INTS;
    boolean[] edgesOrderedAlongGeneratrix = JArrays.EMPTY_BOOLEANS;
    int[] edgesFacets = JArrays.EMPTY_INTS;
    int[] facetsVertices = JArrays.EMPTY_INTS;
    int[] facetsEdges = JArrays.EMPTY_INTS;
    long[] facetsNormals = JArrays.EMPTY_LONGS;
    double[] facetsAreas = JArrays.EMPTY_DOUBLES;
    double[] facetsEquations = JArrays.EMPTY_DOUBLES;
    double[] facetsPN = JArrays.EMPTY_DOUBLES;
    double[] facetsQN = JArrays.EMPTY_DOUBLES;
    double[] generatrixSegmentsIJK = JArrays.EMPTY_DOUBLES;
    byte[] degeneratedEdges = JArrays.EMPTY_BYTES;
    byte[] degeneratedVertices = SINGLE_ZERO_BYTE;
    double minCenteredX;
    double maxCenteredX;
    double minCenteredY;
    double maxCenteredY;
    double minCenteredZ;
    double maxCenteredZ;
    double containingSphereRadius;
    double containingSphereRadiusInv;
    private int maxNumberOfVertices = -1;
    private int maxNumberOfEdges = -1;
    private int maxNumberOfFacets = -1;
    private byte[] vertexCodes = JArrays.EMPTY_BYTES;
    private byte[] facetCodes = JArrays.EMPTY_BYTES;
    private int[] newEdgesIncidentToVertex = JArrays.EMPTY_INTS;
    private int[] edgesCompanionIndex = JArrays.EMPTY_INTS;

    public Range rangeCenteredAlongDirection(double dx, double dy, double dz) {
        double min = 0.0;
        double max = 0.0;
        int kV = 0;
        int dispV = 0;
        while (kV < this.numberOfVertices) {
            double x = this.xyzScale * (double)this.verticesXYZ[dispV];
            double y = this.xyzScale * (double)this.verticesXYZ[dispV + 1];
            double z = this.xyzScale * (double)this.verticesXYZ[dispV + 2];
            double t = x * dx + y * dy + z * dz;
            min = Math.min(t, min);
            max = Math.max(t, max);
            ++kV;
            dispV += 3;
        }
        return Range.of((double)(min - this.generatrixRadius), (double)(max + this.generatrixRadius));
    }

    KernelPolyhedron() {
        this.generatrixSet = new GeneratrixSet();
        this.rebuild();
    }

    final void clear() {
        this.setGeneratrixSet(GeneratrixSet.ZERO);
    }

    KernelPolyhedron setGeneratrixSet(GeneratrixSet generatrixSet) {
        Objects.requireNonNull(generatrixSet, "Null generatrix set");
        this.generatrixSet.setTo(generatrixSet);
        this.xyzScale = generatrixSet.scale;
        this.xyzScaleSqr = this.xyzScale * this.xyzScale;
        this.xyzScaleCube = this.xyzScaleSqr * this.xyzScale;
        this.generatrixRadius = generatrixSet.generatrixSphereRadius();
        this.generatrixRadiusSquare = this.generatrixRadius * this.generatrixRadius;
        this.generatrixRadiusInv = 1.0 / this.generatrixRadius;
        this.numberOfVertices = 1;
        this.verticesXYZ[0] = 0L;
        this.verticesXYZ[1] = 0L;
        this.verticesXYZ[2] = 0L;
        this.degeneratedVertices[0] = 0;
        this.numberOfEdges = 0;
        this.numberOfFacets = 0;
        this.kernelVolume = 0.0;
        this.kernelSurfaceArea = 0.0;
        this.summaryLengthOfEdges = 0.0;
        this.summaryLengthOfGeneratrixSegments = 0.0;
        if (generatrixSet.numberOfGeneratrixSegments > 0) {
            this.ensureCapacity(16, 32, 16, true);
            this.minkowskiAddGeneratrixSet();
            this.completeMinkowskiAdding();
        } else {
            this.calculateMinMax();
        }
        return this;
    }

    KernelPolyhedron setTo(KernelPolyhedron other) {
        Objects.requireNonNull(other, "Null other");
        this.generatrixSet.setTo(other.generatrixSet);
        this.xyzScale = other.xyzScale;
        this.xyzScaleSqr = other.xyzScaleSqr;
        this.xyzScaleCube = other.xyzScaleCube;
        this.generatrixRadius = other.generatrixRadius;
        this.generatrixRadiusSquare = other.generatrixRadiusSquare;
        this.generatrixRadiusInv = other.generatrixRadiusInv;
        this.ensureCapacity(other.numberOfVertices, other.numberOfEdges, other.numberOfFacets, false);
        this.numberOfVertices = other.numberOfVertices;
        this.numberOfEdges = other.numberOfEdges;
        this.numberOfFacets = other.numberOfFacets;
        this.numberOfExactlyDegeneratedEdges = other.numberOfExactlyDegeneratedEdges;
        this.numberOfExactlyDegeneratedVertices = other.numberOfExactlyDegeneratedVertices;
        this.numberOfAlmostDegeneratedEdges = other.numberOfAlmostDegeneratedEdges;
        this.numberOfAlmostDegeneratedVertices = other.numberOfAlmostDegeneratedVertices;
        this.kernelVolume = other.kernelVolume;
        this.kernelSurfaceArea = other.kernelSurfaceArea;
        this.summaryLengthOfEdges = other.summaryLengthOfEdges;
        this.summaryLengthOfGeneratrixSegments = other.summaryLengthOfGeneratrixSegments;
        this.ensurePostprocessCapacity();
        System.arraycopy(other.verticesXYZ, 0, this.verticesXYZ, 0, 3 * this.numberOfVertices);
        System.arraycopy(other.edgesGeneratrixSegmentIndexes, 0, this.edgesGeneratrixSegmentIndexes, 0, this.numberOfEdges);
        System.arraycopy(other.edgesVertices, 0, this.edgesVertices, 0, 2 * this.numberOfEdges);
        System.arraycopy(other.edgesOrderedAlongGeneratrix, 0, this.edgesOrderedAlongGeneratrix, 0, this.numberOfEdges);
        System.arraycopy(other.facetsVertices, 0, this.facetsVertices, 0, 4 * this.numberOfFacets);
        System.arraycopy(other.facetsEdges, 0, this.facetsEdges, 0, 4 * this.numberOfFacets);
        System.arraycopy(other.facetsNormals, 0, this.facetsNormals, 0, 3 * this.numberOfFacets);
        System.arraycopy(other.facetsAreas, 0, this.facetsAreas, 0, this.numberOfFacets);
        System.arraycopy(other.degeneratedVertices, 0, this.degeneratedVertices, 0, this.numberOfVertices);
        System.arraycopy(other.edgesFacets, 0, this.edgesFacets, 0, 2 * this.numberOfEdges);
        System.arraycopy(other.degeneratedEdges, 0, this.degeneratedEdges, 0, this.numberOfEdges);
        System.arraycopy(other.facetsEquations, 0, this.facetsEquations, 0, 4 * this.numberOfFacets);
        System.arraycopy(other.facetsPN, 0, this.facetsPN, 0, 3 * this.numberOfFacets);
        System.arraycopy(other.facetsQN, 0, this.facetsQN, 0, 3 * this.numberOfFacets);
        System.arraycopy(other.generatrixSegmentsIJK, 0, this.generatrixSegmentsIJK, 0, 9 * this.generatrixSet.numberOfGeneratrixSegments);
        this.minCenteredX = other.minCenteredX;
        this.maxCenteredX = other.maxCenteredX;
        this.minCenteredY = other.minCenteredY;
        this.maxCenteredY = other.maxCenteredY;
        this.minCenteredZ = other.minCenteredZ;
        this.maxCenteredZ = other.maxCenteredZ;
        this.containingSphereRadius = other.containingSphereRadius;
        this.containingSphereRadiusInv = other.containingSphereRadiusInv;
        return this;
    }

    final void rebuild() {
        this.setGeneratrixSet(this.generatrixSet);
    }

    final void compactForExternalUsage() {
        if (this.maxNumberOfVertices > this.numberOfVertices) {
            this.verticesXYZ = Arrays.copyOf(this.verticesXYZ, 3 * this.numberOfVertices);
        }
        if (this.maxNumberOfEdges > this.numberOfEdges) {
            this.edgesGeneratrixSegmentIndexes = Arrays.copyOf(this.edgesGeneratrixSegmentIndexes, this.numberOfEdges);
            this.edgesVertices = Arrays.copyOf(this.edgesVertices, 2 * this.numberOfEdges);
            this.edgesOrderedAlongGeneratrix = Arrays.copyOf(this.edgesOrderedAlongGeneratrix, this.numberOfEdges);
        }
        if (this.maxNumberOfFacets > this.numberOfFacets) {
            this.facetsVertices = Arrays.copyOf(this.facetsVertices, 4 * this.numberOfFacets);
            this.facetsEdges = Arrays.copyOf(this.facetsEdges, 4 * this.numberOfFacets);
            this.facetsNormals = Arrays.copyOf(this.facetsNormals, 3 * this.numberOfFacets);
            this.facetsAreas = Arrays.copyOf(this.facetsAreas, this.numberOfFacets);
        }
        if (this.degeneratedVertices.length > this.numberOfVertices) {
            this.degeneratedVertices = Arrays.copyOf(this.degeneratedVertices, this.numberOfVertices);
        }
        assert (this.edgesFacets.length == 2 * this.degeneratedEdges.length);
        if (this.degeneratedEdges.length > this.numberOfEdges) {
            this.edgesFacets = Arrays.copyOf(this.edgesFacets, 2 * this.numberOfEdges);
            this.degeneratedEdges = Arrays.copyOf(this.degeneratedEdges, this.numberOfEdges);
        }
        assert (this.facetsPN.length == 3 * (this.facetsEquations.length / 4));
        assert (this.facetsQN.length == this.facetsPN.length);
        if (this.facetsEquations.length > 4 * this.numberOfFacets) {
            this.facetsEquations = Arrays.copyOf(this.facetsEquations, 4 * this.numberOfFacets);
            this.facetsPN = Arrays.copyOf(this.facetsPN, 3 * this.numberOfFacets);
            this.facetsQN = Arrays.copyOf(this.facetsQN, 3 * this.numberOfFacets);
        }
        if (this.generatrixSegmentsIJK.length > 9 * this.generatrixSet.numberOfGeneratrixSegments) {
            this.generatrixSegmentsIJK = Arrays.copyOf(this.generatrixSegmentsIJK, 9 * this.generatrixSet.numberOfGeneratrixSegments);
        }
        this.freeWorkMemoryForMinkowskiAdding();
        this.generatrixSet.compactForExternalUsage();
    }

    private void minkowskiAddGeneratrixSet() {
        int n = this.generatrixSet.numberOfGeneratrixSegments;
        for (int k = 0; k < n; ++k) {
            this.minkowskiAddSegment(k);
        }
    }

    private void completeMinkowskiAdding() {
        this.ensurePostprocessCapacity();
        this.calculateEdgesFacets();
        this.assertForIncorrectEdges();
        this.calculateFacetsEquations();
        this.calculateGoodBases();
        this.calculateDegenerated();
        this.calculateMinMax();
    }

    private void minkowskiAddSegment(int generatrixIndex) {
        int generatrixX = this.generatrixSet.intXYZ[3 * generatrixIndex];
        int generatrixY = this.generatrixSet.intXYZ[3 * generatrixIndex + 1];
        int generatrixZ = this.generatrixSet.intXYZ[3 * generatrixIndex + 2];
        double generatrixSegmentLength = 2.0 * this.generatrixSet.segmentHalfLengths[generatrixIndex];
        assert (generatrixSegmentLength > 0.0);
        long firstCoplanarNormalX = 0L;
        long firstCoplanarNormalY = 0L;
        long firstCoplanarNormalZ = 0L;
        MutableInt128 workInt128 = new MutableInt128();
        boolean coplanarToSomeFacets = false;
        Arrays.fill(this.vertexCodes, 0, this.numberOfVertices, (byte)0);
        Arrays.fill(this.facetCodes, 0, this.numberOfFacets, (byte)0);
        int kF = 0;
        int dispF = 0;
        int dispNormals = 0;
        while (kF < this.numberOfFacets) {
            boolean facetMovedForward;
            long normalX = this.facetsNormals[dispNormals];
            long normalY = this.facetsNormals[dispNormals + 1];
            long normalZ = this.facetsNormals[dispNormals + 2];
            workInt128.setToLongIntProduct(normalX, generatrixX);
            workInt128.addLongIntProduct(normalY, generatrixY);
            workInt128.addLongIntProduct(normalZ, generatrixZ);
            if (!workInt128.isZero()) {
                facetMovedForward = workInt128.isPositive();
            } else {
                if (!coplanarToSomeFacets) {
                    coplanarToSomeFacets = true;
                    firstCoplanarNormalX = normalX;
                    firstCoplanarNormalY = normalY;
                    firstCoplanarNormalZ = normalZ;
                    facetMovedForward = true;
                } else {
                    facetMovedForward = Collinearity.alsoCodirectional((long)normalX, (long)normalY, (long)normalZ, (long)firstCoplanarNormalX, (long)firstCoplanarNormalY, (long)firstCoplanarNormalZ);
                }
                int n = kF;
                this.facetCodes[n] = (byte)(this.facetCodes[n] | 8);
            }
            if (facetMovedForward) {
                int n = kF;
                this.facetCodes[n] = (byte)(this.facetCodes[n] | 4);
                dispE = 2 * this.facetsEdges[dispF];
                int n2 = this.edgesVertices[dispE];
                this.vertexCodes[n2] = (byte)(this.vertexCodes[n2] | 2);
                int n3 = this.edgesVertices[dispE + 1];
                this.vertexCodes[n3] = (byte)(this.vertexCodes[n3] | 2);
                dispE = 2 * this.facetsEdges[dispF + 2];
                int n4 = this.edgesVertices[dispE];
                this.vertexCodes[n4] = (byte)(this.vertexCodes[n4] | 2);
                int n5 = this.edgesVertices[dispE + 1];
                this.vertexCodes[n5] = (byte)(this.vertexCodes[n5] | 2);
            } else {
                dispE = 2 * this.facetsEdges[dispF];
                int n = this.edgesVertices[dispE];
                this.vertexCodes[n] = (byte)(this.vertexCodes[n] | 1);
                int n6 = this.edgesVertices[dispE + 1];
                this.vertexCodes[n6] = (byte)(this.vertexCodes[n6] | 1);
                dispE = 2 * this.facetsEdges[dispF + 2];
                int n7 = this.edgesVertices[dispE];
                this.vertexCodes[n7] = (byte)(this.vertexCodes[n7] | 1);
                int n8 = this.edgesVertices[dispE + 1];
                this.vertexCodes[n8] = (byte)(this.vertexCodes[n8] | 1);
            }
            ++kF;
            dispF += 4;
            dispNormals += 3;
        }
        if (this.numberOfFacets == 0) {
            assert (this.numberOfVertices <= 2);
            Arrays.fill(this.vertexCodes, 0, this.numberOfVertices, (byte)3);
        }
        int newNumberOfVertices = this.numberOfVertices;
        int newDispVXYZ = 3 * newNumberOfVertices;
        int newNumberOfEdges = this.numberOfEdges;
        int newDispE = 2 * newNumberOfEdges;
        Arrays.fill(this.newEdgesIncidentToVertex, 0, this.numberOfVertices, -1);
        int kV = 0;
        int dispV = 0;
        while (kV < this.numberOfVertices) {
            switch (this.vertexCodes[kV]) {
                case 1: {
                    int n = dispV;
                    this.verticesXYZ[n] = this.verticesXYZ[n] - (long)generatrixX;
                    int n9 = dispV + 1;
                    this.verticesXYZ[n9] = this.verticesXYZ[n9] - (long)generatrixY;
                    int n10 = dispV + 2;
                    this.verticesXYZ[n10] = this.verticesXYZ[n10] - (long)generatrixZ;
                    break;
                }
                case 2: {
                    int n = dispV;
                    this.verticesXYZ[n] = this.verticesXYZ[n] + (long)generatrixX;
                    int n11 = dispV + 1;
                    this.verticesXYZ[n11] = this.verticesXYZ[n11] + (long)generatrixY;
                    int n12 = dispV + 2;
                    this.verticesXYZ[n12] = this.verticesXYZ[n12] + (long)generatrixZ;
                    break;
                }
                case 3: {
                    this.ensureCapacity(newNumberOfVertices + 1, newNumberOfEdges + 1, 0, true);
                    long x = this.verticesXYZ[dispV];
                    long y = this.verticesXYZ[dispV + 1];
                    long z = this.verticesXYZ[dispV + 2];
                    this.verticesXYZ[newDispVXYZ] = x + (long)generatrixX;
                    this.verticesXYZ[dispV] = x - (long)generatrixX;
                    this.verticesXYZ[newDispVXYZ + 1] = y + (long)generatrixY;
                    this.verticesXYZ[dispV + 1] = y - (long)generatrixY;
                    this.verticesXYZ[newDispVXYZ + 2] = z + (long)generatrixZ;
                    this.verticesXYZ[dispV + 2] = z - (long)generatrixZ;
                    this.edgesVertices[newDispE] = kV;
                    this.edgesVertices[newDispE + 1] = newNumberOfVertices++;
                    this.edgesGeneratrixSegmentIndexes[newNumberOfEdges] = generatrixIndex;
                    this.edgesOrderedAlongGeneratrix[newNumberOfEdges] = true;
                    this.newEdgesIncidentToVertex[kV] = newNumberOfEdges++;
                    newDispVXYZ += 3;
                    newDispE += 2;
                    this.summaryLengthOfEdges += generatrixSegmentLength;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Impossible");
                }
            }
            ++kV;
            dispV += 3;
        }
        int kE = 0;
        int dispE = 0;
        while (kE < this.numberOfEdges) {
            int v1 = this.edgesVertices[dispE];
            int v2 = this.edgesVertices[dispE + 1];
            if (this.vertexCodes[v1] == 3 && this.vertexCodes[v2] == 2) {
                this.edgesVertices[dispE] = this.edgesVertices[2 * this.newEdgesIncidentToVertex[v1] + 1];
            } else if (this.vertexCodes[v1] == 2 && this.vertexCodes[v2] == 3) {
                this.edgesVertices[dispE + 1] = this.edgesVertices[2 * this.newEdgesIncidentToVertex[v2] + 1];
            }
            ++kE;
            dispE += 2;
        }
        int newNumberOfFacets = this.numberOfFacets;
        int newDispF = this.numberOfFacets * 4;
        int newDispNormals = this.numberOfFacets * 3;
        for (int kE2 = 0; kE2 < this.numberOfEdges; ++kE2) {
            this.edgesCompanionIndex[kE2] = kE2;
        }
        int kF2 = 0;
        int dispF2 = 0;
        while (kF2 < this.numberOfFacets) {
            if ((this.facetCodes[kF2] & 4) == 0) {
                for (int k = 0; k < 4; ++k) {
                    int bifurcatedEdgeGeneratrixSegmentIndex;
                    int v1 = this.facetsVertices[dispF2 + k];
                    int v2 = this.facetsVertices[dispF2 + (k + 1 & 3)];
                    if (v1 == v2) {
                        throw new AssertionError((Object)("v1 = v2 = " + v1 + " for facet #" + kF2 + "Generatrix set: " + String.valueOf(this.generatrixSet)));
                    }
                    if (this.vertexCodes[v1] != 3 || this.vertexCodes[v2] != 3) continue;
                    assert (v1 < this.numberOfVertices);
                    assert (v2 < this.numberOfVertices);
                    this.ensureCapacity(0, newNumberOfEdges + 1, newNumberOfFacets + 1, true);
                    int oldEdge = this.facetsEdges[dispF2 + k];
                    int newlyAddedEdge1 = this.newEdgesIncidentToVertex[v1];
                    assert (newlyAddedEdge1 != -1);
                    assert (newlyAddedEdge1 >= this.numberOfEdges);
                    int newlyAddedVertex1 = this.edgesVertices[2 * newlyAddedEdge1 + 1];
                    assert (newlyAddedVertex1 >= this.numberOfVertices) : newlyAddedVertex1 + " < " + this.numberOfVertices;
                    assert (newlyAddedVertex1 != v1) : newlyAddedEdge1 + ", " + v1;
                    assert (newlyAddedVertex1 != v2) : newlyAddedEdge1 + ", " + v2;
                    int newlyAddedEdge2 = this.newEdgesIncidentToVertex[v2];
                    assert (newlyAddedEdge2 != -1);
                    assert (newlyAddedEdge2 >= this.numberOfEdges);
                    int newlyAddedVertex2 = this.edgesVertices[2 * newlyAddedEdge2 + 1];
                    assert (newlyAddedVertex2 >= this.numberOfVertices) : newlyAddedVertex2 + " < " + this.numberOfVertices;
                    assert (newlyAddedVertex2 >= this.numberOfVertices);
                    assert (newlyAddedVertex1 != newlyAddedVertex2) : newlyAddedVertex1;
                    assert (newDispE == newNumberOfEdges << 1);
                    this.edgesVertices[newDispE] = newlyAddedVertex1;
                    this.edgesVertices[newDispE + 1] = newlyAddedVertex2;
                    this.edgesGeneratrixSegmentIndexes[newNumberOfEdges] = bifurcatedEdgeGeneratrixSegmentIndex = this.edgesGeneratrixSegmentIndexes[oldEdge];
                    int firstVertexInOldEdge = this.edgesVertices[2 * oldEdge];
                    if (firstVertexInOldEdge == v1) {
                        assert (this.edgesVertices[2 * oldEdge + 1] == v2);
                        this.edgesOrderedAlongGeneratrix[newNumberOfEdges] = this.edgesOrderedAlongGeneratrix[oldEdge];
                    } else {
                        assert (firstVertexInOldEdge == v2);
                        assert (this.edgesVertices[2 * oldEdge + 1] == v1);
                        this.edgesOrderedAlongGeneratrix[newNumberOfEdges] = !this.edgesOrderedAlongGeneratrix[oldEdge];
                    }
                    this.facetsEdges[newDispF] = oldEdge;
                    this.facetsEdges[newDispF + 1] = newlyAddedEdge1;
                    this.facetsEdges[newDispF + 2] = newNumberOfEdges;
                    this.facetsEdges[newDispF + 3] = newlyAddedEdge2;
                    this.facetsVertices[newDispF] = v2;
                    this.facetsVertices[newDispF + 1] = v1;
                    this.facetsVertices[newDispF + 2] = newlyAddedVertex1;
                    this.facetsVertices[newDispF + 3] = newlyAddedVertex2;
                    int dispV1 = 3 * v1;
                    int dispV2 = 3 * v2;
                    long eX = this.verticesXYZ[dispV1] - this.verticesXYZ[dispV2];
                    long eY = this.verticesXYZ[dispV1 + 1] - this.verticesXYZ[dispV2 + 1];
                    long eZ = this.verticesXYZ[dispV1 + 2] - this.verticesXYZ[dispV2 + 2];
                    assert ((eX & 1L) == 0L && (eY & 1L) == 0L && (eZ & 1L) == 0L) : "Illegal building vertices: edge vector must be even (it is doubled generatrix segment)";
                    long eXHalf = eX >> 1;
                    long eZHalf = eZ >> 1;
                    long eYHalf = eY >> 1;
                    assert (eXHalf == (long)((int)eXHalf) && eYHalf == (long)((int)eYHalf) && eZHalf == (long)((int)eZHalf)) : "Illegal building vertices: too large edge vector (it is doubled generatrix segment)";
                    long normalX = eYHalf * (long)generatrixZ - eZHalf * (long)generatrixY;
                    long normalY = eZHalf * (long)generatrixX - eXHalf * (long)generatrixZ;
                    long normalZ = eXHalf * (long)generatrixY - eYHalf * (long)generatrixX;
                    if (normalX == 0L && normalY == 0L && normalZ == 0L) {
                        throw new AssertionError((Object)"Collinear segments found (impossible in a correct GeneratrixSet)");
                    }
                    workInt128.setToLongSqr(normalX);
                    workInt128.addLongSqr(normalY);
                    workInt128.addLongSqr(normalZ);
                    double area = 4.0 * this.xyzScaleSqr * StrictMath.sqrt(workInt128.toDouble());
                    this.facetsNormals[newDispNormals] = normalX;
                    this.facetsNormals[newDispNormals + 1] = normalY;
                    this.facetsNormals[newDispNormals + 2] = normalZ;
                    this.facetsAreas[newNumberOfFacets] = area;
                    if (area == 0.0) {
                        throw new AssertionError((Object)("Zero area! (" + normalX + ", " + normalY + ", " + normalZ + ")"));
                    }
                    this.kernelSurfaceArea += area;
                    this.edgesCompanionIndex[oldEdge] = newNumberOfEdges++;
                    newDispE += 2;
                    this.summaryLengthOfEdges += 2.0 * this.generatrixSet.segmentHalfLengths[bifurcatedEdgeGeneratrixSegmentIndex];
                    ++newNumberOfFacets;
                    newDispF += 4;
                    newDispNormals += 3;
                }
            }
            ++kF2;
            dispF2 += 4;
        }
        kF2 = 0;
        dispF2 = 0;
        int dispNormals2 = 0;
        while (kF2 < this.numberOfFacets) {
            if ((this.facetCodes[kF2] & 4) != 0) {
                for (int k = 0; k < 4; ++k) {
                    int kE3 = this.newEdgesIncidentToVertex[this.facetsVertices[dispF2 + k]];
                    if (kE3 == -1) continue;
                    this.facetsVertices[dispF2 + k] = this.edgesVertices[2 * kE3 + 1];
                }
                this.facetsEdges[dispF2] = this.edgesCompanionIndex[this.facetsEdges[dispF2]];
                this.facetsEdges[dispF2 + 1] = this.edgesCompanionIndex[this.facetsEdges[dispF2 + 1]];
                this.facetsEdges[dispF2 + 2] = this.edgesCompanionIndex[this.facetsEdges[dispF2 + 2]];
                this.facetsEdges[dispF2 + 3] = this.edgesCompanionIndex[this.facetsEdges[dispF2 + 3]];
                double normalX = this.facetsNormals[dispNormals2];
                double normalY = this.facetsNormals[dispNormals2 + 1];
                double normalZ = this.facetsNormals[dispNormals2 + 2];
                this.kernelVolume += 8.0 * this.xyzScaleCube * (normalX * (double)generatrixX + normalY * (double)generatrixY + normalZ * (double)generatrixZ);
            }
            ++kF2;
            dispF2 += 4;
            dispNormals2 += 3;
        }
        assert (newDispVXYZ == 3 * newNumberOfVertices);
        assert (newDispE == 2 * newNumberOfEdges);
        assert (newDispF == 4 * newNumberOfFacets);
        assert (newDispNormals == 3 * newNumberOfFacets);
        if (this.numberOfVertices == 2) {
            assert (this.numberOfEdges == 1);
            assert (this.numberOfFacets == 0);
            assert (newNumberOfEdges == 3);
            assert (newNumberOfVertices == 4);
            this.ensureCapacity(0, newNumberOfEdges + 1, newNumberOfFacets + 2, true);
            this.edgesVertices[newDispE] = 2;
            this.edgesVertices[newDispE + 1] = 3;
            this.edgesGeneratrixSegmentIndexes[newNumberOfEdges] = this.edgesGeneratrixSegmentIndexes[0];
            this.edgesOrderedAlongGeneratrix[newNumberOfEdges] = this.edgesOrderedAlongGeneratrix[0];
            ++newNumberOfEdges;
            this.summaryLengthOfEdges += 2.0 * this.generatrixSet.segmentHalfLengths[this.edgesGeneratrixSegmentIndexes[0]];
            this.facetsEdges[newDispF] = 0;
            this.facetsEdges[newDispF + 1] = 1;
            this.facetsEdges[newDispF + 2] = 3;
            this.facetsEdges[newDispF + 3] = 2;
            this.facetsVertices[newDispF] = 1;
            this.facetsVertices[newDispF + 1] = 0;
            this.facetsVertices[newDispF + 2] = 2;
            this.facetsVertices[newDispF + 3] = 3;
            long eXHalf = this.verticesXYZ[0] - this.verticesXYZ[3] >> 1;
            long eYHalf = this.verticesXYZ[1] - this.verticesXYZ[4] >> 1;
            long eZHalf = this.verticesXYZ[2] - this.verticesXYZ[5] >> 1;
            long normalX = eYHalf * (long)generatrixZ - eZHalf * (long)generatrixY;
            long normalY = eZHalf * (long)generatrixX - eXHalf * (long)generatrixZ;
            long normalZ = eXHalf * (long)generatrixY - eYHalf * (long)generatrixX;
            if (normalX == 0L && normalY == 0L && normalZ == 0L) {
                throw new AssertionError((Object)"Collinear segments found (impossible in a correct GeneratrixSet)");
            }
            double area = 4.0 * this.xyzScaleSqr * Orthonormal3DBasis.length((double)normalX, (double)normalY, (double)normalZ);
            this.facetsNormals[newDispNormals] = normalX;
            this.facetsNormals[newDispNormals + 1] = normalY;
            this.facetsNormals[newDispNormals + 2] = normalZ;
            this.facetsAreas[newNumberOfFacets] = area;
            this.kernelSurfaceArea += area;
            ++newNumberOfFacets;
            newDispNormals += 3;
            this.facetsEdges[newDispF += 4] = 0;
            this.facetsEdges[newDispF + 1] = 2;
            this.facetsEdges[newDispF + 2] = 3;
            this.facetsEdges[newDispF + 3] = 1;
            this.facetsVertices[newDispF] = 0;
            this.facetsVertices[newDispF + 1] = 1;
            this.facetsVertices[newDispF + 2] = 3;
            this.facetsVertices[newDispF + 3] = 2;
            this.facetsNormals[newDispNormals] = -this.facetsNormals[0];
            this.facetsNormals[newDispNormals + 1] = -this.facetsNormals[1];
            this.facetsNormals[newDispNormals + 2] = -this.facetsNormals[2];
            this.facetsAreas[newNumberOfFacets] = area;
            this.kernelSurfaceArea += area;
            ++newNumberOfFacets;
        }
        this.summaryLengthOfGeneratrixSegments += generatrixSegmentLength;
        this.numberOfFacets = newNumberOfFacets;
        this.numberOfEdges = newNumberOfEdges;
        this.numberOfVertices = newNumberOfVertices;
        if (this.numberOfVertices % 2 != 0) {
            throw new AssertionError((Object)("Odd number of vertices: " + this.numberOfVertices + "; generatrix set: " + String.valueOf(this.generatrixSet)));
        }
        if (this.numberOfEdges > 1 && this.numberOfEdges % 2 != 0) {
            throw new AssertionError((Object)("Odd number of edges: " + this.numberOfEdges + "; generatrix set: " + String.valueOf(this.generatrixSet)));
        }
        if (this.numberOfFacets % 2 != 0) {
            throw new AssertionError((Object)("Odd number of facets: " + this.numberOfFacets + "; generatrix set: " + String.valueOf(this.generatrixSet)));
        }
        if (this.numberOfEdges > 1 && this.numberOfVertices + this.numberOfFacets - this.numberOfEdges != 2) {
            throw new AssertionError((Object)("Euler's polyhedron formula violated: V = " + this.numberOfVertices + ", F = " + this.numberOfFacets + ", E = " + this.numberOfEdges + "; generatrix set: " + String.valueOf(this.generatrixSet)));
        }
    }

    private void calculateEdgesFacets() {
        Arrays.fill(this.edgesFacets, 0, 2 * this.numberOfEdges, -1);
        int kF = 0;
        int dispF = 0;
        while (kF < this.numberOfFacets) {
            for (int k = 0; k < 4; ++k) {
                int f;
                int dispE = 2 * this.facetsEdges[dispF + k];
                int n = f = this.edgesVertices[dispE] != this.facetsVertices[dispF + k] ? 2 * kF + 1 : 2 * kF;
                if (this.edgesFacets[dispE] == -1) {
                    this.edgesFacets[dispE] = f;
                    continue;
                }
                this.edgesFacets[dispE + 1] = f;
            }
            ++kF;
            dispF += 4;
        }
        int kE = 0;
        int dispE = 0;
        while (kE < this.numberOfEdges) {
            int f1 = this.edgesFacets[dispE];
            int f2 = this.edgesFacets[dispE + 1];
            if (f1 != -1 && f2 != -1) {
                boolean needToExchange = (f1 & 1) != 0;
                f1 >>>= 1;
                f2 >>>= 1;
                if (needToExchange) {
                    this.edgesFacets[dispE] = f2;
                    this.edgesFacets[dispE + 1] = f1;
                } else {
                    this.edgesFacets[dispE] = f1;
                    this.edgesFacets[dispE + 1] = f2;
                }
            }
            ++kE;
            dispE += 2;
        }
    }

    private void assertForIncorrectEdges() {
        int kE = 0;
        int dispE = 0;
        while (kE < this.numberOfEdges) {
            int v1 = this.edgesVertices[this.edgesOrderedAlongGeneratrix[kE] ? dispE : dispE + 1];
            int v2 = this.edgesVertices[this.edgesOrderedAlongGeneratrix[kE] ? dispE + 1 : dispE];
            int dispV1 = 3 * v1;
            int dispV2 = 3 * v2;
            long eX = this.verticesXYZ[dispV2] - this.verticesXYZ[dispV1];
            long eY = this.verticesXYZ[dispV2 + 1] - this.verticesXYZ[dispV1 + 1];
            long eZ = this.verticesXYZ[dispV2 + 2] - this.verticesXYZ[dispV1 + 2];
            int generatrixIndex = this.edgesGeneratrixSegmentIndexes[kE];
            long gX = 2L * (long)this.generatrixSet.intXYZ[3 * generatrixIndex];
            long gY = 2L * (long)this.generatrixSet.intXYZ[3 * generatrixIndex + 1];
            long gZ = 2L * (long)this.generatrixSet.intXYZ[3 * generatrixIndex + 2];
            if (eX != gX || eY != gY || eZ != gZ) {
                throw new AssertionError((Object)("Inconsistence in building sphere-polyhedron: edge #" + kE + "=(" + eX + "," + eY + "," + eZ + ") is not equal to doubled generatrix segment #" + generatrixIndex + "=(" + gX + "," + gY + "," + gZ + ")"));
            }
            ++kE;
            dispE += 2;
        }
    }

    private void calculateFacetsEquations() {
        MutableInt128 tripleProduct = new MutableInt128();
        int kF = 0;
        int dispF = 0;
        int dispNormals = 0;
        while (kF < this.numberOfFacets) {
            double lengthAB;
            long longNormalX = this.facetsNormals[dispNormals];
            double normalX = longNormalX;
            long longNormalY = this.facetsNormals[dispNormals + 1];
            double normalY = longNormalY;
            long longNormalZ = this.facetsNormals[dispNormals + 2];
            double normalZ = longNormalZ;
            double normalAbs = Orthonormal3DBasis.length((double)normalX, (double)normalY, (double)normalZ);
            if (normalAbs <= 0.0) {
                throw new AssertionError((Object)("Floating-point square of non-zero integer normal vector " + normalAbs + "^2 must be positive (" + normalX + ", " + normalY + ", " + normalZ + ")"));
            }
            double normalInv = 1.0 / normalAbs;
            int dispVA = 3 * this.facetsVertices[dispF];
            long x = this.verticesXYZ[dispVA];
            long y = this.verticesXYZ[dispVA + 1];
            long z = this.verticesXYZ[dispVA + 2];
            tripleProduct.setToLongLongProduct(longNormalX, x);
            tripleProduct.addLongLongProduct(longNormalY, y);
            tripleProduct.addLongLongProduct(longNormalZ, z);
            if (tripleProduct.isNegative()) {
                throw new AssertionError((Object)("A*" + x + " + B*" + y + " + C*" + z + " = " + String.valueOf(tripleProduct) + ", but it must be >=0 for correct normal vectors: (0,0,0) must be inside the polyhedron!"));
            }
            normalX *= normalInv;
            normalY *= normalInv;
            normalZ *= normalInv;
            double d = tripleProduct.toDouble() * this.xyzScale * normalInv;
            if (d < 0.0) {
                throw new AssertionError((Object)("Non-negative 128-bit number " + String.valueOf(tripleProduct) + " is converted to negative double " + d + "!"));
            }
            this.facetsEquations[dispF] = normalX;
            this.facetsEquations[dispF + 1] = normalY;
            this.facetsEquations[dispF + 2] = normalZ;
            this.facetsEquations[dispF + 3] = d;
            int dispVB = 3 * this.facetsVertices[dispF + 1];
            double pX = this.xyzScale * (double)(this.verticesXYZ[dispVB] - x);
            double pY = this.xyzScale * (double)(this.verticesXYZ[dispVB + 1] - y);
            double pZ = this.xyzScale * (double)(this.verticesXYZ[dispVB + 2] - z);
            double pSqr = Orthonormal3DBasis.lengthSquare((double)pX, (double)pY, (double)pZ);
            if (Math.abs(pSqr - (lengthAB = 2.0 * this.generatrixSet.segmentHalfLengths[this.edgesGeneratrixSegmentIndexes[this.facetsEdges[dispF]]]) * lengthAB) > Math.scalb(pSqr, -20)) {
                throw new AssertionError((Object)("Edge #" + this.facetsEdges[dispF] + ": length " + Math.sqrt(pSqr) + " is not equal to generatrix segment double length " + lengthAB));
            }
            this.facetsPN[dispNormals] = pY * normalZ - pZ * normalY;
            this.facetsPN[dispNormals + 1] = pZ * normalX - pX * normalZ;
            this.facetsPN[dispNormals + 2] = pX * normalY - pY * normalX;
            int dispVD = 3 * this.facetsVertices[dispF + 3];
            double qX = this.xyzScale * (double)(this.verticesXYZ[dispVD] - x);
            double qY = this.xyzScale * (double)(this.verticesXYZ[dispVD + 1] - y);
            double qZ = this.xyzScale * (double)(this.verticesXYZ[dispVD + 2] - z);
            double qSqr = Orthonormal3DBasis.lengthSquare((double)qX, (double)qY, (double)qZ);
            double lengthDA = 2.0 * this.generatrixSet.segmentHalfLengths[this.edgesGeneratrixSegmentIndexes[this.facetsEdges[dispF + 3]]];
            this.facetsQN[dispNormals] = qY * normalZ - qZ * normalY;
            this.facetsQN[dispNormals + 1] = qZ * normalX - qX * normalZ;
            this.facetsQN[dispNormals + 2] = qX * normalY - qY * normalX;
            if (Math.abs(qSqr - lengthDA * lengthDA) > Math.scalb(qSqr, -20)) {
                throw new AssertionError((Object)("Edge #" + this.facetsEdges[dispF + 3] + ": length " + Math.sqrt(qSqr) + " is not equal to generatrix segment double length " + lengthDA));
            }
            double pqX = pY * qZ - pZ * qY;
            double pqY = pZ * qX - pX * qZ;
            double pqZ = pX * qY - pY * qX;
            double pqn = pqX * normalX + pqY * normalY + pqZ * normalZ;
            double area = this.facetsAreas[kF];
            if (Math.abs(pqn - area) > Math.scalb(Math.abs(area), -10)) {
                throw new AssertionError((Object)("Facet #" + kF + ": oriented area " + area + " is not equal to triple product pqn " + pqn + "; p=(" + pX + "," + pY + "," + pZ + "), q=(" + qX + "," + qY + "," + qZ + "), n=(" + normalX + "," + normalY + "," + normalZ + ")"));
            }
            ++kF;
            dispF += 4;
            dispNormals += 3;
        }
    }

    private void calculateGoodBases() {
        MutableInt128 workInt128 = new MutableInt128();
        int disp = 0;
        int dispIJK = 0;
        while (disp < this.generatrixSet.xyzLength) {
            long kz;
            long ky;
            long kx;
            int jz;
            int jy;
            int jx;
            int zAbs;
            int yAbs;
            int x = this.generatrixSet.intXYZ[disp];
            int y = this.generatrixSet.intXYZ[disp + 1];
            int z = this.generatrixSet.intXYZ[disp + 2];
            assert (x != 0 || y != 0 || z != 0) : "Zero generatrix segment components";
            long lengthISqr = Orthonormal3DBasis.lengthSquareInteger((long)x, (long)y, (long)z);
            double lengthI = StrictMath.sqrt(lengthISqr);
            assert (lengthI > 0.0) : "sum of squares of non-zero 25-bit integers " + x + "^2 + " + y + "^2 + " + z + "^2 cannot be <= 0.0; " + lengthI;
            double lengthIInv = 1.0 / lengthI;
            this.generatrixSegmentsIJK[dispIJK] = (double)x * lengthIInv;
            this.generatrixSegmentsIJK[dispIJK + 1] = (double)y * lengthIInv;
            this.generatrixSegmentsIJK[dispIJK + 2] = (double)z * lengthIInv;
            int xAbs = Math.abs(x);
            int minAbs = Math.min(xAbs, Math.min(yAbs = Math.abs(y), zAbs = Math.abs(z)));
            if (minAbs == zAbs) {
                jx = -y;
                jy = x;
                jz = 0;
                kx = -((long)z) * (long)x;
                ky = -((long)z) * (long)y;
                kz = (long)x * (long)x + (long)y * (long)y;
            } else if (minAbs == yAbs) {
                jx = z;
                jy = 0;
                jz = -x;
                kx = -((long)y) * (long)x;
                ky = (long)x * (long)x + (long)z * (long)z;
                kz = -((long)y) * (long)z;
            } else {
                jx = 0;
                jy = -z;
                jz = y;
                kx = (long)y * (long)y + (long)z * (long)z;
                ky = -((long)x) * (long)y;
                kz = -((long)x) * (long)z;
            }
            assert (x * jx + y * jy + z * jz == 0);
            long lengthJSqr = Orthonormal3DBasis.lengthSquareInteger((long)jx, (long)jy, (long)jz);
            double lengthJ = StrictMath.sqrt(lengthJSqr);
            assert (lengthJ > 0.0) : "sum of squares of non-zero 25-bit integers " + jx + "^2 + " + jy + "^2 + " + jz + "^2 cannot be <= 0.0; " + lengthJ;
            double lengthJInv = 1.0 / lengthJ;
            this.generatrixSegmentsIJK[dispIJK + 3] = (double)jx * lengthJInv;
            this.generatrixSegmentsIJK[dispIJK + 4] = (double)jy * lengthJInv;
            this.generatrixSegmentsIJK[dispIJK + 5] = (double)jz * lengthJInv;
            workInt128.setToLongLongProduct(lengthISqr, lengthJSqr);
            double lengthK = StrictMath.sqrt(workInt128.toDouble());
            assert (lengthK > 0.0) : "sum of squares of non-zero 50-bit long integers " + kx + "^2 + " + ky + "^2 + " + kz + "^2 cannot be <= 0.0; " + lengthK;
            double lengthKInv = 1.0 / lengthK;
            this.generatrixSegmentsIJK[dispIJK + 6] = (double)kx * lengthKInv;
            this.generatrixSegmentsIJK[dispIJK + 7] = (double)ky * lengthKInv;
            this.generatrixSegmentsIJK[dispIJK + 8] = (double)kz * lengthKInv;
            disp += 3;
            dispIJK += 9;
        }
    }

    private void calculateDegenerated() {
        Arrays.fill(this.degeneratedEdges, 0, this.numberOfEdges, (byte)0);
        if (this.numberOfFacets <= 2) {
            assert (this.numberOfEdges <= 4);
            assert (this.numberOfVertices <= 4);
            Arrays.fill(this.degeneratedVertices, 0, this.numberOfVertices, (byte)0);
        } else {
            MutableInt128 temp1 = new MutableInt128();
            MutableInt128 temp2 = new MutableInt128();
            int kE = 0;
            int dispE = 0;
            while (kE < this.numberOfEdges) {
                int f1 = this.edgesFacets[dispE];
                int f2 = this.edgesFacets[dispE + 1];
                assert (f1 != -1);
                assert (f2 != -1);
                int dispNormals1 = 3 * f1;
                long x1 = this.facetsNormals[dispNormals1];
                long y1 = this.facetsNormals[dispNormals1 + 1];
                long z1 = this.facetsNormals[dispNormals1 + 2];
                int dispNormals2 = 3 * f2;
                long x2 = this.facetsNormals[dispNormals2];
                long y2 = this.facetsNormals[dispNormals2 + 1];
                long z2 = this.facetsNormals[dispNormals2 + 2];
                boolean exactlyDegenerated = Collinearity.collinear((long)x1, (long)y1, (long)z1, (long)x2, (long)y2, (long)z2, (MutableInt128)temp1, (MutableInt128)temp2) && Collinearity.alsoCodirectional((long)x1, (long)y1, (long)z1, (long)x2, (long)y2, (long)z2);
                int dispEquations1 = 4 * f1;
                int dispEquations2 = 4 * f2;
                double nx1 = this.facetsEquations[dispEquations1];
                double ny1 = this.facetsEquations[dispEquations1 + 1];
                double nz1 = this.facetsEquations[dispEquations1 + 2];
                double nx2 = this.facetsEquations[dispEquations2];
                double ny2 = this.facetsEquations[dispEquations2 + 1];
                double nz2 = this.facetsEquations[dispEquations2 + 2];
                boolean almostDegenerated = Math.abs(nx1 - nx2) <= 1.0E-5 && Math.abs(ny1 - ny2) <= 1.0E-5 && Math.abs(nz1 - nz2) <= 1.0E-5;
                this.degeneratedEdges[kE] = (byte)((exactlyDegenerated ? 1 : 0) | (almostDegenerated ? 2 : 0));
                ++kE;
                dispE += 2;
            }
            Arrays.fill(this.degeneratedVertices, 0, this.numberOfVertices, (byte)3);
            kE = 0;
            dispE = 0;
            while (kE < this.numberOfEdges) {
                byte degeneratedEdge = this.degeneratedEdges[kE];
                int n = this.edgesVertices[dispE];
                this.degeneratedVertices[n] = (byte)(this.degeneratedVertices[n] & degeneratedEdge);
                int n2 = this.edgesVertices[dispE + 1];
                this.degeneratedVertices[n2] = (byte)(this.degeneratedVertices[n2] & degeneratedEdge);
                ++kE;
                dispE += 2;
            }
        }
        this.numberOfExactlyDegeneratedEdges = KernelPolyhedron.numberOfDegenerated(this.degeneratedEdges, this.numberOfEdges, 1);
        this.numberOfExactlyDegeneratedVertices = KernelPolyhedron.numberOfDegenerated(this.degeneratedVertices, this.numberOfVertices, 1);
        this.numberOfAlmostDegeneratedEdges = KernelPolyhedron.numberOfDegenerated(this.degeneratedEdges, this.numberOfEdges, 2);
        this.numberOfAlmostDegeneratedVertices = KernelPolyhedron.numberOfDegenerated(this.degeneratedVertices, this.numberOfVertices, 2);
    }

    private void calculateMinMax() {
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        double minZ = 0.0;
        double maxZ = 0.0;
        double maxDistance = 0.0;
        int kV = 0;
        int dispV = 0;
        while (kV < this.numberOfVertices) {
            double d;
            double x = this.xyzScale * (double)this.verticesXYZ[dispV];
            double y = this.xyzScale * (double)this.verticesXYZ[dispV + 1];
            double z = this.xyzScale * (double)this.verticesXYZ[dispV + 2];
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (z > maxZ) {
                maxZ = z;
            }
            if ((d = Math.sqrt(x * x + y * y + z * z)) > maxDistance) {
                maxDistance = d;
            }
            ++kV;
            dispV += 3;
        }
        this.minCenteredX = minX - this.generatrixRadius;
        this.maxCenteredX = maxX + this.generatrixRadius;
        this.minCenteredY = minY - this.generatrixRadius;
        this.maxCenteredY = maxY + this.generatrixRadius;
        this.minCenteredZ = minZ - this.generatrixRadius;
        this.maxCenteredZ = maxZ + this.generatrixRadius;
        this.containingSphereRadius = maxDistance + this.generatrixRadius;
        this.containingSphereRadiusInv = 1.0 / this.containingSphereRadius;
    }

    private void ensureCapacity(int newVertices, int newEdges, int newFacets, boolean dynamicBuilding) {
        if (KernelPolyhedron.unsigned(newVertices) > (long)this.maxNumberOfVertices) {
            this.maxNumberOfVertices = dynamicBuilding ? KernelPolyhedron.increaseCapacity(KernelPolyhedron.unsigned(newVertices), this.maxNumberOfVertices, "vertices") : newVertices;
            this.verticesXYZ = Arrays.copyOf(this.verticesXYZ, 3 * this.maxNumberOfVertices);
            this.vertexCodes = Arrays.copyOf(this.vertexCodes, this.maxNumberOfVertices);
            this.newEdgesIncidentToVertex = Arrays.copyOf(this.newEdgesIncidentToVertex, this.maxNumberOfVertices);
        }
        if (newEdges > this.maxNumberOfEdges) {
            this.maxNumberOfEdges = dynamicBuilding ? KernelPolyhedron.increaseCapacity(KernelPolyhedron.unsigned(newEdges), this.maxNumberOfEdges, "edges") : newEdges;
            this.edgesGeneratrixSegmentIndexes = Arrays.copyOf(this.edgesGeneratrixSegmentIndexes, this.maxNumberOfEdges);
            this.edgesVertices = Arrays.copyOf(this.edgesVertices, 2 * this.maxNumberOfEdges);
            this.edgesOrderedAlongGeneratrix = Arrays.copyOf(this.edgesOrderedAlongGeneratrix, this.maxNumberOfEdges);
            this.edgesCompanionIndex = Arrays.copyOf(this.edgesCompanionIndex, this.maxNumberOfEdges);
        }
        if (KernelPolyhedron.unsigned(newFacets) > (long)this.maxNumberOfFacets) {
            this.maxNumberOfFacets = dynamicBuilding ? KernelPolyhedron.increaseCapacity(KernelPolyhedron.unsigned(newFacets), this.maxNumberOfFacets, "facets") : newFacets;
            this.facetsVertices = Arrays.copyOf(this.facetsVertices, 4 * this.maxNumberOfFacets);
            this.facetsEdges = Arrays.copyOf(this.facetsEdges, 4 * this.maxNumberOfFacets);
            this.facetsNormals = Arrays.copyOf(this.facetsNormals, 3 * this.maxNumberOfFacets);
            this.facetsAreas = Arrays.copyOf(this.facetsAreas, this.maxNumberOfFacets);
            this.facetCodes = Arrays.copyOf(this.facetCodes, this.maxNumberOfFacets);
        }
    }

    private void ensurePostprocessCapacity() {
        if (this.degeneratedVertices.length < this.numberOfVertices) {
            this.degeneratedVertices = new byte[this.numberOfVertices];
        }
        assert (this.edgesFacets.length == 2 * this.degeneratedEdges.length);
        if (this.degeneratedEdges.length < this.numberOfEdges) {
            this.edgesFacets = new int[2 * this.numberOfEdges];
            this.degeneratedEdges = new byte[this.numberOfEdges];
        }
        assert (this.facetsPN.length == 3 * (this.facetsEquations.length / 4));
        assert (this.facetsQN.length == this.facetsPN.length);
        if (this.facetsEquations.length < 4 * this.numberOfFacets) {
            this.facetsEquations = new double[4 * this.numberOfFacets];
            this.facetsPN = new double[3 * this.numberOfFacets];
            this.facetsQN = new double[3 * this.numberOfFacets];
        }
        if (this.generatrixSegmentsIJK.length < 9 * this.generatrixSet.numberOfGeneratrixSegments) {
            this.generatrixSegmentsIJK = new double[9 * this.generatrixSet.numberOfGeneratrixSegments];
        }
    }

    private void freeWorkMemoryForMinkowskiAdding() {
        this.vertexCodes = null;
        this.facetCodes = null;
        this.newEdgesIncidentToVertex = null;
        this.edgesCompanionIndex = null;
    }

    private static int increaseCapacity(long required, long existing, String objectsName) {
        long result = Math.max(16L, Math.max(required, 2L * existing));
        if (result >= 0x1FFFFFFFL) {
            throw new TooLargeArrayException("Too large array required for building sphere-polyhedron: cannot allocate " + result + " >= 536870911 " + objectsName);
        }
        return (int)result;
    }

    private static long unsigned(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    private static int numberOfDegenerated(byte[] values, int length, int flag) {
        int result = 0;
        for (int k = 0; k < length; ++k) {
            byte value = values[k];
            if ((value & flag) == 0) continue;
            ++result;
        }
        return result;
    }
}

