/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.packing;

import java.util.Objects;
import java.util.Random;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.geometries.SpherePolyhedraPackingGeometry;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestrictionFactory;
import net.algart.model3d.spherepolyhedra.objects.BestTouchingPositionFinder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrionModifier;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrionStraightChooser;
import net.algart.model3d.spherepolyhedra.packing.ImpossibleToPackException;

public abstract class SpherePolyhedraPacker
implements SpherePolyhedrionStraightChooser {
    final SpherePolyhedra spherePolyhedra;
    final SpherePolyhedraPackingGeometry geometry;
    final Random random;
    SpherePolyhedrionStraightChooser straightChooser = this;
    SpherePolyhedrionModifier modifier = SpherePolyhedrionModifier.EMPTY;
    PackingRestrictionFactory restrictionFactory = PackingRestrictionFactory.EMPTY;
    int numberOfCheckedPositions = 1;
    BestTouchingPositionFinder.Settings positionFinderSettings = new BestTouchingPositionFinder.Settings();

    protected SpherePolyhedraPacker(SpherePolyhedra spherePolyhedra, SpherePolyhedraPackingGeometry geometry, long randSeed) {
        this.spherePolyhedra = Objects.requireNonNull(spherePolyhedra, "Null sphere-polyhedra array");
        this.geometry = Objects.requireNonNull(geometry, "Null packing geometry");
        this.random = new Random(randSeed ^ 0x9DL);
    }

    public SpherePolyhedra spherePolyhedra() {
        return this.spherePolyhedra;
    }

    public SpherePolyhedraPackingGeometry geometry() {
        return this.geometry;
    }

    public SpherePolyhedrionStraightChooser getStraightChooser() {
        return this.straightChooser;
    }

    public SpherePolyhedraPacker setStraightChooser(SpherePolyhedrionStraightChooser straightChooser) {
        this.straightChooser = Objects.requireNonNull(straightChooser);
        return this;
    }

    public SpherePolyhedrionModifier getModifier() {
        return this.modifier;
    }

    public SpherePolyhedraPacker setModifier(SpherePolyhedrionModifier modifier) {
        this.modifier = Objects.requireNonNull(modifier, "Null modifier");
        return this;
    }

    public PackingRestrictionFactory getRestrictionFactory() {
        return this.restrictionFactory;
    }

    public SpherePolyhedraPacker setRestrictionFactory(PackingRestrictionFactory restrictionFactory) {
        this.restrictionFactory = Objects.requireNonNull(restrictionFactory, "Null restriction factory");
        return this;
    }

    public int getNumberOfCheckedPositions() {
        return this.numberOfCheckedPositions;
    }

    public SpherePolyhedraPacker setNumberOfCheckedPositions(int numberOfCheckedPositions) {
        if (numberOfCheckedPositions < 0) {
            throw new IllegalArgumentException("Zero or negative numberOfCheckedPositions=" + numberOfCheckedPositions);
        }
        this.numberOfCheckedPositions = numberOfCheckedPositions;
        return this;
    }

    public BestTouchingPositionFinder.Settings getPositionFinderSettings() {
        return this.positionFinderSettings;
    }

    public SpherePolyhedraPacker setPositionFinderSettings(BestTouchingPositionFinder.Settings positionFinderSettings) {
        this.positionFinderSettings = Objects.requireNonNull(positionFinderSettings, "Null turning settings");
        return this;
    }

    public Random getRandom() {
        return this.random;
    }

    @Override
    public boolean chooseStraight(StraightLine3D result, SpherePolyhedrion objectToPack, Random random) {
        return this.geometry.randomPackingDirection(result, objectToPack, random);
    }

    public final SpherePolyhedrion pack(SpherePolyhedrion objectToPack, SpherePolyhedronKind kind) throws ImpossibleToPackException {
        return this.pack(objectToPack, kind, true);
    }

    public final SpherePolyhedrion pack(SpherePolyhedrion objectToPack, SpherePolyhedronKind kind, boolean actuallyAddToSpherePolyhedra) throws ImpossibleToPackException {
        SpherePolyhedrion newPacked = this.tryFind(objectToPack, kind);
        if (newPacked == null) {
            throw new ImpossibleToPackException("Cannot find suitable position among " + this.numberOfCheckedPositions + " packing directions", objectToPack);
        }
        if (!this.geometry.isPositionAllowed(newPacked)) {
            throw new ImpossibleToPackException("Newly packed object violates geometry packing requirements", newPacked);
        }
        if (actuallyAddToSpherePolyhedra) {
            this.spherePolyhedra.add(newPacked);
        }
        return newPacked;
    }

    public SpherePolyhedrion tryFind(SpherePolyhedrion objectToPack, SpherePolyhedronKind kind) {
        SpherePolyhedrion newPacked = null;
        if (this.spherePolyhedra.numberOfSpherePolyhedra() == 0) {
            newPacked = this.geometry.packFirst(objectToPack);
        }
        if (newPacked == null) {
            newPacked = this.tryFindNewObjectPosition(objectToPack, kind);
        }
        return newPacked;
    }

    protected abstract SpherePolyhedrion tryFindNewObjectPosition(SpherePolyhedrion var1, SpherePolyhedronKind var2);
}

