/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarSlotValueWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalYearMonthFromFieldsNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToTemporalYearMonthNode
extends JavaScriptBaseNode {
    protected ToTemporalYearMonthNode() {
    }

    public abstract JSTemporalPlainYearMonthObject execute(Object var1, Object var2);

    @Specialization
    public JSTemporalPlainYearMonthObject toTemporalYearMonth(Object item, Object optionsParam, @Cached InlinedConditionProfile isObjectProfile, @Cached(value="create(getJSContext())") GetOptionsObjectNode getOptionsObject, @Cached InlinedBranchProfile errorBranch, @Cached IsObjectNode isObjectNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalCalendarSlotValueWithISODefaultNode getCalendarSlotValueWithISODefault, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode) {
        Object options = optionsParam;
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            if (item instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)((Object)item);
                Object resolvedOptions = getOptionsObject.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                return JSTemporalPlainYearMonth.create(this.getJSContext(), this.getRealm(), yearMonth.getYear(), yearMonth.getMonth(), yearMonth.getCalendar(), yearMonth.getDay(), this, errorBranch);
            }
            TruffleString calendar = getCalendarSlotValueWithISODefault.execute(item);
            List<TruffleString> fieldNames = TemporalUtil.listMMCY;
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getLanguage().getJSContext(), item, fieldNames, TemporalUtil.listEmpty);
            Object resolvedOptions = getOptionsObject.execute(options);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            return yearMonthFromFieldsNode.execute(calendar, fields, overflow);
        }
        if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalYearMonthString(string);
            TruffleString calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            }
            if (!TemporalUtil.isBuiltinCalendar(calendar)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorCalendarNotSupported();
            }
            Object resolvedOptions = getOptionsObject.execute(options);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            JSTemporalPlainYearMonthObject result2 = JSTemporalPlainYearMonth.create(this.getLanguage().getJSContext(), this.getRealm(), result.getYear(), result.getMonth(), calendar, result.getDay(), this, errorBranch);
            return yearMonthFromFieldsNode.execute(calendar, result2, overflow);
        }
        errorBranch.enter((Node)this);
        throw Errors.createTypeErrorNotAString(item);
    }
}

