/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarSlotValueWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneIdentifierNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.ParseISODateTimeResult;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToTemporalZonedDateTimeNode
extends JavaScriptBaseNode {
    protected ToTemporalZonedDateTimeNode() {
    }

    public abstract JSTemporalZonedDateTimeObject execute(Object var1, Object var2);

    @Specialization
    public JSTemporalZonedDateTimeObject toTemporalZonedDateTime(Object item, Object options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isZonedDateTimeProfile, @Cached IsObjectNode isObjectNode, @Cached(value="create(getJSContext())") GetOptionsObjectNode getOptionsObject, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier, @Cached GetTemporalCalendarSlotValueWithISODefaultNode getCalendarSlotValueWithISODefault, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode) {
        JSTemporalDateTimeRecord result;
        TemporalUtil.OffsetOption offsetOption;
        TemporalUtil.Disambiguation disambiguation;
        TruffleString timeZone;
        TruffleString calendar;
        TruffleString offsetString = null;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        TemporalUtil.OffsetBehaviour offsetBehaviour = TemporalUtil.OffsetBehaviour.OPTION;
        TemporalUtil.MatchBehaviour matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_EXACTLY;
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            if (isZonedDateTimeProfile.profile((Node)this, TemporalUtil.isTemporalZonedDateTime(item))) {
                Object resolvedOptions = getOptionsObject.execute(options);
                TemporalUtil.toTemporalDisambiguation(resolvedOptions, getOptionNode, equalNode);
                TemporalUtil.toTemporalOffset(resolvedOptions, TemporalConstants.REJECT, getOptionNode, equalNode);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                JSTemporalZonedDateTimeObject zdt = (JSTemporalZonedDateTimeObject)((Object)item);
                return JSTemporalZonedDateTime.create(ctx, realm, zdt.getNanoseconds(), zdt.getTimeZone(), zdt.getCalendar());
            }
            calendar = getCalendarSlotValueWithISODefault.execute(item);
            List<TruffleString> fieldNames = Boundaries.listEditableCopy(TemporalUtil.listDMMCY);
            ToTemporalZonedDateTimeNode.addFieldNames(fieldNames);
            JSObject fields = TemporalUtil.prepareTemporalFields(ctx, item, fieldNames, TemporalUtil.listTimeZone);
            Object timeZoneObj = JSObject.get((JSDynamicObject)fields, TemporalConstants.TIME_ZONE);
            timeZone = toTimeZoneIdentifier.execute(timeZoneObj);
            Object offsetStringObj = JSObject.get((JSDynamicObject)fields, TemporalConstants.OFFSET);
            if (offsetStringObj == Undefined.instance) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.WALL;
            } else {
                offsetString = (TruffleString)offsetStringObj;
            }
            Object resolvedOptions = getOptionsObject.execute(options);
            disambiguation = TemporalUtil.toTemporalDisambiguation(resolvedOptions, getOptionNode, equalNode);
            offsetOption = TemporalUtil.toTemporalOffset(resolvedOptions, TemporalConstants.REJECT, getOptionNode, equalNode);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            result = TemporalUtil.interpretTemporalDateTimeFields(calendar, (Object)fields, overflow, dateFromFieldsNode);
        } else if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            ParseISODateTimeResult resultZDT = TemporalUtil.parseTemporalZonedDateTimeString(string);
            result = resultZDT;
            TruffleString timeZoneName = resultZDT.getTimeZoneResult().getName();
            assert (timeZoneName != null);
            if (!TemporalUtil.canParseAsTimeZoneNumericUTCOffset(timeZoneName)) {
                timeZoneName = toTimeZoneIdentifier.execute(timeZoneName);
            }
            offsetString = resultZDT.getTimeZoneResult().getOffsetString();
            offsetBehaviour = resultZDT.getTimeZoneResult().isZ() ? TemporalUtil.OffsetBehaviour.EXACT : TemporalUtil.OffsetBehaviour.WALL;
            timeZone = timeZoneName;
            calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            }
            if (!TemporalUtil.isBuiltinCalendar(calendar)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorCalendarNotSupported();
            }
            matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_MINUTES;
            Object resolvedOptions = getOptionsObject.execute(options);
            disambiguation = TemporalUtil.toTemporalDisambiguation(resolvedOptions, getOptionNode, equalNode);
            offsetOption = TemporalUtil.toTemporalOffset(resolvedOptions, TemporalConstants.REJECT, getOptionNode, equalNode);
            TemporalUtil.toTemporalOverflow(resolvedOptions, getOptionNode);
        } else {
            errorBranch.enter((Node)this);
            throw Errors.createTypeErrorNotAString(item);
        }
        long offsetNanoseconds = 0L;
        if (offsetBehaviour == TemporalUtil.OffsetBehaviour.OPTION) {
            offsetNanoseconds = TemporalUtil.parseTimeZoneOffsetString(offsetString);
        }
        BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), offsetBehaviour, offsetNanoseconds, timeZone, disambiguation, offsetOption, matchBehaviour);
        return JSTemporalZonedDateTime.create(ctx, realm, epochNanoseconds, timeZone, calendar);
    }

    @CompilerDirectives.TruffleBoundary
    private static void addFieldNames(List<TruffleString> fieldNames) {
        fieldNames.add(TemporalConstants.HOUR);
        fieldNames.add(TemporalConstants.MICROSECOND);
        fieldNames.add(TemporalConstants.MILLISECOND);
        fieldNames.add(TemporalConstants.MINUTE);
        fieldNames.add(TemporalConstants.NANOSECOND);
        fieldNames.add(TemporalConstants.OFFSET);
        fieldNames.add(TemporalConstants.SECOND);
        fieldNames.add(TemporalConstants.TIME_ZONE);
    }
}

