/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespace;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespaceObject;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.CyclicModuleRecord;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractModuleRecord
extends ScriptOrModule {
    private JSModuleNamespaceObject namespace;
    private MaterializedFrame environment;
    private Object hostDefined;

    protected AbstractModuleRecord(JSContext context, Source source, Object hostDefined) {
        super(context, source);
        this.hostDefined = hostDefined;
    }

    public abstract JSPromiseObject loadRequestedModules(JSRealm var1, Object var2);

    public final void loadRequestedModulesSync(JSRealm realm, Object hostDefinedArg) {
        JSPromiseObject loadPromise = this.loadRequestedModules(realm, hostDefinedArg);
        assert (!JSPromise.isPending(loadPromise));
        JSPromise.throwIfRejected(loadPromise, realm);
    }

    public abstract void link(JSRealm var1);

    public abstract JSPromiseObject evaluate(JSRealm var1);

    @CompilerDirectives.TruffleBoundary
    public final Collection<TruffleString> getExportedNames() {
        return this.getExportedNames(new HashSet<JSModuleRecord>());
    }

    public abstract Collection<TruffleString> getExportedNames(Set<JSModuleRecord> var1);

    @CompilerDirectives.TruffleBoundary
    public final ExportResolution resolveExport(TruffleString exportName) {
        return this.resolveExport(exportName, new HashSet<Pair<? extends AbstractModuleRecord, TruffleString>>());
    }

    public abstract ExportResolution resolveExport(TruffleString var1, Set<Pair<? extends AbstractModuleRecord, TruffleString>> var2);

    public final JSModuleNamespaceObject getModuleNamespaceOrNull() {
        return this.namespace;
    }

    @CompilerDirectives.TruffleBoundary
    public final JSModuleNamespaceObject getModuleNamespace() {
        JSModuleNamespaceObject ns;
        CyclicModuleRecord cyclicModule;
        AbstractModuleRecord abstractModuleRecord;
        if (this.namespace != null) {
            return this.namespace;
        }
        assert (!((abstractModuleRecord = this) instanceof CyclicModuleRecord) || (cyclicModule = (CyclicModuleRecord)abstractModuleRecord).getStatus() != CyclicModuleRecord.Status.New) : this;
        Collection<TruffleString> exportedNames = this.getExportedNames();
        ArrayList<Map.Entry<TruffleString, ExportResolution>> unambiguousNames = new ArrayList<Map.Entry<TruffleString, ExportResolution>>();
        for (TruffleString exportedName : exportedNames) {
            ExportResolution resolution = this.resolveExport(exportedName);
            if (resolution.isNull()) {
                throw Errors.createSyntaxError("Could not resolve export");
            }
            if (resolution.isAmbiguous()) continue;
            unambiguousNames.add(Map.entry(exportedName, resolution));
        }
        unambiguousNames.sort((a, b) -> ((TruffleString)a.getKey()).compareCharsUTF16Uncached((AbstractTruffleString)b.getKey()));
        this.namespace = ns = JSModuleNamespace.create(this.getContext(), JSRealm.get(null), this, unambiguousNames);
        return ns;
    }

    public abstract Object getModuleSource();

    public final MaterializedFrame getEnvironment() {
        return this.environment;
    }

    public final void setEnvironment(MaterializedFrame environment) {
        assert (this.environment == null);
        this.environment = environment;
    }

    protected final void clearEnvironment() {
        this.environment = null;
    }

    public FrameDescriptor getFrameDescriptor() {
        return this.environment.getFrameDescriptor();
    }

    public final Object getHostDefined() {
        return this.hostDefined;
    }
}

