/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class BaseViewerDataSource
implements ViewerDataSource {
    protected ViewerData viewerData = null;
    private List<ViewerDataSource.ChangeViewerDataListener> listeners = new ArrayList<ViewerDataSource.ChangeViewerDataListener>();

    @Override
    public CompletableFuture<Void> rqViewerData() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void addListener(ViewerDataSource.ChangeViewerDataListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDataListener(ViewerDataSource.ChangeViewerDataListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyDataReceivedSuccess(ViewerData viewerData) {
        this.listeners.forEach(listener -> listener.onViewerDataReceived(viewerData));
    }

    protected void notifyDataReceivedFailed(Throwable t) {
        this.listeners.forEach(listener -> listener.onViewerDataErrorReceived(t));
    }

    @Override
    public void setData(ViewerData viewerData) {
        this.viewerData = viewerData;
    }

    @Override
    public Optional<ViewerData> getData() {
        return Optional.ofNullable(this.viewerData);
    }

    public void release() {
        this.listeners.clear();
        if (this.viewerData != null) {
            this.viewerData.release();
        }
    }
}

