/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ImageBorderViewerModel;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewer;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerControls;
import com.siams.cv.monitor.viewers.ui.content.IBaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.IRasterViewerContent;
import com.siams.cv.monitor.viewers.ui.content.ImageBorderViewerControls;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.stare.utils.MaskToColor;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.cv.matrices.drawing.DrawLabels;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyOperation;
import net.algart.executors.modules.cv.matrices.morphology.StrictMorphology;
import org.apache.log4j.Logger;

public class ImageBorderViewer
extends BaseImageViewer<ImageBorderViewerModel> {
    private final Logger logger = Logger.getLogger(ImageBorderViewer.class);
    private ImageBorderViewerContent root;

    public ImageBorderViewer(ImageBorderViewerModel viewerModel) {
        super(viewerModel);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    protected void initializeRoot() {
        this.root = new ImageBorderViewerContent((ImageBorderViewerModel)this.viewerModel);
    }

    @Override
    protected void initializeControls() {
        super.initializeControls();
        this.initializeBorderColor();
    }

    private void initializeBorderColor() {
        this.root.cpBorderColor.setValue((Object)this.getBorderColor());
        this.root.cpBorderColor.setOnAction(event -> {
            ColorPicker colorPicker = (ColorPicker)event.getSource();
            this.setBorderColor((Color)colorPicker.getValue());
            this.viewerDataSource.getData().ifPresent(this::render);
            if (this.viewerStateHandler != null) {
                this.viewerStateHandler.onViewerStateChanged();
            }
        });
    }

    @Override
    protected IBaseImageViewerContent getBaseContent() {
        return this.root;
    }

    @Override
    public List<Node> provideTools() {
        List<Node> baseTools = super.provideTools();
        baseTools.add((Node)this.root.cpBorderColor);
        return baseTools;
    }

    @Override
    protected void render(ViewerData viewerData) {
        Data labels;
        long t1 = System.currentTimeMillis();
        if (!this.isEnabled()) {
            return;
        }
        if (this.imageViewRect == null) {
            return;
        }
        SMat sMat = this.extractDefaultData(viewerData);
        double scale = this.imageViewRect.getScale();
        int patternSize = (int)(1.0 / scale);
        DrawLabels drawLabels = new DrawLabels();
        drawLabels.getInputPort("labels").setData((Data)sMat);
        drawLabels.setConvertMonoToColor(false);
        if (scale > 1.0) {
            drawLabels.setScale((int)scale);
        }
        drawLabels.process();
        Data result = labels = drawLabels.getData();
        if (scale < 1.0) {
            StrictMorphology morphology = new StrictMorphology();
            morphology.setOperation(MorphologyOperation.DILATION);
            morphology.setPattern(MorphologyFilter.Shape.CUBE, patternSize);
            morphology.getInputPort("input").setData(labels);
            morphology.process();
            result = morphology.getData();
        }
        int width = (int)((SMat)labels).getDimX();
        int height = (int)((SMat)labels).getDimY();
        WritableImage borderMask = new WritableImage(width, height);
        MaskToColor maskToColor = new MaskToColor(borderMask.getPixelWriter(), (SMat)result, this.imageViewRect.getViewRect());
        maskToColor.getsMatIterator().setSMatOffset(0, 0);
        maskToColor.setColor(this.getBorderColor());
        maskToColor.process();
        this.setImage((Image)borderMask);
        this.drawImage((Image)borderMask);
        this.logger.trace((Object)String.format("ImageBorderViewer:renderImage (%d) ms", System.currentTimeMillis() - t1));
    }

    @Override
    protected BaseImageViewerControls createImageViewControls() {
        return new ImageBorderViewerControls(this);
    }

    public void setBorderColor(Color borderColor) {
        ((ImageBorderViewerModel)this.viewerModel).setBorderColor(borderColor.toString());
    }

    public Color getBorderColor() {
        try {
            return Color.valueOf((String)((ImageBorderViewerModel)this.viewerModel).getBorderColor());
        }
        catch (Throwable throwable) {
            return new Color(1.0, 1.0, 1.0, 1.0);
        }
    }

    @Override
    protected IRasterViewerContent getRasterViewerContent() {
        return this.root;
    }

    @Override
    public void renderImage(Image image) {
        this.rerender();
    }

    @Override
    public void restorePreference() {
        super.restorePreference();
    }

    @Override
    public void savePreference() {
        super.savePreference();
    }

    private class ImageBorderViewerContent
    extends BaseImageViewerContent<ImageBorderViewerModel> {
        private final ColorPicker cpBorderColor;

        private ImageBorderViewerContent(ImageBorderViewerModel viewerModel) {
            super(viewerModel);
            this.cpBorderColor = new ColorPicker();
        }

        @Override
        public void center() {
            double valX = (this.canvas.getWidth() - ImageBorderViewer.this.image.getWidth() * ImageBorderViewer.this.imageViewRect.getScale()) / 2.0;
            double valY = (this.canvas.getHeight() - ImageBorderViewer.this.image.getHeight() * ImageBorderViewer.this.imageViewRect.getScale()) / 2.0;
            ImageBorderViewer.this.imageViewRect.setX(valX);
            ImageBorderViewer.this.imageViewRect.setY(valY);
        }
    }
}

