/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.TableViewerModel;
import com.siams.cv.monitor.viewers.ui.content.TextViewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.VisibleResultMetaData;
import com.siams.fx.components.indicator.FxRunIndicator;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxPlatform;
import io.reactivex.annotations.Nullable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;

public class TableViewer
extends TextViewer<TableViewerModel> {
    private static final String[] COLUMN_NAMES_PORT_ID = new String[]{"column_names", "headers"};
    private SNumbers numbers;
    private TableViewerContent root;
    private static final DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);

    public TableViewer(TableViewerModel viewerModel) {
        super(viewerModel);
    }

    public void initialize() {
        this.initializeContent();
        this.initializeControls();
        this.restorePreference();
    }

    private void initializeContent() {
        this.root = new TableViewerContent();
    }

    @Override
    public void embed(Pane viewerContainer) {
        viewerContainer.getChildren().add((Object)this.root);
        PaneHelper.setAnchorZero((Node)this.root);
    }

    @Override
    public Pane provideControls() {
        AnchorPane wrapper = new AnchorPane();
        wrapper.getChildren().add((Object)this.root.toolbar);
        PaneHelper.setAnchorZero((Node)this.root.toolbar);
        return wrapper;
    }

    @Override
    public Node provideView() {
        return this.root;
    }

    @Override
    public List<Node> provideTools() {
        return this.root.toolbar.getItems();
    }

    @Override
    public String getText() {
        return this.viewerDataSource.getData().map(this::renderTextTable).orElse("");
    }

    @Override
    @Deprecated(since="Use setNumbers")
    public void setText(String text) {
    }

    public SNumbers getNumbers() {
        return this.numbers;
    }

    public void setNumbers(SNumbers numbers) {
        this.numbers = numbers;
    }

    @Override
    protected void initializeControls() {
        this.root.btnCopy.getStyleClass().add((Object)"copy");
        this.root.btnCopy.setTooltip((Tooltip)new StareTooltip("Copy viewer content to clipboard"));
        this.root.btnCopy.setOnAction(event -> this.root.runIndicator.progress(this.exportToClipboard(), "Copying to clipboard..."));
        this.root.btnSaveAsFile.getStyleClass().add((Object)"save-as-file");
        this.root.btnSaveAsFile.setTooltip((Tooltip)new StareTooltip("Save viewer content into file"));
        this.root.btnSaveAsFile.setOnAction(event -> this.root.runIndicator.progress(this.exportToFile(), "Copying to file..."));
        this.root.spPrecisionValue.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.applyPrecision((int)newValue);
            this.root.tvNumbers.refresh();
        });
        this.root.cbShowRowNumbers.setOnAction(e -> {
            this.root.cbEnumerateFromZero.setVisible(this.root.cbShowRowNumbers.isSelected());
            this.root.cbEnumerateFromZero.setManaged(this.root.cbShowRowNumbers.isSelected());
            this.viewerDataSource.getData().ifPresent(this::render);
        });
        this.root.cbEnumerateFromZero.setOnAction(e -> this.viewerDataSource.getData().ifPresent(this::render));
    }

    @Override
    protected void render(ViewerData viewerData) {
        this.numbers = this.extractNumbers(viewerData).orElseThrow(() -> new RuntimeException("Failed display numerical data. Data not found"));
        int blockLength = this.numbers.getBlockLength();
        FxPlatform.RunFxThread(() -> this.root.lbHeader.setText(this.numbers.toString(false)));
        List columnNames = this.findColumnNames(viewerData).map(SScalar::toTrimmedLines).orElse(null);
        this.createColumns(blockLength, columnNames);
        FxPlatform.RunFxThread(() -> {
            this.root.tvNumbers.getItems().clear();
            for (int i = 0; i < this.numbers.n(); ++i) {
                double[] values = new double[blockLength];
                this.numbers.getBlockDoubleValues(i, values);
                NumbersRow row = new NumbersRow(i, values);
                this.root.tvNumbers.getItems().add((Object)row);
            }
        });
    }

    public void restorePreference() {
        int precision = this.getPreferredInt("Precision", 10);
        this.root.spPrecisionValue.getValueFactory().setValue((Object)precision);
        this.applyPrecision(precision);
    }

    public void savePreference() {
        this.putPreferredInt("Precision", (Integer)this.root.spPrecisionValue.getValue());
    }

    private Optional<SNumbers> extractNumbers(ViewerData viewerData) {
        VisibleResultMetaData meta = viewerData.getMeta();
        return meta.getPorts().stream().filter(port -> viewerData.get(port.getName(), SNumbers.class).isPresent()).findFirst().flatMap(port -> viewerData.get(port.getName(), SNumbers.class));
    }

    private Optional<SScalar> findColumnNames(ViewerData viewerData) {
        for (String name : COLUMN_NAMES_PORT_ID) {
            Optional<SScalar> result = viewerData.get(name, SScalar.class);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private void createColumns(int columnNumber, @Nullable List<String> columnNames) {
        LinkedList<TableColumn> newColumns = new LinkedList<TableColumn>();
        if (this.root.cbShowRowNumbers.isSelected()) {
            boolean zeroNumeration = this.root.cbEnumerateFromZero.isSelected();
            TableColumn rowNumbers = new TableColumn("Row");
            rowNumbers.setCellValueFactory(cellDataFeatures -> {
                int index = ((NumbersRow)cellDataFeatures.getValue()).index;
                return new ReadOnlyObjectWrapper((Object)(zeroNumeration ? index : index + 1));
            });
            newColumns.add(rowNumbers);
        }
        for (int i = 0; i < columnNumber; ++i) {
            Column column = columnNames != null && i < columnNames.size() ? new Column(columnNames.get(i), i) : new Column(i);
            newColumns.add(column);
        }
        FxPlatform.RunFxThread(() -> {
            this.root.tvNumbers.getColumns().clear();
            this.root.tvNumbers.getColumns().addAll((Collection)newColumns);
        });
    }

    private void applyPrecision(int precision) {
        if (precision == 0) {
            formatter.applyPattern("#");
        } else {
            formatter.applyPattern("#." + "0".repeat(precision));
        }
    }

    private String renderTextTable(ViewerData viewerData) {
        String value;
        SNumbers sNumbers = this.extractNumbers(viewerData).orElseThrow(() -> new RuntimeException("Failed display numerical data. Data not found"));
        Locale locale = Locale.US;
        SNumbers.FormattingType formattingType = sNumbers.isFloatingPoint() ? SNumbers.FormattingType.DECIMAL_FORMAT : SNumbers.FormattingType.SIMPLE;
        SNumbers.Formatter formatter = sNumbers.getFormatter(formattingType, locale);
        formatter.setAddLineIndexes(this.root.cbShowRowNumbers.isSelected());
        formatter.setLineIndexStart(this.root.cbEnumerateFromZero.isSelected() ? 0 : 1);
        formatter.setElementsDelimiter(" ");
        formatter.setLineIndexFormat("#");
        if (formattingType == SNumbers.FormattingType.DECIMAL_FORMAT) {
            int precision = (Integer)this.root.spPrecisionValue.getValue();
            formatter.setElementsFormat((String)(precision > 0 ? "0." + "0".repeat(precision) : "#"));
        } else {
            formatter.setElementsFormat("%d");
        }
        List columnNames = this.findColumnNames(viewerData).map(SScalar::toTrimmedLines).orElse(Collections.emptyList());
        if (columnNames.isEmpty()) {
            int longestNumber = this.findLongestElement(sNumbers);
            formatter.setMinimalElementLength(longestNumber);
            int numbersColumnWidth = String.valueOf(sNumbers.n()).length();
            formatter.setMinimalLineIndexLength(numbersColumnWidth);
            value = formatter.format();
        } else {
            int longestName = columnNames.stream().map(String::length).max(Comparator.naturalOrder()).orElse(0);
            int longestNumber = this.findLongestElement(sNumbers);
            int columnWidth = Math.max(longestName, longestNumber);
            formatter.setMinimalElementLength(columnWidth);
            Object header = columnNames.stream().map(name -> " ".repeat(1 + columnWidth - name.length()) + name).collect(Collectors.joining());
            if (this.root.cbShowRowNumbers.isSelected()) {
                int numbersColumnWidth = String.valueOf(sNumbers.n()).length();
                formatter.setMinimalLineIndexLength(numbersColumnWidth);
                header = " ".repeat(numbersColumnWidth + 1) + (String)header;
            }
            value = String.join((CharSequence)"\n", ((String)header).substring(1), formatter.format());
        }
        return value;
    }

    private int findLongestElement(SNumbers sNumbers) {
        int longestNumber = String.valueOf(Math.floor(sNumbers.maxAbs(true))).length();
        int precision = (Integer)this.root.spPrecisionValue.getValue();
        longestNumber += precision;
        if (precision > 0) {
            ++longestNumber;
        }
        if (sNumbers.min(true) < 0.0) {
            ++longestNumber;
        }
        return longestNumber;
    }

    private static class TableViewerContent
    extends VBox {
        private static final Logger logger = Logger.getLogger(TableViewerContent.class.getCanonicalName());
        @FXML
        private ToolBar toolbar;
        @FXML
        private Button btnCopy;
        @FXML
        private Button btnSaveAsFile;
        @FXML
        private Spinner<Integer> spPrecisionValue;
        @FXML
        private CheckBox cbShowRowNumbers;
        @FXML
        private CheckBox cbEnumerateFromZero;
        @FXML
        private Label lbHeader;
        @FXML
        private AnchorPane apIndicatorContainer;
        private FxRunIndicator runIndicator;
        @FXML
        private TableView<NumbersRow> tvNumbers;

        private TableViewerContent() {
            try {
                CustomFXMLLoader.loadElement((Object)((Object)this));
                this.initializeRunIndicator();
            }
            catch (IOException e) {
                logger.severe(e.getMessage());
            }
        }

        private void initializeRunIndicator() {
            this.runIndicator = new FxRunIndicator();
            this.apIndicatorContainer.getChildren().add((Object)this.runIndicator);
            PaneHelper.setAnchorZero((Node)this.runIndicator);
        }
    }

    private static class Column
    extends TableColumn<NumbersRow, Number> {
        private Column(int index) {
            this(String.format("#%d", index), index);
        }

        private Column(String text, int index) {
            super(text);
            this.setCellValueFactory(cellDataFeatures -> {
                double value = ((NumbersRow)cellDataFeatures.getValue()).rowValues[index];
                if ((double)((int)value) == value) {
                    return new ReadOnlyObjectWrapper((Object)((int)value));
                }
                return new ReadOnlyObjectWrapper((Object)Double.parseDouble(formatter.format(value)));
            });
        }
    }

    private static class NumbersRow {
        private final int index;
        private final double[] rowValues;

        private NumbersRow(int index, double[] rowValues) {
            this.index = index;
            this.rowValues = rowValues;
        }
    }
}

