/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.stage.FileChooser;

public abstract class TextViewer<T extends ViewerModel>
extends Viewer<T> {
    public TextViewer(T viewerModel) {
        super(viewerModel);
    }

    public abstract void setText(String var1);

    public abstract String getText();

    protected CompletableFuture<Void> exportToClipboard() {
        return CompletableFuture.runAsync(() -> {
            String text = this.getText();
            FxPlatform.RunFxThread(() -> {
                ClipboardContent content = new ClipboardContent();
                content.putString(text);
                Clipboard.getSystemClipboard().setContent((Map)content);
                StareNotification.showInfo((String)"Copied to clipboard");
            });
        });
    }

    protected CompletableFuture<Void> exportToFile() {
        File fileToSave;
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Text", new String[]{"*.txt"});
        fileChooser.getExtensionFilters().add((Object)filter);
        fileChooser.setSelectedExtensionFilter(filter);
        String preferenceName = "text_viewer_export_numbers_dir";
        File initialDir = new File(this.getPreferredString("text_viewer_export_numbers_dir", System.getProperty("user.home")));
        if (initialDir.isDirectory()) {
            fileChooser.setInitialDirectory(initialDir);
        }
        if ((fileToSave = fileChooser.showSaveDialog(null)) != null) {
            this.putPreferredString("text_viewer_export_numbers_dir", fileToSave.getParentFile().getAbsolutePath());
        }
        return CompletableFuture.runAsync(() -> {
            try (PrintWriter writer = new PrintWriter(fileToSave);){
                writer.print(this.getText());
                StareNotification.showInfo((String)"Table saved");
            }
            catch (FileNotFoundException e) {
                StareNotification.showWarn((String)"Failed to write file");
            }
        });
    }

    @Override
    public void setViewerDataSource(ViewerDataSource viewerDataSource) {
        super.setViewerDataSource(viewerDataSource);
        this.rerender();
    }
}

