/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.model.viewer.TriangulationViewerModel;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewer;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.BaseImageViewerControls;
import com.siams.cv.monitor.viewers.ui.content.IBaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.IRasterViewerContent;
import com.siams.cv.monitor.viewers.ui.content.RasterViewer;
import com.siams.cv.monitor.viewers.ui.content.TriangulationViewerControls;
import com.siams.cv.monitor.viewers.ui.content.ViewRect;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.javafx.utils.FxPlatform;
import java.util.Arrays;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;

public class TriangulationViewer
extends BaseImageViewer<TriangulationViewerModel> {
    private static final Logger logger = Logger.getLogger(TriangulationViewer.class.getCanonicalName());
    private static final String[] PORT_IDS = new String[]{"points", "e2p", "e2s"};
    private TriangulationViewerContent root;
    private WritableImage triangulation;

    public TriangulationViewer(TriangulationViewerModel model) {
        super(model);
    }

    @Override
    public void initializeImageViewRect() {
        this.imageViewRect = new TriangulationViewRect();
    }

    @Override
    protected void initializeControls() {
        super.initializeControls();
        Pane rasterContainer = this.getBaseContent().getRasterContainer();
        Pane controls = this.provideControls();
        rasterContainer.getChildren().add((Object)controls);
        AnchorPane.setTopAnchor((Node)controls, (Double)7.0);
        AnchorPane.setRightAnchor((Node)controls, (Double)7.0);
        this.getPropertyOpacity().addListener((observableValue, oldValue, newValue) -> this.drawImage(this.image));
    }

    @Override
    protected void render(ViewerData viewerData) {
        boolean requiredInputsPresent = Arrays.stream(PORT_IDS).allMatch(id -> viewerData.getData().containsKey(id));
        if (!requiredInputsPresent) {
            logger.severe("TriangulationViewer viewer data miss required parts. All required inputs : " + String.join((CharSequence)", ", PORT_IDS));
            return;
        }
        SMat sMat = this.extractDefaultData(viewerData);
        WritableImage image = RasterViewer.writableImageFromSMat(sMat);
        this.setImage((Image)image);
        FxPlatform.RunFxThread(() -> {
            SNumbers points = viewerData.get("points", SNumbers.class).get();
            SNumbers e2p = viewerData.get("e2p", SNumbers.class).get();
            SNumbers e2s = viewerData.get("e2s", SNumbers.class).get();
            this.renderEdges(points, e2p, e2s);
            this.renderImage((Image)image);
        });
    }

    @Override
    public void onChangeZoomImageViewRect(ViewRect imageViewRect) {
        this.getViewerDataSource().getData().ifPresentOrElse(viewerData -> {
            SNumbers points = viewerData.get("points", SNumbers.class).get();
            SNumbers e2p = viewerData.get("e2p", SNumbers.class).get();
            SNumbers e2s = viewerData.get("e2s", SNumbers.class).get();
            this.renderEdges(points, e2p, e2s);
            this.drawImage(this.image);
        }, () -> logger.severe("TriangulationViewer has no ViewerData!"));
    }

    @Override
    public void drawImage(Image image) {
        if (!((TriangulationViewerModel)this.viewerModel).isHideImage()) {
            super.drawImage(image);
        } else {
            Canvas canvas = this.getBaseContent().getCanvas();
            GraphicsContext context = canvas.getGraphicsContext2D();
            context.clearRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        }
        this.drawTriangulation();
    }

    @Override
    protected IRasterViewerContent getRasterViewerContent() {
        return this.root;
    }

    @Override
    protected void initializeRoot() {
        this.root = new TriangulationViewerContent((TriangulationViewerModel)this.viewerModel);
    }

    @Override
    protected IBaseImageViewerContent getBaseContent() {
        return this.root;
    }

    @Override
    protected BaseImageViewerControls<TriangulationViewer> createImageViewControls() {
        return new TriangulationViewerControls(this);
    }

    public Color getEdgesColor() {
        try {
            return Color.valueOf((String)((TriangulationViewerModel)this.viewerModel).getEdgesColor());
        }
        catch (Throwable ignore) {
            return Color.WHITE;
        }
    }

    public void setEdgesColor(Color edgesColor) {
        ((TriangulationViewerModel)this.viewerModel).setEdgesColor(edgesColor.toString());
    }

    public Color getContoursColor() {
        try {
            return Color.valueOf((String)((TriangulationViewerModel)this.viewerModel).getContoursColor());
        }
        catch (Throwable ignore) {
            return Color.WHITE;
        }
    }

    public void setContoursColor(Color contoursColor) {
        ((TriangulationViewerModel)this.viewerModel).setContoursColor(contoursColor.toString());
    }

    private void renderEdges(SNumbers points, SNumbers edges, SNumbers isSegment) {
        assert (points.getBlockLength() >= 2);
        assert (edges.getBlockLength() >= 2);
        assert (edges.n() == isSegment.n());
        if (this.getOpacity() == 0.0) {
            return;
        }
        double scale = this.imageViewRect.getScale();
        int scaledWidth = (int)((this.image.getWidth() + 1.0) * scale);
        int scaledHeight = (int)((this.image.getHeight() + 1.0) * scale);
        this.triangulation = new WritableImage(scaledWidth, scaledHeight);
        Canvas vectorCanvas = new Canvas((double)scaledWidth, (double)scaledHeight);
        this.drawEdges(vectorCanvas, points, edges, isSegment);
        SnapshotParameters params = new SnapshotParameters();
        params.setFill((Paint)Color.TRANSPARENT);
        vectorCanvas.snapshot(params, this.triangulation);
    }

    private void drawEdges(Canvas canvas, SNumbers points, SNumbers edges, SNumbers isSegment) {
        GraphicsContext context = canvas.getGraphicsContext2D();
        double scale = this.imageViewRect.getScale();
        Color ec = this.getEdgesColor();
        Color edgesColorWithAlpha = Color.color((double)ec.getRed(), (double)ec.getGreen(), (double)ec.getBlue(), (double)(ec.getOpacity() * this.getOpacity()));
        Color cc = this.getContoursColor();
        Color contoursColorWithAlpha = Color.color((double)cc.getRed(), (double)cc.getGreen(), (double)cc.getBlue(), (double)(cc.getOpacity() * this.getOpacity()));
        context.setStroke((Paint)edgesColorWithAlpha);
        int[] pt = new int[points.getBlockLength()];
        int[] from = new int[points.getBlockLength()];
        int[] to = new int[points.getBlockLength()];
        int n = edges.n();
        for (int i = 0; i < n; ++i) {
            boolean segment;
            edges.getBlockValues(i, (Object)pt);
            points.getBlockValues(pt[0], (Object)from);
            points.getBlockValues(pt[1], (Object)to);
            boolean bl = segment = isSegment.getLongValue(i) == 1L;
            if (segment) {
                context.setStroke((Paint)contoursColorWithAlpha);
            } else {
                context.setStroke((Paint)edgesColorWithAlpha);
            }
            context.strokeLine((double)from[0] * scale, (double)from[1] * scale, (double)to[0] * scale, (double)to[1] * scale);
        }
    }

    private void drawTriangulation() {
        Canvas canvas = this.getBaseContent().getCanvas();
        GraphicsContext context = canvas.getGraphicsContext2D();
        int finalX = (int)(this.imageViewRect.getX() + this.imageViewRect.getTranslateX());
        int finalY = (int)(this.imageViewRect.getY() + this.imageViewRect.getTranslateY());
        context.save();
        context.setGlobalAlpha(this.getOpacity());
        context.drawImage((Image)this.triangulation, (double)finalX, (double)finalY);
        context.restore();
    }

    private static class TriangulationViewRect
    extends ViewRect {
        public TriangulationViewRect() {
            this.supportedScaleRangeMax = 32.0;
        }
    }

    private class TriangulationViewerContent
    extends BaseImageViewerContent<TriangulationViewerModel> {
        public TriangulationViewerContent(TriangulationViewerModel viewerModel) {
            super(viewerModel);
        }

        @Override
        public void center() {
            double valX = (this.canvas.getWidth() - TriangulationViewer.this.image.getWidth() * TriangulationViewer.this.imageViewRect.getScale()) / 2.0;
            double valY = (this.canvas.getHeight() - TriangulationViewer.this.image.getHeight() * TriangulationViewer.this.imageViewRect.getScale()) / 2.0;
            TriangulationViewer.this.imageViewRect.setX(valX);
            TriangulationViewer.this.imageViewRect.setY(valY);
        }
    }
}

