/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.viewers.ui.content;

import com.siams.cv.monitor.viewers.ui.content.ImageViewRectChangeListener;
import com.siams.general.Deletable;
import com.siams.stare.utils.Rect;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class ViewRect
implements Deletable {
    protected double x = 0.0;
    protected double y = 0.0;
    protected double imageWidth = 0.0;
    protected double imageHeight = 0.0;
    protected double scale = 1.0;
    protected final double scaleFactor = 2.0;
    protected double supportedScaleRangeMin = 0.125;
    protected double supportedScaleRangeMax = 16.0;
    protected double mousePressedX = 0.0;
    protected double mousePressedY = 0.0;
    protected double mouseTranslateX = 0.0;
    protected double mouseTranslateY = 0.0;
    protected Node panningNode = null;
    protected EventHandler<ScrollEvent> panningScrollHandler = null;
    protected EventHandler<MouseEvent> panningMousePressedHandler = null;
    protected EventHandler<MouseEvent> panningMouseMoveHandler = null;
    protected EventHandler<MouseEvent> panningMouseReleaseHandler = null;
    protected EventHandler<MouseEvent> panningMouseAnyHandler = null;
    protected boolean dragHappened = false;
    protected SimpleObjectProperty<Bounds> outerBoundsProperty = new SimpleObjectProperty();
    private final List<ImageViewRectChangeListener> listeners = new LinkedList<ImageViewRectChangeListener>();
    protected final PublishSubject<EventType> notifySubject = PublishSubject.create();
    protected final Disposable rxDisposer = this.notifySubject.throttleLast(45L, TimeUnit.MILLISECONDS).subscribe(eventType -> Platform.runLater(() -> this.notifyListeners(false, (EventType)((Object)eventType))));

    public void registerPanningNode(Node panning) {
        this.unregisterPanningNode();
        this.panningNode = panning;
        this.panningScrollHandler = this.panningScroll();
        this.panningMousePressedHandler = this.panningPressed();
        this.panningMouseMoveHandler = this.panningMove();
        this.panningMouseReleaseHandler = this.panningRelease();
        this.panningMouseAnyHandler = this.panningAny();
        panning.addEventHandler(ScrollEvent.SCROLL, this.panningScrollHandler);
        panning.addEventHandler(MouseEvent.MOUSE_PRESSED, this.panningMousePressedHandler);
        panning.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.panningMouseMoveHandler);
        panning.addEventHandler(MouseEvent.MOUSE_RELEASED, this.panningMouseReleaseHandler);
        panning.addEventHandler(MouseEvent.ANY, this.panningMouseAnyHandler);
    }

    public void registerOuterBounds(Node parentContainer) {
        Objects.requireNonNull(parentContainer, "Container required");
        this.unregisterOuterBounds();
        this.outerBoundsProperty.bind((ObservableValue)parentContainer.layoutBoundsProperty());
    }

    public void addListener(ImageViewRectChangeListener listener) {
        Objects.requireNonNull(listener, "Listener required");
        this.listeners.add(listener);
    }

    public void removeListener(ImageViewRectChangeListener listener) {
        Objects.requireNonNull(listener, "Listener required");
        this.listeners.remove(listener);
    }

    public double screenToImageX(double screenX) {
        return (screenX - this.x) / this.scale;
    }

    public double screenToImageY(double screenY) {
        return (screenY - this.y) / this.scale;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean setScale(double scale) {
        boolean success = false;
        boolean allowAny = true;
        if (this.supportedScaleRangeMin <= scale && scale <= this.supportedScaleRangeMax) {
            this.scale = scale;
            success = true;
        }
        return success;
    }

    public void setImageSize(double width, double height) {
        this.imageWidth = width;
        this.imageHeight = height;
    }

    public double getImageWidth() {
        return this.imageWidth;
    }

    public double getImageHeight() {
        return this.imageHeight;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getTranslateX() {
        return this.mouseTranslateX;
    }

    public double getTranslateY() {
        return this.mouseTranslateY;
    }

    public boolean isDragHappened() {
        return this.dragHappened;
    }

    public void zoomIn() {
        this.makeZoom(2.0);
    }

    public void zoomOut() {
        this.makeZoom(0.5);
    }

    public void zoomReset() {
        this.makeZoom(1.0 / this.scale);
    }

    public void release() {
        this.unregisterPanningNode();
        this.unregisterOuterBounds();
        this.outerBoundsProperty = null;
        this.listeners.clear();
        this.rxDisposer.dispose();
    }

    public Rect getViewRect() {
        return new Rect(0.0, 0.0, this.imageWidth, this.imageHeight);
    }

    protected void unregisterPanningNode() {
        if (this.panningNode != null) {
            if (this.panningScrollHandler != null) {
                this.panningNode.removeEventHandler(ScrollEvent.SCROLL, this.panningScrollHandler);
                this.panningScrollHandler = null;
            }
            if (this.panningMousePressedHandler != null) {
                this.panningNode.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.panningMousePressedHandler);
                this.panningMousePressedHandler = null;
            }
            if (this.panningMouseMoveHandler != null) {
                this.panningNode.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.panningMouseMoveHandler);
                this.panningMouseMoveHandler = null;
            }
            if (this.panningMouseReleaseHandler != null) {
                this.panningNode.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.panningMouseReleaseHandler);
                this.panningMouseReleaseHandler = null;
            }
            if (this.panningMouseAnyHandler != null) {
                this.panningNode.removeEventHandler(MouseEvent.ANY, this.panningMouseAnyHandler);
                this.panningMouseAnyHandler = null;
            }
            this.panningNode = null;
        }
    }

    protected void unregisterOuterBounds() {
        if (this.outerBoundsProperty.isBound()) {
            this.outerBoundsProperty.unbind();
        }
    }

    protected void notifyListeners(boolean debounce, EventType eventType) {
        if (debounce) {
            this.notifySubject.onNext((Object)eventType);
        } else {
            block5: for (ImageViewRectChangeListener listener : this.listeners) {
                listener.onChangeImageViewRect(this);
                switch (eventType.ordinal()) {
                    case 0: {
                        listener.onTranslateImageViewRect(this);
                        continue block5;
                    }
                    case 1: {
                        listener.onReleaseImageViewRect(this);
                        continue block5;
                    }
                    case 2: {
                        listener.onChangeZoomImageViewRect(this);
                        continue block5;
                    }
                }
                throw new RuntimeException(String.format("Unimplemented event type: %s", new Object[]{eventType}));
            }
        }
    }

    protected void makeZoom(double scaleFactor) {
        double cx = ((Bounds)this.outerBoundsProperty.getValue()).getWidth() / 2.0;
        double cy = ((Bounds)this.outerBoundsProperty.getValue()).getHeight() / 2.0;
        double hFraction = (cx - this.x) / this.scale / this.imageWidth;
        double vFraction = (cy - this.y) / this.scale / this.imageHeight;
        if (this.setScale(this.scale * scaleFactor)) {
            double oldScale;
            if (!(hFraction < 0.0)) {
                if (hFraction > 1.0) {
                    oldScale = this.scale / scaleFactor;
                    double rightX = this.x + this.imageWidth * oldScale;
                    this.setX(rightX - this.imageWidth * this.scale);
                } else {
                    this.setX(cx - this.imageWidth * this.scale * hFraction);
                }
            }
            if (!(vFraction < 0.0)) {
                if (vFraction > 1.0) {
                    oldScale = this.scale / scaleFactor;
                    double bottomY = this.y + this.imageHeight * oldScale;
                    this.setY(bottomY - this.imageHeight * this.scale);
                } else {
                    this.setY(cy - this.imageHeight * this.scale * vFraction);
                }
            }
        }
        this.notifyListeners(false, EventType.ZOOM);
    }

    protected EventHandler<ScrollEvent> panningScroll() {
        return event -> {
            if (event.getDeltaY() > 0.0) {
                this.makeZoom(2.0);
            } else {
                this.makeZoom(0.5);
            }
        };
    }

    protected EventHandler<MouseEvent> panningPressed() {
        return event -> {
            this.mousePressedX = event.getX();
            this.mousePressedY = event.getY();
            this.dragHappened = true;
        };
    }

    protected EventHandler<MouseEvent> panningMove() {
        return event -> {
            if (this.mousePressedX == -1.0 || this.mousePressedY == -1.0) {
                return;
            }
            this.mouseTranslateX = event.getX() - this.mousePressedX;
            this.mouseTranslateY = event.getY() - this.mousePressedY;
            this.notifyListeners(true, EventType.MOUSE_TRANSLATE);
        };
    }

    protected EventHandler<MouseEvent> panningRelease() {
        return event -> {
            this.setX(this.x + this.mouseTranslateX);
            this.setY(this.y + this.mouseTranslateY);
            this.mousePressedX = 0.0;
            this.mousePressedY = 0.0;
            this.mouseTranslateX = 0.0;
            this.mouseTranslateY = 0.0;
            this.notifyListeners(true, EventType.MOUSE_RELEASE);
        };
    }

    protected EventHandler<MouseEvent> panningAny() {
        return event -> {};
    }

    public String toString() {
        return "ViewRect{x=" + this.x + ", y=" + this.y + ", mouseTranslateX=" + this.mouseTranslateX + ", mouseTranslateY=" + this.mouseTranslateY + "}";
    }

    public static enum EventType {
        MOUSE_TRANSLATE,
        MOUSE_RELEASE,
        ZOOM;

    }
}

